
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Container for the flight segment data plus the MarriageGrp.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookFlightSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AirportInformationType" name="DepartureAirport"/>
 *     &lt;xs:element type="ns:AirportInformationType" name="ArrivalAirport"/>
 *     &lt;xs:element type="ns:OperatingAirlineType" name="OperatingAirline" minOccurs="0"/>
 *     &lt;xs:element type="ns:ResponseEquipmentType" name="Equipment" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:CompanyNameType" name="MarketingAirline" minOccurs="0"/>
 *     &lt;xs:element type="ns:CompanyNameType" name="DisclosureAirline" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarriageGrp" minOccurs="0"/>
 *     &lt;xs:element name="StopAirports" minOccurs="0">
 *       &lt;!-- Reference to inner class StopAirports -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="DepartureTimeZone" minOccurs="0">
 *       &lt;!-- Reference to inner class DepartureTimeZone -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ArrivalTimeZone" minOccurs="0">
 *       &lt;!-- Reference to inner class ArrivalTimeZone -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OnTimePerformance" minOccurs="0">
 *       &lt;!-- Reference to inner class OnTimePerformance -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="DepartureDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="StopQuantity"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InfoSource"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TourOperatorFlightID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
 *   &lt;xs:attribute type="ns:ActionCodeType" use="optional" name="ActionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
 *   &lt;xs:attribute type="xs:short" name="ElapsedTime"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookFlightSegmentType implements Serializable
{
    private AirportInformationType departureAirport;
    private AirportInformationType arrivalAirport;
    private OperatingAirlineType operatingAirline;
    private List<ResponseEquipmentType> equipmentList = new ArrayList<ResponseEquipmentType>();
    private CompanyNameType marketingAirline;
    private CompanyNameType disclosureAirline;
    private String marriageGrp;
    private StopAirports stopAirports;
    private DepartureTimeZone departureTimeZone;
    private ArrivalTimeZone arrivalTimeZone;
    private OnTimePerformance onTimePerformance;
    private TPAExtensions TPAExtensions1;
    private String departureDateTime;
    private String arrivalDateTime;
    private BigInteger stopQuantity;
    private String RPH;
    private String infoSource;
    private String flightNumber;
    private String tourOperatorFlightID;
    private String resBookDesigCode;
    private ActionCodeType actionCode;
    private String numberInParty;
    private Short elapsedTime;

    /** 
     * Get the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @return value
     */
    public AirportInformationType getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(AirportInformationType departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @return value
     */
    public AirportInformationType getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(AirportInformationType arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    /** 
     * Get the 'OperatingAirline' element value.  The operating airline of the flight if it is a codeshare  flight.
     * 
     * @return value
     */
    public OperatingAirlineType getOperatingAirline() {
        return operatingAirline;
    }

    /** 
     * Set the 'OperatingAirline' element value.  The operating airline of the flight if it is a codeshare  flight.
     * 
     * @param operatingAirline
     */
    public void setOperatingAirline(OperatingAirlineType operatingAirline) {
        this.operatingAirline = operatingAirline;
    }

    /** 
     * Get the list of 'Equipment' element items.  The type of equipment  used for the  flight..
     * 
     * @return list
     */
    public List<ResponseEquipmentType> getEquipmentList() {
        return equipmentList;
    }

    /** 
     * Set the list of 'Equipment' element items.  The type of equipment  used for the  flight..
     * 
     * @param list
     */
    public void setEquipmentList(List<ResponseEquipmentType> list) {
        equipmentList = list;
    }

    /** 
     * Get the 'MarketingAirline' element value. The marketing airline. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. 
     * 
     * @return value
     */
    public CompanyNameType getMarketingAirline() {
        return marketingAirline;
    }

    /** 
     * Set the 'MarketingAirline' element value. The marketing airline. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. 
     * 
     * @param marketingAirline
     */
    public void setMarketingAirline(CompanyNameType marketingAirline) {
        this.marketingAirline = marketingAirline;
    }

    /** 
     * Get the 'DisclosureAirline' element value. The disclosure airline. This is required by the DOT mandate.
     * 
     * @return value
     */
    public CompanyNameType getDisclosureAirline() {
        return disclosureAirline;
    }

    /** 
     * Set the 'DisclosureAirline' element value. The disclosure airline. This is required by the DOT mandate.
     * 
     * @param disclosureAirline
     */
    public void setDisclosureAirline(CompanyNameType disclosureAirline) {
        this.disclosureAirline = disclosureAirline;
    }

    /** 
     * Get the 'MarriageGrp' element value. Many airlines link connection flights together by terming them married segments.  When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of the marriage group must be the same for all segments.
     * 
     * @return value
     */
    public String getMarriageGrp() {
        return marriageGrp;
    }

    /** 
     * Set the 'MarriageGrp' element value. Many airlines link connection flights together by terming them married segments.  When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of the marriage group must be the same for all segments.
     * 
     * @param marriageGrp
     */
    public void setMarriageGrp(String marriageGrp) {
        this.marriageGrp = marriageGrp;
    }

    /** 
     * Get the 'StopAirports' element value.
     * 
     * @return value
     */
    public StopAirports getStopAirports() {
        return stopAirports;
    }

    /** 
     * Set the 'StopAirports' element value.
     * 
     * @param stopAirports
     */
    public void setStopAirports(StopAirports stopAirports) {
        this.stopAirports = stopAirports;
    }

    /** 
     * Get the 'DepartureTimeZone' element value.
     * 
     * @return value
     */
    public DepartureTimeZone getDepartureTimeZone() {
        return departureTimeZone;
    }

    /** 
     * Set the 'DepartureTimeZone' element value.
     * 
     * @param departureTimeZone
     */
    public void setDepartureTimeZone(DepartureTimeZone departureTimeZone) {
        this.departureTimeZone = departureTimeZone;
    }

    /** 
     * Get the 'ArrivalTimeZone' element value.
     * 
     * @return value
     */
    public ArrivalTimeZone getArrivalTimeZone() {
        return arrivalTimeZone;
    }

    /** 
     * Set the 'ArrivalTimeZone' element value.
     * 
     * @param arrivalTimeZone
     */
    public void setArrivalTimeZone(ArrivalTimeZone arrivalTimeZone) {
        this.arrivalTimeZone = arrivalTimeZone;
    }

    /** 
     * Get the 'OnTimePerformance' element value.
     * 
     * @return value
     */
    public OnTimePerformance getOnTimePerformance() {
        return onTimePerformance;
    }

    /** 
     * Set the 'OnTimePerformance' element value.
     * 
     * @param onTimePerformance
     */
    public void setOnTimePerformance(OnTimePerformance onTimePerformance) {
        this.onTimePerformance = onTimePerformance;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'DepartureDateTime' attribute value.
     * 
     * @return value
     */
    public String getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' attribute value.
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(String departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'ArrivalDateTime' attribute value.
     * 
     * @return value
     */
    public String getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' attribute value.
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(String arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'StopQuantity' attribute value.  The number of stops the flight makes
     * 
     * @return value
     */
    public BigInteger getStopQuantity() {
        return stopQuantity;
    }

    /** 
     * Set the 'StopQuantity' attribute value.  The number of stops the flight makes
     * 
     * @param stopQuantity
     */
    public void setStopQuantity(BigInteger stopQuantity) {
        this.stopQuantity = stopQuantity;
    }

    /** 
     * Get the 'RPH' attribute value.
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value.
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }

    /** 
     * Get the 'InfoSource' attribute value.
     * 
     * @return value
     */
    public String getInfoSource() {
        return infoSource;
    }

    /** 
     * Set the 'InfoSource' attribute value.
     * 
     * @param infoSource
     */
    public void setInfoSource(String infoSource) {
        this.infoSource = infoSource;
    }

    /** 
     * Get the 'FlightNumber' attribute value. The flight number of the flight. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. 
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' attribute value. The flight number of the flight. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. 
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'TourOperatorFlightID' attribute value. ID of a flight in the Tour Operator's inventory. This flight is not necessarily in the inventory of an airline. Rather, it is a code created by tour operators.  
     * 
     * @return value
     */
    public String getTourOperatorFlightID() {
        return tourOperatorFlightID;
    }

    /** 
     * Set the 'TourOperatorFlightID' attribute value. ID of a flight in the Tour Operator's inventory. This flight is not necessarily in the inventory of an airline. Rather, it is a code created by tour operators.  
     * 
     * @param tourOperatorFlightID
     */
    public void setTourOperatorFlightID(String tourOperatorFlightID) {
        this.tourOperatorFlightID = tourOperatorFlightID;
    }

    /** 
     * Get the 'ResBookDesigCode' attribute value. Specific Booking Class for this segment.  
     * 
     * @return value
     */
    public String getResBookDesigCode() {
        return resBookDesigCode;
    }

    /** 
     * Set the 'ResBookDesigCode' attribute value. Specific Booking Class for this segment.  
     * 
     * @param resBookDesigCode
     */
    public void setResBookDesigCode(String resBookDesigCode) {
        this.resBookDesigCode = resBookDesigCode;
    }

    /** 
     * Get the 'ActionCode' attribute value.
     * 
     * @return value
     */
    public ActionCodeType getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' attribute value.
     * 
     * @param actionCode
     */
    public void setActionCode(ActionCodeType actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' attribute value.
     * 
     * @return value
     */
    public String getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' attribute value.
     * 
     * @param numberInParty
     */
    public void setNumberInParty(String numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'ElapsedTime' attribute value. Elapsed segment trip time.
     * 
     * @return value
     */
    public Short getElapsedTime() {
        return elapsedTime;
    }

    /** 
     * Set the 'ElapsedTime' attribute value. Elapsed segment trip time.
     * 
     * @param elapsedTime
     */
    public void setElapsedTime(Short elapsedTime) {
        this.elapsedTime = elapsedTime;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopAirports" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="StopAirport" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class StopAirport -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class StopAirports implements Serializable
    {
        private List<StopAirport> stopAirportList = new ArrayList<StopAirport>();

        /** 
         * Get the list of 'StopAirport' element items.
         * 
         * @return list
         */
        public List<StopAirport> getStopAirportList() {
            return stopAirportList;
        }

        /** 
         * Set the list of 'StopAirport' element items.
         * 
         * @param list
         */
        public void setStopAirportList(List<StopAirport> list) {
            stopAirportList = list;
        }
        /** 
         * Stop point of flight segment.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopAirport" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="ns:ResponseLocationType">
         *         &lt;xs:attribute type="xs:string" name="ArrivalDateTime"/>
         *         &lt;xs:attribute type="xs:string" name="DepartureDateTime"/>
         *         &lt;xs:attribute type="xs:int" name="ElapsedTime"/>
         *         &lt;xs:attribute type="xs:int" name="Duration"/>
         *         &lt;xs:attribute type="xs:float" name="GMTOffset"/>
         *         &lt;xs:attribute type="xs:anySimpleType" name="Equipment"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class StopAirport implements Serializable
        {
            private ResponseLocationType responseLocationType;
            private String arrivalDateTime;
            private String departureDateTime;
            private Integer elapsedTime;
            private Integer duration;
            private Float GMTOffset;
            private String equipment;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public ResponseLocationType getResponseLocationType() {
                return responseLocationType;
            }

            /** 
             * Set the extension value.
             * 
             * @param responseLocationType
             */
            public void setResponseLocationType(
                    ResponseLocationType responseLocationType) {
                this.responseLocationType = responseLocationType;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value. This date should be of the form YYYY-MM-DDTHH:MM:SS
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value. This date should be of the form YYYY-MM-DDTHH:MM:SS
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value. This date should be of the form YYYY-MM-DDTHH:MM:SS
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value. This date should be of the form YYYY-MM-DDTHH:MM:SS
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'ElapsedTime' attribute value. Elapsed Time in minutes
             * 
             * @return value
             */
            public Integer getElapsedTime() {
                return elapsedTime;
            }

            /** 
             * Set the 'ElapsedTime' attribute value. Elapsed Time in minutes
             * 
             * @param elapsedTime
             */
            public void setElapsedTime(Integer elapsedTime) {
                this.elapsedTime = elapsedTime;
            }

            /** 
             * Get the 'Duration' attribute value. Layover time in minutes
             * 
             * @return value
             */
            public Integer getDuration() {
                return duration;
            }

            /** 
             * Set the 'Duration' attribute value. Layover time in minutes
             * 
             * @param duration
             */
            public void setDuration(Integer duration) {
                this.duration = duration;
            }

            /** 
             * Get the 'GMTOffset' attribute value.
             * 
             * @return value
             */
            public Float getGMTOffset() {
                return GMTOffset;
            }

            /** 
             * Set the 'GMTOffset' attribute value.
             * 
             * @param GMTOffset
             */
            public void setGMTOffset(Float GMTOffset) {
                this.GMTOffset = GMTOffset;
            }

            /** 
             * Get the 'Equipment' attribute value. Equipment type
             * 
             * @return value
             */
            public String getEquipment() {
                return equipment;
            }

            /** 
             * Set the 'Equipment' attribute value. Equipment type
             * 
             * @param equipment
             */
            public void setEquipment(String equipment) {
                this.equipment = equipment;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureTimeZone" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:float" name="GMTOffset"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DepartureTimeZone implements Serializable
    {
        private Float GMTOffset;

        /** 
         * Get the 'GMTOffset' attribute value.
         * 
         * @return value
         */
        public Float getGMTOffset() {
            return GMTOffset;
        }

        /** 
         * Set the 'GMTOffset' attribute value.
         * 
         * @param GMTOffset
         */
        public void setGMTOffset(Float GMTOffset) {
            this.GMTOffset = GMTOffset;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalTimeZone" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:float" name="GMTOffset"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ArrivalTimeZone implements Serializable
    {
        private Float GMTOffset;

        /** 
         * Get the 'GMTOffset' attribute value.
         * 
         * @return value
         */
        public Float getGMTOffset() {
            return GMTOffset;
        }

        /** 
         * Set the 'GMTOffset' attribute value.
         * 
         * @param GMTOffset
         */
        public void setGMTOffset(Float GMTOffset) {
            this.GMTOffset = GMTOffset;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnTimePerformance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Level"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Percentage"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OnTimePerformance implements Serializable
    {
        private String level;
        private String percentage;

        /** 
         * Get the 'Level' attribute value.
         * 
         * @return value
         */
        public String getLevel() {
            return level;
        }

        /** 
         * Set the 'Level' attribute value.
         * 
         * @param level
         */
        public void setLevel(String level) {
            this.level = level;
        }

        /** 
         * Get the 'Percentage' attribute value.
         * 
         * @return value
         */
        public String getPercentage() {
            return percentage;
        }

        /** 
         * Set the 'Percentage' attribute value.
         * 
         * @param percentage
         */
        public void setPercentage(String percentage) {
            this.percentage = percentage;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="eTicket" minOccurs="0">
     *         &lt;!-- Reference to inner class ETicket -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="DataElement" minOccurs="0">
     *         &lt;!-- Reference to inner class DataElement -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Mileage" minOccurs="0">
     *         &lt;!-- Reference to inner class Mileage -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Message" minOccurs="0">
     *         &lt;!-- Reference to inner class Message -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RequestedStopover" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class RequestedStopover -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private ETicket ETicket;
        private DataElement dataElement;
        private Mileage mileage;
        private Message message;
        private RequestedStopover requestedStopover;

        /** 
         * Get the 'eTicket' element value.
         * 
         * @return value
         */
        public ETicket getETicket() {
            return ETicket;
        }

        /** 
         * Set the 'eTicket' element value.
         * 
         * @param eTicket
         */
        public void setETicket(ETicket eTicket) {
            ETicket = eTicket;
        }

        /** 
         * Get the 'DataElement' element value.
         * 
         * @return value
         */
        public DataElement getDataElement() {
            return dataElement;
        }

        /** 
         * Set the 'DataElement' element value.
         * 
         * @param dataElement
         */
        public void setDataElement(DataElement dataElement) {
            this.dataElement = dataElement;
        }

        /** 
         * Get the 'Mileage' element value.
         * 
         * @return value
         */
        public Mileage getMileage() {
            return mileage;
        }

        /** 
         * Set the 'Mileage' element value.
         * 
         * @param mileage
         */
        public void setMileage(Mileage mileage) {
            this.mileage = mileage;
        }

        /** 
         * Get the 'Message' element value.
         * 
         * @return value
         */
        public Message getMessage() {
            return message;
        }

        /** 
         * Set the 'Message' element value.
         * 
         * @param message
         */
        public void setMessage(Message message) {
            this.message = message;
        }

        /** 
         * Get the 'RequestedStopover' element value.
         * 
         * @return value
         */
        public RequestedStopover getRequestedStopover() {
            return requestedStopover;
        }

        /** 
         * Set the 'RequestedStopover' element value.
         * 
         * @param requestedStopover
         */
        public void setRequestedStopover(RequestedStopover requestedStopover) {
            this.requestedStopover = requestedStopover;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ETicket implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataElement" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="SubjectToGovernmentApproval"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DataElement implements Serializable
        {
            private Boolean subjectToGovernmentApproval;

            /** 
             * Get the 'SubjectToGovernmentApproval' attribute value.
             * 
             * @return value
             */
            public Boolean getSubjectToGovernmentApproval() {
                return subjectToGovernmentApproval;
            }

            /** 
             * Set the 'SubjectToGovernmentApproval' attribute value.
             * 
             * @param subjectToGovernmentApproval
             */
            public void setSubjectToGovernmentApproval(
                    Boolean subjectToGovernmentApproval) {
                this.subjectToGovernmentApproval = subjectToGovernmentApproval;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Mileage implements Serializable
        {
            private BigInteger amount;

            /** 
             * Get the 'Amount' attribute value.
             * 
             * @return value
             */
            public BigInteger getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value.
             * 
             * @param amount
             */
            public void setAmount(BigInteger amount) {
                this.amount = amount;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Message" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Text"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Message implements Serializable
        {
            private String type;
            private String text;

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'Text' attribute value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' attribute value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestedStopover" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RequestedStopover implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
    }
}
