
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Reference to ATPCO Table 166 brand feature item
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandFeatureRefType">
 *   &lt;xs:attribute type="xs:int" use="required" name="FeatureId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BrandFeatureRefType implements Serializable
{
    private int featureId;
    private String serviceId;

    /** 
     * Get the 'FeatureId' attribute value. Index to the final brand feature items list
     * 
     * @return value
     */
    public int getFeatureId() {
        return featureId;
    }

    /** 
     * Set the 'FeatureId' attribute value. Index to the final brand feature items list
     * 
     * @param featureId
     */
    public void setFeatureId(int featureId) {
        this.featureId = featureId;
    }

    /** 
     * Get the 'ServiceId' attribute value. NDC Service Id
     * 
     * @return value
     */
    public String getServiceId() {
        return serviceId;
    }

    /** 
     * Set the 'ServiceId' attribute value. NDC Service Id
     * 
     * @param serviceId
     */
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }
}
