
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Describes brand filters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandFiltersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="NonBrandedFares" minOccurs="0" maxOccurs="1">
 *       &lt;xs:complexType>
 *         &lt;xs:attributeGroup ref="ns:IncludeExcludePreferLevelGroup"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:BrandCodePrefType" name="Brand" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncludeExcludePreferLevelGroup">
 *   &lt;xs:attribute type="ns:IncludeExcludePreferLevelType" use="required" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BrandFiltersType implements Serializable
{
    private IncludeExcludePreferLevelType nonBrandedFares;
    private List<BrandCodePrefType> brandList = new ArrayList<BrandCodePrefType>();

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an assosiate item: unacceptable or preferred.
     * 
     * @return value
     */
    public IncludeExcludePreferLevelType getNonBrandedFares() {
        return nonBrandedFares;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an assosiate item: unacceptable or preferred.
     * 
     * @param nonBrandedFares
     */
    public void setNonBrandedFares(IncludeExcludePreferLevelType nonBrandedFares) {
        this.nonBrandedFares = nonBrandedFares;
    }

    /** 
     * Get the list of 'Brand' element items.
     * 
     * @return list
     */
    public List<BrandCodePrefType> getBrandList() {
        return brandList;
    }

    /** 
     * Set the list of 'Brand' element items.
     * 
     * @param list
     */
    public void setBrandList(List<BrandCodePrefType> list) {
        brandList = list;
    }
}
