
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Used to specify if carrier type is marketing or operating.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Marketing"/>
 *     &lt;xs:enumeration value="Operating"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CarrierType implements Serializable {
    MARKETING("Marketing"), OPERATING("Operating");
    private final String value;

    private CarrierType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CarrierType convert(String value) {
        for (CarrierType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
