
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Conversion" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Conversion -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyConversionsType implements Serializable
{
    private List<Conversion> conversionList = new ArrayList<Conversion>();

    /** 
     * Get the list of 'Conversion' element items.
     * 
     * @return list
     */
    public List<Conversion> getConversionList() {
        return conversionList;
    }

    /** 
     * Set the list of 'Conversion' element items.
     * 
     * @param list
     */
    public void setConversionList(List<Conversion> list) {
        conversionList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Conversion" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="From"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="To"/>
     *     &lt;xs:attribute type="xs:double" name="RateOfExchange"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Conversion implements Serializable
    {
        private String from;
        private String to;
        private Double rateOfExchange;

        /** 
         * Get the 'From' attribute value.
         * 
         * @return value
         */
        public String getFrom() {
            return from;
        }

        /** 
         * Set the 'From' attribute value.
         * 
         * @param from
         */
        public void setFrom(String from) {
            this.from = from;
        }

        /** 
         * Get the 'To' attribute value.
         * 
         * @return value
         */
        public String getTo() {
            return to;
        }

        /** 
         * Set the 'To' attribute value.
         * 
         * @param to
         */
        public void setTo(String to) {
            this.to = to;
        }

        /** 
         * Get the 'RateOfExchange' attribute value. Exchange rate
         * 
         * @return value
         */
        public Double getRateOfExchange() {
            return rateOfExchange;
        }

        /** 
         * Set the 'RateOfExchange' attribute value. Exchange rate
         * 
         * @param rateOfExchange
         */
        public void setRateOfExchange(Double rateOfExchange) {
            this.rateOfExchange = rateOfExchange;
        }
    }
}
