
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Program rewarding frequent use by accumulating credits for services provided by vendors.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyaltyType">
 *   &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
 *   &lt;xs:attribute type="xs:string" name="ProgramID"/>
 *   &lt;xs:attribute type="xs:string" name="MembershipID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelSector"/>
 *   &lt;xs:attributeGroup ref="ns:LoyalLevelGroup"/>
 *   &lt;xs:attributeGroup ref="ns:SingleVendorIndGroup"/>
 *   &lt;xs:attributeGroup ref="ns:SignupDateGroup"/>
 *   &lt;xs:attributeGroup ref="ns:EffectiveExpireOptionalDateGroup"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyalLevelGroup">
 *   &lt;xs:attribute type="xs:string" name="LoyalLevel"/>
 * &lt;/xs:attributeGroup>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SingleVendorIndGroup">
 *   &lt;xs:attribute name="SingleVendorInd">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class SingleVendorInd -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:attributeGroup>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignupDateGroup">
 *   &lt;xs:attribute type="xs:date" use="optional" name="SignupDate"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CustLoyaltyType implements Serializable
{
    private PrivacyGroup privacyGroup;
    private String programID;
    private String membershipID;
    private String travelSector;
    private String loyalLevel;
    private SingleVendorInd singleVendorInd;
    private Date signupDate;
    private EffectiveExpireOptionalDateGroup effectiveExpireOptionalDateGroup;
    private String RPH;

    /** 
     * Get the 'PrivacyGroup' attributeGroup value.
     * 
     * @return value
     */
    public PrivacyGroup getPrivacyGroup() {
        return privacyGroup;
    }

    /** 
     * Set the 'PrivacyGroup' attributeGroup value.
     * 
     * @param privacyGroup
     */
    public void setPrivacyGroup(PrivacyGroup privacyGroup) {
        this.privacyGroup = privacyGroup;
    }

    /** 
     * Get the 'ProgramID' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getProgramID() {
        return programID;
    }

    /** 
     * Set the 'ProgramID' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param programID
     */
    public void setProgramID(String programID) {
        this.programID = programID;
    }

    /** 
     * Get the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'TravelSector' attribute value. Identifies the travel sector. Refer to OTA Code List Travel Sector (TVS).
     * 
     * @return value
     */
    public String getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'TravelSector' attribute value. Identifies the travel sector. Refer to OTA Code List Travel Sector (TVS).
     * 
     * @param travelSector
     */
    public void setTravelSector(String travelSector) {
        this.travelSector = travelSector;
    }

    /** 
     * Get the 'LoyalLevel' attribute value. Indicates special privileges in program assigned to individual.
     * 
     * @return value
     */
    public String getLoyalLevel() {
        return loyalLevel;
    }

    /** 
     * Set the 'LoyalLevel' attribute value. Indicates special privileges in program assigned to individual.
     * 
     * @param loyalLevel
     */
    public void setLoyalLevel(String loyalLevel) {
        this.loyalLevel = loyalLevel;
    }

    /** 
     * Get the 'SingleVendorInd' attribute value. Indicates if program is affiliated with a group of related offers accumulating credits.
     * 
     * @return value
     */
    public SingleVendorInd getSingleVendorInd() {
        return singleVendorInd;
    }

    /** 
     * Set the 'SingleVendorInd' attribute value. Indicates if program is affiliated with a group of related offers accumulating credits.
     * 
     * @param singleVendorInd
     */
    public void setSingleVendorInd(SingleVendorInd singleVendorInd) {
        this.singleVendorInd = singleVendorInd;
    }

    /** 
     * Get the 'SignupDate' attribute value. Indicates when the member signed up for the loyalty program.
     * 
     * @return value
     */
    public Date getSignupDate() {
        return signupDate;
    }

    /** 
     * Set the 'SignupDate' attribute value. Indicates when the member signed up for the loyalty program.
     * 
     * @param signupDate
     */
    public void setSignupDate(Date signupDate) {
        this.signupDate = signupDate;
    }

    /** 
     * Get the 'EffectiveExpireOptionalDateGroup' attributeGroup value.
     * 
     * @return value
     */
    public EffectiveExpireOptionalDateGroup getEffectiveExpireOptionalDateGroup() {
        return effectiveExpireOptionalDateGroup;
    }

    /** 
     * Set the 'EffectiveExpireOptionalDateGroup' attributeGroup value.
     * 
     * @param effectiveExpireOptionalDateGroup
     */
    public void setEffectiveExpireOptionalDateGroup(
            EffectiveExpireOptionalDateGroup effectiveExpireOptionalDateGroup) {
        this.effectiveExpireOptionalDateGroup = effectiveExpireOptionalDateGroup;
    }

    /** 
     * Get the 'RPH' attribute value. Reference place holder, to reference it back in the response.
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. Reference place holder, to reference it back in the response.
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="SingleVndr"/>
     *     &lt;xs:enumeration value="Alliance"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum SingleVendorInd implements Serializable {
        SINGLE_VNDR("SingleVndr"), ALLIANCE("Alliance");
        private final String value;

        private SingleVendorInd(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static SingleVendorInd convert(String value) {
            for (SingleVendorInd inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
