
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Specify which days of week  to consider for departure.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureDaysType">
 *   &lt;xs:attribute type="xs:string" use="required" name="Value"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DepartureDaysType implements Serializable
{
    private String value;

    /** 
     * Get the 'Value' attribute value. Value format: First letter of the name of the day or '_', eg. 'SMT___S' means we are interested in departing at Saturday, Sunday, Monday or Tuesday. Even if there are schedules for Wednesday, Thursday or Friday, they won't be returned in ISell response.
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'Value' attribute value. Value format: First letter of the name of the day or '_', eg. 'SMT___S' means we are interested in departing at Saturday, Sunday, Monday or Tuesday. Even if there are schedules for Wednesday, Thursday or Friday, they won't be returned in ISell response.
     * 
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }
}
