
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureOrArrival">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Departure"/>
 *     &lt;xs:enumeration value="Arrival"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DepartureOrArrival implements Serializable {
    DEPARTURE("Departure"), ARRIVAL("Arrival");
    private final String value;

    private DepartureOrArrival(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DepartureOrArrival convert(String value) {
        for (DepartureOrArrival inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
