
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeFareAttributeGroup">
 *   &lt;xs:attribute type="xs:decimal" use="required" name="BaseFareAmount"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="NonRefundableAmount"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="BaseFareCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="FareCalcCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrier"/>
 *   &lt;xs:attribute type="xs:double" use="optional" name="ROE"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ExchangeFareAttributeGroup implements Serializable
{
    private BigDecimal baseFareAmount;
    private BigDecimal nonRefundableAmount;
    private String baseFareCurrency;
    private String fareCalcCurrency;
    private String validatingCarrier;
    private Double ROE;

    /** 
     * Get the 'BaseFareAmount' attribute value. Base fare amount
     * 
     * @return value
     */
    public BigDecimal getBaseFareAmount() {
        return baseFareAmount;
    }

    /** 
     * Set the 'BaseFareAmount' attribute value. Base fare amount
     * 
     * @param baseFareAmount
     */
    public void setBaseFareAmount(BigDecimal baseFareAmount) {
        this.baseFareAmount = baseFareAmount;
    }

    /** 
     * Get the 'NonRefundableAmount' attribute value. Non-refundable Base Fare Amount. Currency is defined by @BaseFareCurrency.
     * 
     * @return value
     */
    public BigDecimal getNonRefundableAmount() {
        return nonRefundableAmount;
    }

    /** 
     * Set the 'NonRefundableAmount' attribute value. Non-refundable Base Fare Amount. Currency is defined by @BaseFareCurrency.
     * 
     * @param nonRefundableAmount
     */
    public void setNonRefundableAmount(BigDecimal nonRefundableAmount) {
        this.nonRefundableAmount = nonRefundableAmount;
    }

    /** 
     * Get the 'BaseFareCurrency' attribute value. Base fare currency
     * 
     * @return value
     */
    public String getBaseFareCurrency() {
        return baseFareCurrency;
    }

    /** 
     * Set the 'BaseFareCurrency' attribute value. Base fare currency
     * 
     * @param baseFareCurrency
     */
    public void setBaseFareCurrency(String baseFareCurrency) {
        this.baseFareCurrency = baseFareCurrency;
    }

    /** 
     * Get the 'FareCalcCurrency' attribute value. Fare calc currency
     * 
     * @return value
     */
    public String getFareCalcCurrency() {
        return fareCalcCurrency;
    }

    /** 
     * Set the 'FareCalcCurrency' attribute value. Fare calc currency
     * 
     * @param fareCalcCurrency
     */
    public void setFareCalcCurrency(String fareCalcCurrency) {
        this.fareCalcCurrency = fareCalcCurrency;
    }

    /** 
     * Get the 'ValidatingCarrier' attribute value. Validating carrier
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' attribute value. Validating carrier
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'ROE' attribute value. Rate of Exchange override (note: doesn't need to be specified if FareCalc currency and BaseFare currency is the same).
     * 
     * @return value
     */
    public Double getROE() {
        return ROE;
    }

    /** 
     * Set the 'ROE' attribute value. Rate of Exchange override (note: doesn't need to be specified if FareCalc currency and BaseFare currency is the same).
     * 
     * @param ROE
     */
    public void setROE(Double ROE) {
        this.ROE = ROE;
    }
}
