
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeOriginDestinationFlightFareGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Fare">
 *       &lt;xs:complexType>
 *         &lt;xs:complexContent>
 *           &lt;xs:extension base="ns:FareDetailsType">
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Adjustment" minOccurs="0">
 *                 &lt;!-- Reference to inner class Adjustment -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:extension>
 *         &lt;/xs:complexContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PlusUpType" name="PlusUp" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SurchargeType" name="Surcharge" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class ExchangeOriginDestinationFlightFareGroup implements Serializable
{
    private FareDetailsType fareFareDetailsType;
    private Adjustment adjustment;
    private List<PlusUpType> plusUpList = new ArrayList<PlusUpType>();
    private List<SurchargeType> surchargeList = new ArrayList<SurchargeType>();

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public FareDetailsType getFareFareDetailsType() {
        return fareFareDetailsType;
    }

    /** 
     * Set the extension value.
     * 
     * @param fareFareDetailsType
     */
    public void setFareFareDetailsType(FareDetailsType fareFareDetailsType) {
        this.fareFareDetailsType = fareFareDetailsType;
    }

    /** 
     * Get the 'Adjustment' element value.
     * 
     * @return value
     */
    public Adjustment getAdjustment() {
        return adjustment;
    }

    /** 
     * Set the 'Adjustment' element value.
     * 
     * @param adjustment
     */
    public void setAdjustment(Adjustment adjustment) {
        this.adjustment = adjustment;
    }

    /** 
     * Get the list of 'PlusUp' element items.
     * 
     * @return list
     */
    public List<PlusUpType> getPlusUpList() {
        return plusUpList;
    }

    /** 
     * Set the list of 'PlusUp' element items.
     * 
     * @param list
     */
    public void setPlusUpList(List<PlusUpType> list) {
        plusUpList = list;
    }

    /** 
     * Get the list of 'Surcharge' element items.
     * 
     * @return list
     */
    public List<SurchargeType> getSurchargeList() {
        return surchargeList;
    }

    /** 
     * Set the list of 'Surcharge' element items.
     * 
     * @param list
     */
    public void setSurchargeList(List<SurchargeType> list) {
        surchargeList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Adjustment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
     *     &lt;xs:attribute type="xs:string" name="Currency"/>
     *     &lt;xs:attribute type="xs:short" name="Group"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Adjustment implements Serializable
    {
        private String value;
        private String currency;
        private Short group;

        /** 
         * Get the 'Value' attribute value. Adjustment Value, can be positive or negative, number or percentage
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value. Adjustment Value, can be positive or negative, number or percentage
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }

        /** 
         * Get the 'Currency' attribute value. Currency of Adjustment's Value
         * 
         * @return value
         */
        public String getCurrency() {
            return currency;
        }

        /** 
         * Set the 'Currency' attribute value. Currency of Adjustment's Value
         * 
         * @param currency
         */
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        /** 
         * Get the 'Group' attribute value. Markup/Discount Group
         * 
         * @return value
         */
        public Short getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' attribute value. Markup/Discount Group
         * 
         * @param group
         */
        public void setGroup(Short group) {
            this.group = group;
        }
    }
}
