
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeOriginDestinationOrArunkGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ExchangeOriginDestinationInformationType" name="OriginDestinationInformation"/>
 *     &lt;xs:sequence minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class ExchangeOriginDestinationOrArunkGroup implements Serializable
{
    private ExchangeOriginDestinationInformationType originDestinationInformation;
    private List<Sequence> sequenceList = new ArrayList<Sequence>();

    /** 
     * Get the 'OriginDestinationInformation' element value.
     * 
     * @return value
     */
    public ExchangeOriginDestinationInformationType getOriginDestinationInformation() {
        return originDestinationInformation;
    }

    /** 
     * Set the 'OriginDestinationInformation' element value.
     * 
     * @param originDestinationInformation
     */
    public void setOriginDestinationInformation(
            ExchangeOriginDestinationInformationType originDestinationInformation) {
        this.originDestinationInformation = originDestinationInformation;
    }

    /** 
     * Get the list of sequence items.
     * 
     * @return list
     */
    public List<Sequence> getSequenceList() {
        return sequenceList;
    }

    /** 
     * Set the list of sequence items.
     * 
     * @param list
     */
    public void setSequenceList(List<Sequence> list) {
        sequenceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:element type="ns:ArunkType" name="Arunk" minOccurs="0"/>
     *   &lt;xs:element type="ns:ExchangeOriginDestinationInformationType" name="OriginDestinationInformation"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private ArunkType arunk;
        private ExchangeOriginDestinationInformationType originDestinationInformation;

        /** 
         * Get the 'Arunk' element value.
         * 
         * @return value
         */
        public ArunkType getArunk() {
            return arunk;
        }

        /** 
         * Set the 'Arunk' element value.
         * 
         * @param arunk
         */
        public void setArunk(ArunkType arunk) {
            this.arunk = arunk;
        }

        /** 
         * Get the 'OriginDestinationInformation' element value.
         * 
         * @return value
         */
        public ExchangeOriginDestinationInformationType getOriginDestinationInformation() {
            return originDestinationInformation;
        }

        /** 
         * Set the 'OriginDestinationInformation' element value.
         * 
         * @param originDestinationInformation
         */
        public void setOriginDestinationInformation(
                ExchangeOriginDestinationInformationType originDestinationInformation) {
            this.originDestinationInformation = originDestinationInformation;
        }
    }
}
