
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeSettingsType">
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="RepriceCurrentItin"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="AttachExchangeInfo"/>
 *   &lt;xs:attribute use="optional" name="ReissueExchange">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ReissueExchange -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="BrandedResults"/>
 *   &lt;xs:attribute type="xs:long" use="optional" name="MIPTimeoutThreshold"/>
 *   &lt;xs:attribute use="optional" name="RequestType">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class RequestType -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="KeepOriginalBrand"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="VoluntaryAfterInvoluntary"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExchangeSettingsType implements Serializable
{
    private Boolean repriceCurrentItin;
    private Boolean attachExchangeInfo;
    private ReissueExchange reissueExchange;
    private Boolean brandedResults;
    private Long MIPTimeoutThreshold;
    private RequestType requestType;
    private Boolean keepOriginalBrand;
    private Boolean voluntaryAfterInvoluntary;

    /** 
     * Get the 'RepriceCurrentItin' attribute value. If set to ''false'', disables processing of Current Itin path.
     * 
     * @return value
     */
    public Boolean getRepriceCurrentItin() {
        return repriceCurrentItin;
    }

    /** 
     * Set the 'RepriceCurrentItin' attribute value. If set to ''false'', disables processing of Current Itin path.
     * 
     * @param repriceCurrentItin
     */
    public void setRepriceCurrentItin(Boolean repriceCurrentItin) {
        this.repriceCurrentItin = repriceCurrentItin;
    }

    /** 
     * Get the 'AttachExchangeInfo' attribute value. 
            If set to ''true'', adds exchange-specific information to the response.
            The information includes richer Tax elements, ReissueVsExchange attribute and currency conversion rates.
          
     * 
     * @return value
     */
    public Boolean getAttachExchangeInfo() {
        return attachExchangeInfo;
    }

    /** 
     * Set the 'AttachExchangeInfo' attribute value. 
            If set to ''true'', adds exchange-specific information to the response.
            The information includes richer Tax elements, ReissueVsExchange attribute and currency conversion rates.
          
     * 
     * @param attachExchangeInfo
     */
    public void setAttachExchangeInfo(Boolean attachExchangeInfo) {
        this.attachExchangeInfo = attachExchangeInfo;
    }

    /** 
     * Get the 'ReissueExchange' attribute value. Process Type Indicator for Primary Request Type
     * 
     * @return value
     */
    public ReissueExchange getReissueExchange() {
        return reissueExchange;
    }

    /** 
     * Set the 'ReissueExchange' attribute value. Process Type Indicator for Primary Request Type
     * 
     * @param reissueExchange
     */
    public void setReissueExchange(ReissueExchange reissueExchange) {
        this.reissueExchange = reissueExchange;
    }

    /** 
     * Get the 'BrandedResults' attribute value. Enables branded results (if brands are available for returned options)
     * 
     * @return value
     */
    public Boolean getBrandedResults() {
        return brandedResults;
    }

    /** 
     * Set the 'BrandedResults' attribute value. Enables branded results (if brands are available for returned options)
     * 
     * @param brandedResults
     */
    public void setBrandedResults(Boolean brandedResults) {
        this.brandedResults = brandedResults;
    }

    /** 
     * Get the 'MIPTimeoutThreshold' attribute value. Hints MIP that it should return options within this amount of time (in seconds)
     * 
     * @return value
     */
    public Long getMIPTimeoutThreshold() {
        return MIPTimeoutThreshold;
    }

    /** 
     * Set the 'MIPTimeoutThreshold' attribute value. Hints MIP that it should return options within this amount of time (in seconds)
     * 
     * @param MIPTimeoutThreshold
     */
    public void setMIPTimeoutThreshold(Long MIPTimeoutThreshold) {
        this.MIPTimeoutThreshold = MIPTimeoutThreshold;
    }

    /** 
     * Get the 'RequestType' attribute value. Used to specify if the request is an usual Exchange request (basic) or an Exchange Context Shopping request (context). When not specified, basic is assumed.
     * 
     * @return value
     */
    public RequestType getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' attribute value. Used to specify if the request is an usual Exchange request (basic) or an Exchange Context Shopping request (context). When not specified, basic is assumed.
     * 
     * @param requestType
     */
    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'KeepOriginalBrand' attribute value. If set to ''true'', the original brand will be returned for unchanged flights.
     * 
     * @return value
     */
    public Boolean getKeepOriginalBrand() {
        return keepOriginalBrand;
    }

    /** 
     * Set the 'KeepOriginalBrand' attribute value. If set to ''true'', the original brand will be returned for unchanged flights.
     * 
     * @param keepOriginalBrand
     */
    public void setKeepOriginalBrand(Boolean keepOriginalBrand) {
        this.keepOriginalBrand = keepOriginalBrand;
    }

    /** 
     * Get the 'VoluntaryAfterInvoluntary' attribute value. 
            Determines that exchange transaction is performed on the reservation which has been previously involuntarily exchanged. Default value is false.
          
     * 
     * @return value
     */
    public Boolean getVoluntaryAfterInvoluntary() {
        return voluntaryAfterInvoluntary;
    }

    /** 
     * Set the 'VoluntaryAfterInvoluntary' attribute value. 
            Determines that exchange transaction is performed on the reservation which has been previously involuntarily exchanged. Default value is false.
          
     * 
     * @param voluntaryAfterInvoluntary
     */
    public void setVoluntaryAfterInvoluntary(Boolean voluntaryAfterInvoluntary) {
        this.voluntaryAfterInvoluntary = voluntaryAfterInvoluntary;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="A"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ReissueExchange implements Serializable {
        A
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="basic"/>
     *     &lt;xs:enumeration value="context"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum RequestType implements Serializable {
        BASIC("basic"), CONTEXT("context");
        private final String value;

        private RequestType(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static RequestType convert(String value) {
            for (RequestType inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
