
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeSourceAttributeGroup">
 *   &lt;xs:attribute type="xs:string" use="required" name="AgentCity"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MainTravelAgencyPCC"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Carrier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HostCarrier"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ETicketCapable"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="CoHostID"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ExchangeSourceAttributeGroup implements Serializable
{
    private String agentCity;
    private String mainTravelAgencyPCC;
    private String carrier;
    private String hostCarrier;
    private Boolean ETicketCapable;
    private Short coHostID;

    /** 
     * Get the 'AgentCity' attribute value. Agent city
     * 
     * @return value
     */
    public String getAgentCity() {
        return agentCity;
    }

    /** 
     * Set the 'AgentCity' attribute value. Agent city
     * 
     * @param agentCity
     */
    public void setAgentCity(String agentCity) {
        this.agentCity = agentCity;
    }

    /** 
     * Get the 'MainTravelAgencyPCC' attribute value. Main travel agency PCC
     * 
     * @return value
     */
    public String getMainTravelAgencyPCC() {
        return mainTravelAgencyPCC;
    }

    /** 
     * Set the 'MainTravelAgencyPCC' attribute value. Main travel agency PCC
     * 
     * @param mainTravelAgencyPCC
     */
    public void setMainTravelAgencyPCC(String mainTravelAgencyPCC) {
        this.mainTravelAgencyPCC = mainTravelAgencyPCC;
    }

    /** 
     * Get the 'Carrier' attribute value. Carrier
     * 
     * @return value
     */
    public String getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' attribute value. Carrier
     * 
     * @param carrier
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'HostCarrier' attribute value. PCC Host Carrier
     * 
     * @return value
     */
    public String getHostCarrier() {
        return hostCarrier;
    }

    /** 
     * Set the 'HostCarrier' attribute value. PCC Host Carrier
     * 
     * @param hostCarrier
     */
    public void setHostCarrier(String hostCarrier) {
        this.hostCarrier = hostCarrier;
    }

    /** 
     * Get the 'ETicketCapable' attribute value. Agency is Eticket capable
     * 
     * @return value
     */
    public Boolean getETicketCapable() {
        return ETicketCapable;
    }

    /** 
     * Set the 'ETicketCapable' attribute value. Agency is Eticket capable
     * 
     * @param ETicketCapable
     */
    public void setETicketCapable(Boolean ETicketCapable) {
        this.ETicketCapable = ETicketCapable;
    }

    /** 
     * Get the 'CoHostID' attribute value. CoHostID
     * 
     * @return value
     */
    public Short getCoHostID() {
        return coHostID;
    }

    /** 
     * Set the 'CoHostID' attribute value. CoHostID
     * 
     * @param coHostID
     */
    public void setCoHostID(Short coHostID) {
        this.coHostID = coHostID;
    }
}
