
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentTaxesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FlightSegment" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FlightSegment -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AirTaxType" name="Tax" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:AirTaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareComponentTaxesType implements Serializable
{
    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
    private List<AirTaxType> taxList = new ArrayList<AirTaxType>();
    private List<AirTaxSummaryType> taxSummaryList = new ArrayList<AirTaxSummaryType>();

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setFlightSegmentList(List<FlightSegment> list) {
        flightSegmentList = list;
    }

    /** 
     * Get the list of 'Tax' element items. Any individual tax applied to the fare
     * 
     * @return list
     */
    public List<AirTaxType> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items. Any individual tax applied to the fare
     * 
     * @param list
     */
    public void setTaxList(List<AirTaxType> list) {
        taxList = list;
    }

    /** 
     * Get the list of 'TaxSummary' element items. Tax Summary Information
     * 
     * @return list
     */
    public List<AirTaxSummaryType> getTaxSummaryList() {
        return taxSummaryList;
    }

    /** 
     * Set the list of 'TaxSummary' element items. Tax Summary Information
     * 
     * @param list
     */
    public void setTaxSummaryList(List<AirTaxSummaryType> list) {
        taxSummaryList = list;
    }
    /** 
     * A container for necessary data to describe one or more flight segments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:anySimpleType" name="DepartureAirportCode"/>
     *     &lt;xs:attribute type="xs:anySimpleType" name="ArrivalAirportCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private String departureAirportCode;
        private String arrivalAirportCode;

        /** 
         * Get the 'DepartureAirportCode' attribute value. Departure point of flight segment.
         * 
         * @return value
         */
        public String getDepartureAirportCode() {
            return departureAirportCode;
        }

        /** 
         * Set the 'DepartureAirportCode' attribute value. Departure point of flight segment.
         * 
         * @param departureAirportCode
         */
        public void setDepartureAirportCode(String departureAirportCode) {
            this.departureAirportCode = departureAirportCode;
        }

        /** 
         * Get the 'ArrivalAirportCode' attribute value. Arrival point of flight segment.
         * 
         * @return value
         */
        public String getArrivalAirportCode() {
            return arrivalAirportCode;
        }

        /** 
         * Set the 'ArrivalAirportCode' attribute value. Arrival point of flight segment.
         * 
         * @param arrivalAirportCode
         */
        public void setArrivalAirportCode(String arrivalAirportCode) {
            this.arrivalAirportCode = arrivalAirportCode;
        }
    }
}
