
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * 
 You don't need to specify all of these attributes for a given flight.
 For some of them it is sufficient to be specified in the last flight of a given fare component.
 For details, see notes below --- the attributes are annotated with ,,last Flight in Fare Component''.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOptionalDetailsType">
 *   &lt;xs:attribute type="xs:short" use="optional" name="ComponentNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BasisCode"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 *   &lt;xs:attributeGroup ref="ns:VCTRAttributeGroup"/>
 *   &lt;xs:attributeGroup ref="ns:BrandAttributeGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareOptionalDetailsType implements Serializable
{
    private Short componentNo;
    private String basisCode;
    private BigDecimal amount;
    private VCTRAttributeGroup VCTRAttributeGroup;
    private BrandAttributeGroup brandAttributeGroup;

    /** 
     * Get the 'ComponentNo' attribute value. Fare component number
     * 
     * @return value
     */
    public Short getComponentNo() {
        return componentNo;
    }

    /** 
     * Set the 'ComponentNo' attribute value. Fare component number
     * 
     * @param componentNo
     */
    public void setComponentNo(Short componentNo) {
        this.componentNo = componentNo;
    }

    /** 
     * Get the 'BasisCode' attribute value. Fare basis code
     * 
     * @return value
     */
    public String getBasisCode() {
        return basisCode;
    }

    /** 
     * Set the 'BasisCode' attribute value. Fare basis code
     * 
     * @param basisCode
     */
    public void setBasisCode(String basisCode) {
        this.basisCode = basisCode;
    }

    /** 
     * Get the 'Amount' attribute value. Fare amount (note: last Flight in Fare Component)
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value. Fare amount (note: last Flight in Fare Component)
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'VCTRAttributeGroup' attributeGroup value.
     * 
     * @return value
     */
    public VCTRAttributeGroup getVCTRAttributeGroup() {
        return VCTRAttributeGroup;
    }

    /** 
     * Set the 'VCTRAttributeGroup' attributeGroup value.
     * 
     * @param VCTRAttributeGroup
     */
    public void setVCTRAttributeGroup(VCTRAttributeGroup VCTRAttributeGroup) {
        this.VCTRAttributeGroup = VCTRAttributeGroup;
    }

    /** 
     * Get the 'BrandAttributeGroup' attributeGroup value.
     * 
     * @return value
     */
    public BrandAttributeGroup getBrandAttributeGroup() {
        return brandAttributeGroup;
    }

    /** 
     * Set the 'BrandAttributeGroup' attributeGroup value.
     * 
     * @param brandAttributeGroup
     */
    public void setBrandAttributeGroup(BrandAttributeGroup brandAttributeGroup) {
        this.brandAttributeGroup = brandAttributeGroup;
    }
}
