
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Identifies preferences for airfare restrictions acceptable or not acceptable for a given travel situation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRestrictPrefType">
 *   &lt;xs:attributeGroup ref="ns:PreferLevelGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FareRestriction"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferLevelGroup">
 *   &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FareRestrictPrefType implements Serializable
{
    private PreferLevelType preferLevel;
    private String fareRestriction;

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @return value
     */
    public PreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'FareRestriction' attribute value. Refer to OTA Code List Fare Restriction (FAR).
     * 
     * @return value
     */
    public String getFareRestriction() {
        return fareRestriction;
    }

    /** 
     * Set the 'FareRestriction' attribute value. Refer to OTA Code List Fare Restriction (FAR).
     * 
     * @param fareRestriction
     */
    public void setFareRestriction(String fareRestriction) {
        this.fareRestriction = fareRestriction;
    }
}
