
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Identifies a particular type of flight - Direct, Stopover etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightTypeType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Nonstop"/>
 *     &lt;xs:enumeration value="Direct"/>
 *     &lt;xs:enumeration value="Connection"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FlightTypeType implements Serializable {
    /** 
     * Flight without plane change and without intermediate landing.
     */
    NONSTOP("Nonstop"), /** 
                         * Flight without plane change and possible intermediate landing.
                         */
    DIRECT("Direct"), /** 
                       * Flight with plane changes, allowing maximum of 24 hours for each change
                       */
    CONNECTION("Connection");
    private final String value;

    private FlightTypeType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FlightTypeType convert(String value) {
        for (FlightTypeType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
