
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingMarkupSummaryType">
 *   &lt;xs:attribute type="xs:string" use="required" name="TypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Description"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ExtendedDescription"/>
 *   &lt;xs:attribute type="xs:decimal" use="required" name="MonetaryAmountValue"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="HiddenHandlingFee"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="NonHiddenHandlingFee"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FareRetailerRule"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HandlingMarkupSummaryType implements Serializable
{
    private String typeCode;
    private String description;
    private String extendedDescription;
    private BigDecimal monetaryAmountValue;
    private Boolean hiddenHandlingFee;
    private Boolean nonHiddenHandlingFee;
    private Boolean fareRetailerRule;

    /** 
     * Get the 'TypeCode' attribute value. Value M: Embedded Mark Up, J: Adjusted Selling, H: Handling Fee, G: GST Taxes
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' attribute value. Value M: Embedded Mark Up, J: Adjusted Selling, H: Handling Fee, G: GST Taxes
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'Description' attribute value. Max 10 chars
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value. Max 10 chars
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'ExtendedDescription' attribute value. Handling markup extended description, not limited to 10 chars
     * 
     * @return value
     */
    public String getExtendedDescription() {
        return extendedDescription;
    }

    /** 
     * Set the 'ExtendedDescription' attribute value. Handling markup extended description, not limited to 10 chars
     * 
     * @param extendedDescription
     */
    public void setExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
    }

    /** 
     * Get the 'MonetaryAmountValue' attribute value. Can be negative. This is in equivalent amount currency.
     * 
     * @return value
     */
    public BigDecimal getMonetaryAmountValue() {
        return monetaryAmountValue;
    }

    /** 
     * Set the 'MonetaryAmountValue' attribute value. Can be negative. This is in equivalent amount currency.
     * 
     * @param monetaryAmountValue
     */
    public void setMonetaryAmountValue(BigDecimal monetaryAmountValue) {
        this.monetaryAmountValue = monetaryAmountValue;
    }

    /** 
     * Get the 'HiddenHandlingFee' attribute value. Indicator if hidden handling fee was used
     * 
     * @return value
     */
    public Boolean getHiddenHandlingFee() {
        return hiddenHandlingFee;
    }

    /** 
     * Set the 'HiddenHandlingFee' attribute value. Indicator if hidden handling fee was used
     * 
     * @param hiddenHandlingFee
     */
    public void setHiddenHandlingFee(Boolean hiddenHandlingFee) {
        this.hiddenHandlingFee = hiddenHandlingFee;
    }

    /** 
     * Get the 'NonHiddenHandlingFee' attribute value. Indicator if non-hidden handling fee was used
     * 
     * @return value
     */
    public Boolean getNonHiddenHandlingFee() {
        return nonHiddenHandlingFee;
    }

    /** 
     * Set the 'NonHiddenHandlingFee' attribute value. Indicator if non-hidden handling fee was used
     * 
     * @param nonHiddenHandlingFee
     */
    public void setNonHiddenHandlingFee(Boolean nonHiddenHandlingFee) {
        this.nonHiddenHandlingFee = nonHiddenHandlingFee;
    }

    /** 
     * Get the 'FareRetailerRule' attribute value. Indicator if Fare Retailer selling level rule was used
     * 
     * @return value
     */
    public Boolean getFareRetailerRule() {
        return fareRetailerRule;
    }

    /** 
     * Set the 'FareRetailerRule' attribute value. Indicator if Fare Retailer selling level rule was used
     * 
     * @param fareRetailerRule
     */
    public void setFareRetailerRule(Boolean fareRetailerRule) {
        this.fareRetailerRule = fareRetailerRule;
    }
}
