
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinMaxTaxAttributeGroup">
 *   &lt;xs:attribute type="xs:double" name="MinAmount"/>
 *   &lt;xs:attribute type="xs:double" name="MaxAmount"/>
 *   &lt;xs:attribute type="xs:string" name="MinMaxCurrency"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MinMaxTaxAttributeGroup implements Serializable
{
    private Double minAmount;
    private Double maxAmount;
    private String minMaxCurrency;

    /** 
     * Get the 'MinAmount' attribute value. Minumum tax amount
     * 
     * @return value
     */
    public Double getMinAmount() {
        return minAmount;
    }

    /** 
     * Set the 'MinAmount' attribute value. Minumum tax amount
     * 
     * @param minAmount
     */
    public void setMinAmount(Double minAmount) {
        this.minAmount = minAmount;
    }

    /** 
     * Get the 'MaxAmount' attribute value. Maximum tax amount
     * 
     * @return value
     */
    public Double getMaxAmount() {
        return maxAmount;
    }

    /** 
     * Set the 'MaxAmount' attribute value. Maximum tax amount
     * 
     * @param maxAmount
     */
    public void setMaxAmount(Double maxAmount) {
        this.maxAmount = maxAmount;
    }

    /** 
     * Get the 'MinMaxCurrency' attribute value. Min/Max tax currency code
     * 
     * @return value
     */
    public String getMinMaxCurrency() {
        return minMaxCurrency;
    }

    /** 
     * Set the 'MinMaxCurrency' attribute value. Min/Max tax currency code
     * 
     * @param minMaxCurrency
     */
    public void setMinMaxCurrency(String minMaxCurrency) {
        this.minMaxCurrency = minMaxCurrency;
    }
}
