
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleDatesGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class MultipleDatesGroup implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();

    /** 
     * Get the list of 'MultipleDatesGroup' group items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of 'MultipleDatesGroup' group items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element name="Day">
     *     &lt;xs:complexType>
     *       &lt;xs:attribute type="xs:string" use="required" name="Date"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     *   &lt;xs:element name="DaysRange">
     *     &lt;xs:complexType>
     *       &lt;xs:attribute type="xs:string" use="required" name="FromDate"/>
     *       &lt;xs:attribute type="xs:string" use="required" name="ToDate"/>
     *       &lt;xs:attribute type="xs:string" name="WeekDays"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int DAY_CHOICE = 0;
        private static final int DAYS_RANGE_CHOICE = 1;
        private String day;
        private String daysRangeFromDate;
        private String daysRangeToDate;
        private String daysRangeWeekDays;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if Day is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDay() {
            return choiceListSelect == DAY_CHOICE;
        }

        /** 
         * Get the 'Date' attribute value.
         * 
         * @return value
         */
        public String getDay() {
            return day;
        }

        /** 
         * Set the 'Date' attribute value.
         * 
         * @param day
         */
        public void setDay(String day) {
            setChoiceListSelect(DAY_CHOICE);
            this.day = day;
        }

        /** 
         * Check if DaysRange is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDaysRange() {
            return choiceListSelect == DAYS_RANGE_CHOICE;
        }

        /** 
         * Get the 'FromDate' attribute value.
         * 
         * @return value
         */
        public String getDaysRangeFromDate() {
            return daysRangeFromDate;
        }

        /** 
         * Set the 'FromDate' attribute value.
         * 
         * @param daysRangeFromDate
         */
        public void setDaysRangeFromDate(String daysRangeFromDate) {
            setChoiceListSelect(DAYS_RANGE_CHOICE);
            this.daysRangeFromDate = daysRangeFromDate;
        }

        /** 
         * Get the 'ToDate' attribute value.
         * 
         * @return value
         */
        public String getDaysRangeToDate() {
            return daysRangeToDate;
        }

        /** 
         * Set the 'ToDate' attribute value.
         * 
         * @param daysRangeToDate
         */
        public void setDaysRangeToDate(String daysRangeToDate) {
            setChoiceListSelect(DAYS_RANGE_CHOICE);
            this.daysRangeToDate = daysRangeToDate;
        }

        /** 
         * Get the 'WeekDays' attribute value.
         * 
         * @return value
         */
        public String getDaysRangeWeekDays() {
            return daysRangeWeekDays;
        }

        /** 
         * Set the 'WeekDays' attribute value.
         * 
         * @param daysRangeWeekDays
         */
        public void setDaysRangeWeekDays(String daysRangeWeekDays) {
            setChoiceListSelect(DAYS_RANGE_CHOICE);
            this.daysRangeWeekDays = daysRangeWeekDays;
        }
    }
}
