
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * This element allows a user to specify the number of itineraries returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NumTripsType">
 *   &lt;xs:attribute type="xs:short" use="optional" default="9" name="Number"/>
 *   &lt;xs:attribute type="xs:unsignedShort" use="optional" name="PerDateMin"/>
 *   &lt;xs:attribute type="xs:unsignedShort" use="optional" name="PerDateMax"/>
 *   &lt;xs:attribute type="xs:unsignedShort" use="optional" name="PerMarket"/>
 *   &lt;xs:attribute type="xs:unsignedShort" use="optional" name="PerMonth"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NumTripsType implements Serializable
{
    private Short number;
    private String perDateMin;
    private String perDateMax;
    private String perMarket;
    private String perMonth;

    /** 
     * Get the 'Number' attribute value.
     * 
     * @return value
     */
    public Short getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' attribute value.
     * 
     * @param number
     */
    public void setNumber(Short number) {
        this.number = number;
    }

    /** 
     * Get the 'PerDateMin' attribute value. Minimum number of options to be retrieved for each combination of outbound/inbound dates.
     * 
     * @return value
     */
    public String getPerDateMin() {
        return perDateMin;
    }

    /** 
     * Set the 'PerDateMin' attribute value. Minimum number of options to be retrieved for each combination of outbound/inbound dates.
     * 
     * @param perDateMin
     */
    public void setPerDateMin(String perDateMin) {
        this.perDateMin = perDateMin;
    }

    /** 
     * Get the 'PerDateMax' attribute value. Maximum number of options to be retrieved for each combination of outbound/inbound dates.
     * 
     * @return value
     */
    public String getPerDateMax() {
        return perDateMax;
    }

    /** 
     * Set the 'PerDateMax' attribute value. Maximum number of options to be retrieved for each combination of outbound/inbound dates.
     * 
     * @param perDateMax
     */
    public void setPerDateMax(String perDateMax) {
        this.perDateMax = perDateMax;
    }

    /** 
     * Get the 'PerMarket' attribute value. Number of itineraries per market for alternate cities request. It allows to control market diversity only.
     * 
     * @return value
     */
    public String getPerMarket() {
        return perMarket;
    }

    /** 
     * Set the 'PerMarket' attribute value. Number of itineraries per market for alternate cities request. It allows to control market diversity only.
     * 
     * @param perMarket
     */
    public void setPerMarket(String perMarket) {
        this.perMarket = perMarket;
    }

    /** 
     * Get the 'PerMonth' attribute value. In Advanced Calendar API: Maximum number of itineraries to be retrieved for each departure month and departure/arrival combination.
     * 
     * @return value
     */
    public String getPerMonth() {
        return perMonth;
    }

    /** 
     * Set the 'PerMonth' attribute value. In Advanced Calendar API: Maximum number of itineraries to be retrieved for each departure month and departure/arrival combination.
     * 
     * @param perMonth
     */
    public void setPerMonth(String perMonth) {
        this.perMonth = perMonth;
    }
}
