
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * 
 Defines the data fields available for the ob fees.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OBFeeType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
 *   &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OBFeeType implements Serializable
{
    private String type;
    private String description;
    private CurrencyAmountGroup currencyAmountGroup;

    /** 
     * Get the 'Type' attribute value. OB Fee sub type code
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. OB Fee sub type code
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Description' attribute value. OB Fee description
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value. OB Fee description
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'CurrencyAmountGroup' attributeGroup value. Provides a monetary amount and the currency code to reflect the currency in which this amount is expressed.Defines a fee in terms of its amount, currency and decimal places.
     * 
     * @return value
     */
    public CurrencyAmountGroup getCurrencyAmountGroup() {
        return currencyAmountGroup;
    }

    /** 
     * Set the 'CurrencyAmountGroup' attributeGroup value. Provides a monetary amount and the currency code to reflect the currency in which this amount is expressed.Defines a fee in terms of its amount, currency and decimal places.
     * 
     * @param currencyAmountGroup
     */
    public void setCurrencyAmountGroup(CurrencyAmountGroup currencyAmountGroup) {
        this.currencyAmountGroup = currencyAmountGroup;
    }
}
