
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * OC Fee details
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OCFeeType">
 *   &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="OriginAirport"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DestinationAirport"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Carrier"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PassengerCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Date"/>
 *   &lt;xs:attribute type="xs:anySimpleType" use="required" name="StartSegment"/>
 *   &lt;xs:attribute type="xs:anySimpleType" use="required" name="EndSegment"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AncillaryTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Subcode"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="BaggageID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Subgroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description1"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description2"/>
 *   &lt;xs:attribute type="xs:byte" use="optional" name="FirstOccurrence"/>
 *   &lt;xs:attribute type="xs:byte" use="optional" name="LastOccurrence"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OCFeeType implements Serializable
{
    private BigDecimal amount;
    private String description;
    private String originAirport;
    private String destinationAirport;
    private String carrier;
    private String passengerCode;
    private String date;
    private String startSegment;
    private String endSegment;
    private String ancillaryTypeCode;
    private String subcode;
    private Short baggageID;
    private String subgroup;
    private String description1;
    private String description2;
    private Byte firstOccurrence;
    private Byte lastOccurrence;

    /** 
     * Get the 'Amount' attribute value. Fee amount
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value. Fee amount
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Description' attribute value. Fee description
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value. Fee description
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'OriginAirport' attribute value. Origin airport
     * 
     * @return value
     */
    public String getOriginAirport() {
        return originAirport;
    }

    /** 
     * Set the 'OriginAirport' attribute value. Origin airport
     * 
     * @param originAirport
     */
    public void setOriginAirport(String originAirport) {
        this.originAirport = originAirport;
    }

    /** 
     * Get the 'DestinationAirport' attribute value. Destination airport
     * 
     * @return value
     */
    public String getDestinationAirport() {
        return destinationAirport;
    }

    /** 
     * Set the 'DestinationAirport' attribute value. Destination airport
     * 
     * @param destinationAirport
     */
    public void setDestinationAirport(String destinationAirport) {
        this.destinationAirport = destinationAirport;
    }

    /** 
     * Get the 'Carrier' attribute value. Operating carrier code
     * 
     * @return value
     */
    public String getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' attribute value. Operating carrier code
     * 
     * @param carrier
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'PassengerCode' attribute value. Ancillary fee code
     * 
     * @return value
     */
    public String getPassengerCode() {
        return passengerCode;
    }

    /** 
     * Set the 'PassengerCode' attribute value. Ancillary fee code
     * 
     * @param passengerCode
     */
    public void setPassengerCode(String passengerCode) {
        this.passengerCode = passengerCode;
    }

    /** 
     * Get the 'Date' attribute value. Date for this fee. 
     * 
     * @return value
     */
    public String getDate() {
        return date;
    }

    /** 
     * Set the 'Date' attribute value. Date for this fee. 
     * 
     * @param date
     */
    public void setDate(String date) {
        this.date = date;
    }

    /** 
     * Get the 'StartSegment' attribute value. Start travel segment
     * 
     * @return value
     */
    public String getStartSegment() {
        return startSegment;
    }

    /** 
     * Set the 'StartSegment' attribute value. Start travel segment
     * 
     * @param startSegment
     */
    public void setStartSegment(String startSegment) {
        this.startSegment = startSegment;
    }

    /** 
     * Get the 'EndSegment' attribute value. End travel segment
     * 
     * @return value
     */
    public String getEndSegment() {
        return endSegment;
    }

    /** 
     * Set the 'EndSegment' attribute value. End travel segment
     * 
     * @param endSegment
     */
    public void setEndSegment(String endSegment) {
        this.endSegment = endSegment;
    }

    /** 
     * Get the 'AncillaryTypeCode' attribute value. Ancillary Type Code
     * 
     * @return value
     */
    public String getAncillaryTypeCode() {
        return ancillaryTypeCode;
    }

    /** 
     * Set the 'AncillaryTypeCode' attribute value. Ancillary Type Code
     * 
     * @param ancillaryTypeCode
     */
    public void setAncillaryTypeCode(String ancillaryTypeCode) {
        this.ancillaryTypeCode = ancillaryTypeCode;
    }

    /** 
     * Get the 'Subcode' attribute value. ATPCO Optional Services Industry Subcode
     * 
     * @return value
     */
    public String getSubcode() {
        return subcode;
    }

    /** 
     * Set the 'Subcode' attribute value. ATPCO Optional Services Industry Subcode
     * 
     * @param subcode
     */
    public void setSubcode(String subcode) {
        this.subcode = subcode;
    }

    /** 
     * Get the 'BaggageID' attribute value. Baggage ID number
     * 
     * @return value
     */
    public Short getBaggageID() {
        return baggageID;
    }

    /** 
     * Set the 'BaggageID' attribute value. Baggage ID number
     * 
     * @param baggageID
     */
    public void setBaggageID(Short baggageID) {
        this.baggageID = baggageID;
    }

    /** 
     * Get the 'Subgroup' attribute value. Ancillary subgroup two letter code
     * 
     * @return value
     */
    public String getSubgroup() {
        return subgroup;
    }

    /** 
     * Set the 'Subgroup' attribute value. Ancillary subgroup two letter code
     * 
     * @param subgroup
     */
    public void setSubgroup(String subgroup) {
        this.subgroup = subgroup;
    }

    /** 
     * Get the 'Description1' attribute value. Baggage description line 1
     * 
     * @return value
     */
    public String getDescription1() {
        return description1;
    }

    /** 
     * Set the 'Description1' attribute value. Baggage description line 1
     * 
     * @param description1
     */
    public void setDescription1(String description1) {
        this.description1 = description1;
    }

    /** 
     * Get the 'Description2' attribute value. Baggage description line 2
     * 
     * @return value
     */
    public String getDescription2() {
        return description2;
    }

    /** 
     * Set the 'Description2' attribute value. Baggage description line 2
     * 
     * @param description2
     */
    public void setDescription2(String description2) {
        this.description2 = description2;
    }

    /** 
     * Get the 'FirstOccurrence' attribute value. First occurrence
     * 
     * @return value
     */
    public Byte getFirstOccurrence() {
        return firstOccurrence;
    }

    /** 
     * Set the 'FirstOccurrence' attribute value. First occurrence
     * 
     * @param firstOccurrence
     */
    public void setFirstOccurrence(Byte firstOccurrence) {
        this.firstOccurrence = firstOccurrence;
    }

    /** 
     * Get the 'LastOccurrence' attribute value. Last occurrence
     * 
     * @return value
     */
    public Byte getLastOccurrence() {
        return lastOccurrence;
    }

    /** 
     * Set the 'LastOccurrence' attribute value. Last occurrence
     * 
     * @param lastOccurrence
     */
    public void setLastOccurrence(Byte lastOccurrence) {
        this.lastOccurrence = lastOccurrence;
    }
}
