
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Low Fare Search Request message requests priced itinerary options for flights between specific city pairs on specific dates for specific numbers and types of passengers. Optional request information can include: - Time / Time Window - Connecting cities. - Client Preferences (airlines, cabin, flight types etc.) The Low Fare Search request contains similar information to a Low Fare Search entry on an airline CRS or GDS.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirLowFareSearchRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:sequence>
 *         &lt;xs:element name="OriginDestinationInformation" minOccurs="1" maxOccurs="10">
 *           &lt;!-- Reference to inner class OriginDestinationInformation -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:AirSearchPrefsType" name="TravelPreferences" minOccurs="0"/>
 *         &lt;xs:element type="ns:TravelerInfoSummaryType" name="TravelerInfoSummary"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *         &lt;!-- Reference to inner class TPAExtensions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *     &lt;xs:attributeGroup ref="ns:MaxResponsesGroup"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="DirectFlightsOnly"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="AvailableFlightsOnly"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="ResponseType"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="ResponseVersion"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SeparateMessages"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="TruncateMessages"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaxResponsesGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaxResponses"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OTAAirLowFareSearchRQ implements Serializable
{
    private POSType POS;
    private List<OriginDestinationInformation> originDestinationInformationList = new ArrayList<OriginDestinationInformation>();
    private AirSearchPrefsType travelPreferences;
    private TravelerInfoSummaryType travelerInfoSummary;
    private TPAExtensions TPAExtensions1;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;
    private String maxResponses;
    private Boolean directFlightsOnly;
    private Boolean availableFlightsOnly;
    private String responseType;
    private String responseVersion;
    private Boolean separateMessages;
    private Boolean truncateMessages;

    /** 
     * Get the 'POS' element value. Point of sale object.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of sale object.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the list of 'OriginDestinationInformation' element items.
     * 
     * @return list
     */
    public List<OriginDestinationInformation> getOriginDestinationInformationList() {
        return originDestinationInformationList;
    }

    /** 
     * Set the list of 'OriginDestinationInformation' element items.
     * 
     * @param list
     */
    public void setOriginDestinationInformationList(
            List<OriginDestinationInformation> list) {
        originDestinationInformationList = list;
    }

    /** 
     * Get the 'TravelPreferences' element value. Air Low Fare Search Request preference information.
     * 
     * @return value
     */
    public AirSearchPrefsType getTravelPreferences() {
        return travelPreferences;
    }

    /** 
     * Set the 'TravelPreferences' element value. Air Low Fare Search Request preference information.
     * 
     * @param travelPreferences
     */
    public void setTravelPreferences(AirSearchPrefsType travelPreferences) {
        this.travelPreferences = travelPreferences;
    }

    /** 
     * Get the 'TravelerInfoSummary' element value. Specifies the number of passengers and types for Air Low Fare Search.
     * 
     * @return value
     */
    public TravelerInfoSummaryType getTravelerInfoSummary() {
        return travelerInfoSummary;
    }

    /** 
     * Set the 'TravelerInfoSummary' element value. Specifies the number of passengers and types for Air Low Fare Search.
     * 
     * @param travelerInfoSummary
     */
    public void setTravelerInfoSummary(
            TravelerInfoSummaryType travelerInfoSummary) {
        this.travelerInfoSummary = travelerInfoSummary;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }

    /** 
     * Get the 'MaxResponses' attribute value. A positive integer value that indicates the maximum number of responses desired in the return.
     * 
     * @return value
     */
    public String getMaxResponses() {
        return maxResponses;
    }

    /** 
     * Set the 'MaxResponses' attribute value. A positive integer value that indicates the maximum number of responses desired in the return.
     * 
     * @param maxResponses
     */
    public void setMaxResponses(String maxResponses) {
        this.maxResponses = maxResponses;
    }

    /** 
     * Get the 'DirectFlightsOnly' attribute value. Request direct flights between given locations. This defaults to false.
     * 
     * @return value
     */
    public Boolean getDirectFlightsOnly() {
        return directFlightsOnly;
    }

    /** 
     * Set the 'DirectFlightsOnly' attribute value. Request direct flights between given locations. This defaults to false.
     * 
     * @param directFlightsOnly
     */
    public void setDirectFlightsOnly(Boolean directFlightsOnly) {
        this.directFlightsOnly = directFlightsOnly;
    }

    /** 
     * Get the 'AvailableFlightsOnly' attribute value. Include only flights with available booking codes (when True or when attribute not present).
     * 
     * @return value
     */
    public Boolean getAvailableFlightsOnly() {
        return availableFlightsOnly;
    }

    /** 
     * Set the 'AvailableFlightsOnly' attribute value. Include only flights with available booking codes (when True or when attribute not present).
     * 
     * @param availableFlightsOnly
     */
    public void setAvailableFlightsOnly(Boolean availableFlightsOnly) {
        this.availableFlightsOnly = availableFlightsOnly;
    }

    /** 
     * Get the 'ResponseType' attribute value.
     * 
     * @return value
     */
    public String getResponseType() {
        return responseType;
    }

    /** 
     * Set the 'ResponseType' attribute value.
     * 
     * @param responseType
     */
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    /** 
     * Get the 'ResponseVersion' attribute value.
     * 
     * @return value
     */
    public String getResponseVersion() {
        return responseVersion;
    }

    /** 
     * Set the 'ResponseVersion' attribute value.
     * 
     * @param responseVersion
     */
    public void setResponseVersion(String responseVersion) {
        this.responseVersion = responseVersion;
    }

    /** 
     * Get the 'SeparateMessages' attribute value. Whether all messages should be printed in separate MTP element or not. Works only with PSS response serializers.
     * 
     * @return value
     */
    public Boolean getSeparateMessages() {
        return separateMessages;
    }

    /** 
     * Set the 'SeparateMessages' attribute value. Whether all messages should be printed in separate MTP element or not. Works only with PSS response serializers.
     * 
     * @param separateMessages
     */
    public void setSeparateMessages(Boolean separateMessages) {
        this.separateMessages = separateMessages;
    }

    /** 
     * Get the 'TruncateMessages' attribute value. Whether each MTP content should be truncated to specified length or not. Works only with PSS response serializers.
     * 
     * @return value
     */
    public Boolean getTruncateMessages() {
        return truncateMessages;
    }

    /** 
     * Set the 'TruncateMessages' attribute value. Whether each MTP content should be truncated to specified length or not. Works only with PSS response serializers.
     * 
     * @param truncateMessages
     */
    public void setTruncateMessages(Boolean truncateMessages) {
        this.truncateMessages = truncateMessages;
    }
    /** 
     * Origin and Destination location, and time information for the Air Low Fare Search request.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="1" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OriginDestinationInformationType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="TPA_Extensions" minOccurs="0">
     *             &lt;!-- Reference to inner class TPAExtensions -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *         &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Fixed"/>
     *         &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FullDiversity"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation
            extends
                OriginDestinationInformationType implements Serializable
    {
        private TPAExtensions TPAExtensions1;
        private String RPH;
        private Boolean fixed;
        private Boolean fullDiversity;

        /** 
         * Get the 'TPA_Extensions' element value.
         * 
         * @return value
         */
        public TPAExtensions getTPAExtensions1() {
            return TPAExtensions1;
        }

        /** 
         * Set the 'TPA_Extensions' element value.
         * 
         * @param TPAExtensions1
         */
        public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
            this.TPAExtensions1 = TPAExtensions1;
        }

        /** 
         * Get the 'RPH' attribute value. A placeholder for OriginDestinationInformation to be referenced wihin the OTA_AirLowFareSearchRS message. PricedItineraryType carries the reference to this RPH.
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. A placeholder for OriginDestinationInformation to be referenced wihin the OTA_AirLowFareSearchRS message. PricedItineraryType carries the reference to this RPH.
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }

        /** 
         * Get the 'Fixed' attribute value. OriginDestination node with flight and fare information fixed. Used in context shopping
         * 
         * @return value
         */
        public Boolean getFixed() {
            return fixed;
        }

        /** 
         * Set the 'Fixed' attribute value. OriginDestination node with flight and fare information fixed. Used in context shopping
         * 
         * @param fixed
         */
        public void setFixed(Boolean fixed) {
            this.fixed = fixed;
        }

        /** 
         * Get the 'FullDiversity' attribute value. Request for full diversity of flights for the particular OriginDestination node. Used in Exchange Context Shopping
         * 
         * @return value
         */
        public Boolean getFullDiversity() {
            return fullDiversity;
        }

        /** 
         * Set the 'FullDiversity' attribute value. Request for full diversity of flights for the particular OriginDestination node. Used in Exchange Context Shopping
         * 
         * @param fullDiversity
         */
        public void setFullDiversity(Boolean fullDiversity) {
            this.fullDiversity = fullDiversity;
        }
        /** 
         * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:OriginDestinationFlightType" name="Flight" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:PassengerPriceAdjustmentType" name="PassengerPriceAdjustment" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:RoutingDefinitionType" name="Routing" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:group ref="ns:OriginDestinationInformationTPA_ExtensionsGroup"/>
         *       &lt;xs:element type="ns:IncludeVendorPrefType" name="IncludeVendorPref" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:AllianceType" name="IncludeAlliancePref" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:DepartureDaysType" name="DepartureDays" minOccurs="0"/>
         *       &lt;xs:element type="ns:BaggageType" name="Baggage" minOccurs="0"/>
         *       &lt;xs:element type="ns:FreeSeatSelectionType" name="SeatSelection" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:element type="ns:FreePriorityBoardingType" name="PriorityBoarding" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:element type="ns:ClassOfServiceElemType" name="ClassOfService" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:FareBasisType" name="FareBasis" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:FareTypePrefType" name="FareType" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:BrandFiltersType" name="BrandFilters" minOccurs="0"/>
         *       &lt;xs:element type="ns:StopoverType" name="Stopover" minOccurs="0" maxOccurs="1"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TPAExtensions implements Serializable
        {
            private List<OriginDestinationFlightType> flightList = new ArrayList<OriginDestinationFlightType>();
            private List<PassengerPriceAdjustmentType> passengerPriceAdjustmentList = new ArrayList<PassengerPriceAdjustmentType>();
            private List<RoutingDefinitionType> routingList = new ArrayList<RoutingDefinitionType>();
            private OriginDestinationInformationTPAExtensionsGroup originDestinationInformationTPAExtensionsGroup;
            private List<IncludeVendorPrefType> includeVendorPrefList = new ArrayList<IncludeVendorPrefType>();
            private List<AllianceType> includeAlliancePrefList = new ArrayList<AllianceType>();
            private DepartureDaysType departureDays;
            private BaggageType baggage;
            private FreeSeatSelectionType seatSelection;
            private FreePriorityBoardingType priorityBoarding;
            private List<ClassOfServiceElemType> classOfServiceList = new ArrayList<ClassOfServiceElemType>();
            private List<FareBasisType> fareBasiList = new ArrayList<FareBasisType>();
            private List<FareTypePrefType> fareTypeList = new ArrayList<FareTypePrefType>();
            private BrandFiltersType brandFilters;
            private StopoverType stopover;

            /** 
             * Get the list of 'Flight' element items.
             * 
             * @return list
             */
            public List<OriginDestinationFlightType> getFlightList() {
                return flightList;
            }

            /** 
             * Set the list of 'Flight' element items.
             * 
             * @param list
             */
            public void setFlightList(List<OriginDestinationFlightType> list) {
                flightList = list;
            }

            /** 
             * Get the list of 'PassengerPriceAdjustment' element items.
             * 
             * @return list
             */
            public List<PassengerPriceAdjustmentType> getPassengerPriceAdjustmentList() {
                return passengerPriceAdjustmentList;
            }

            /** 
             * Set the list of 'PassengerPriceAdjustment' element items.
             * 
             * @param list
             */
            public void setPassengerPriceAdjustmentList(
                    List<PassengerPriceAdjustmentType> list) {
                passengerPriceAdjustmentList = list;
            }

            /** 
             * Get the list of 'Routing' element items.
             * 
             * @return list
             */
            public List<RoutingDefinitionType> getRoutingList() {
                return routingList;
            }

            /** 
             * Set the list of 'Routing' element items.
             * 
             * @param list
             */
            public void setRoutingList(List<RoutingDefinitionType> list) {
                routingList = list;
            }

            /** 
             * Get the 'OriginDestinationInformationTPA_ExtensionsGroup' group value.
             * 
             * @return value
             */
            public OriginDestinationInformationTPAExtensionsGroup getOriginDestinationInformationTPAExtensionsGroup() {
                return originDestinationInformationTPAExtensionsGroup;
            }

            /** 
             * Set the 'OriginDestinationInformationTPA_ExtensionsGroup' group value.
             * 
             * @param originDestinationInformationTPAExtensionsGroup
             */
            public void setOriginDestinationInformationTPAExtensionsGroup(
                    OriginDestinationInformationTPAExtensionsGroup originDestinationInformationTPAExtensionsGroup) {
                this.originDestinationInformationTPAExtensionsGroup = originDestinationInformationTPAExtensionsGroup;
            }

            /** 
             * Get the list of 'IncludeVendorPref' element items.
             * 
             * @return list
             */
            public List<IncludeVendorPrefType> getIncludeVendorPrefList() {
                return includeVendorPrefList;
            }

            /** 
             * Set the list of 'IncludeVendorPref' element items.
             * 
             * @param list
             */
            public void setIncludeVendorPrefList(
                    List<IncludeVendorPrefType> list) {
                includeVendorPrefList = list;
            }

            /** 
             * Get the list of 'IncludeAlliancePref' element items. Consider only these alliances.
             * 
             * @return list
             */
            public List<AllianceType> getIncludeAlliancePrefList() {
                return includeAlliancePrefList;
            }

            /** 
             * Set the list of 'IncludeAlliancePref' element items. Consider only these alliances.
             * 
             * @param list
             */
            public void setIncludeAlliancePrefList(List<AllianceType> list) {
                includeAlliancePrefList = list;
            }

            /** 
             * Get the 'DepartureDays' element value.
             * 
             * @return value
             */
            public DepartureDaysType getDepartureDays() {
                return departureDays;
            }

            /** 
             * Set the 'DepartureDays' element value.
             * 
             * @param departureDays
             */
            public void setDepartureDays(DepartureDaysType departureDays) {
                this.departureDays = departureDays;
            }

            /** 
             * Get the 'Baggage' element value. This element allows user to get baggage information
             * 
             * @return value
             */
            public BaggageType getBaggage() {
                return baggage;
            }

            /** 
             * Set the 'Baggage' element value. This element allows user to get baggage information
             * 
             * @param baggage
             */
            public void setBaggage(BaggageType baggage) {
                this.baggage = baggage;
            }

            /** 
             * Get the 'SeatSelection' element value.
             * 
             * @return value
             */
            public FreeSeatSelectionType getSeatSelection() {
                return seatSelection;
            }

            /** 
             * Set the 'SeatSelection' element value.
             * 
             * @param seatSelection
             */
            public void setSeatSelection(FreeSeatSelectionType seatSelection) {
                this.seatSelection = seatSelection;
            }

            /** 
             * Get the 'PriorityBoarding' element value.
             * 
             * @return value
             */
            public FreePriorityBoardingType getPriorityBoarding() {
                return priorityBoarding;
            }

            /** 
             * Set the 'PriorityBoarding' element value.
             * 
             * @param priorityBoarding
             */
            public void setPriorityBoarding(
                    FreePriorityBoardingType priorityBoarding) {
                this.priorityBoarding = priorityBoarding;
            }

            /** 
             * Get the list of 'ClassOfService' element items. Requested booking code per single leg
             * 
             * @return list
             */
            public List<ClassOfServiceElemType> getClassOfServiceList() {
                return classOfServiceList;
            }

            /** 
             * Set the list of 'ClassOfService' element items. Requested booking code per single leg
             * 
             * @param list
             */
            public void setClassOfServiceList(List<ClassOfServiceElemType> list) {
                classOfServiceList = list;
            }

            /** 
             * Get the list of 'FareBasis' element items. Fare Basis Codes requested for main fare leg
             * 
             * @return list
             */
            public List<FareBasisType> getFareBasiList() {
                return fareBasiList;
            }

            /** 
             * Set the list of 'FareBasis' element items. Fare Basis Codes requested for main fare leg
             * 
             * @param list
             */
            public void setFareBasiList(List<FareBasisType> list) {
                fareBasiList = list;
            }

            /** 
             * Get the list of 'FareType' element items. Defines preferred or excluded fare type codes for main fare leg.
             * 
             * @return list
             */
            public List<FareTypePrefType> getFareTypeList() {
                return fareTypeList;
            }

            /** 
             * Set the list of 'FareType' element items. Defines preferred or excluded fare type codes for main fare leg.
             * 
             * @param list
             */
            public void setFareTypeList(List<FareTypePrefType> list) {
                fareTypeList = list;
            }

            /** 
             * Get the 'BrandFilters' element value. Defines preferred or excluded brand type codes for main fare leg.
             * 
             * @return value
             */
            public BrandFiltersType getBrandFilters() {
                return brandFilters;
            }

            /** 
             * Set the 'BrandFilters' element value. Defines preferred or excluded brand type codes for main fare leg.
             * 
             * @param brandFilters
             */
            public void setBrandFilters(BrandFiltersType brandFilters) {
                this.brandFilters = brandFilters;
            }

            /** 
             * Get the 'Stopover' element value. Requested stopover informations
             * 
             * @return value
             */
            public StopoverType getStopover() {
                return stopover;
            }

            /** 
             * Set the 'Stopover' element value. Requested stopover informations
             * 
             * @param stopover
             */
            public void setStopover(StopoverType stopover) {
                this.stopover = stopover;
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:TransactionType" name="IntelliSellTransaction" minOccurs="0"/>
     *       &lt;xs:element type="ns:DiversityControlType" name="DiversityControl" minOccurs="0"/>
     *       &lt;xs:element name="MessagingDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class MessagingDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:choice>
     *         &lt;xs:element name="AlternateAirportCities" minOccurs="0" maxOccurs="unbounded">
     *           &lt;!-- Reference to inner class AlternateAirportCities -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="AlternateAirportMileage" minOccurs="0">
     *           &lt;!-- Reference to inner class AlternateAirportMileage -->
     *         &lt;/xs:element>
     *       &lt;/xs:choice>
     *       &lt;xs:element type="ns:AwardShoppingType" name="AwardShopping" minOccurs="0"/>
     *       &lt;xs:element type="ns:BillingInformationType" name="Billing" minOccurs="0"/>
     *       &lt;xs:element type="ns:ExchangeSettingsType" name="ExchangeSettings" minOccurs="0"/>
     *       &lt;xs:element type="ns:ExchangeType" name="Exchange" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="PointsRedemption" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class PointsRedemption -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SplitTaxes" minOccurs="0">
     *         &lt;!-- Reference to inner class SplitTaxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AlternateDatesProcessing" minOccurs="0">
     *         &lt;!-- Reference to inner class AlternateDatesProcessing -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryCache" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryCache -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MultiTicket" minOccurs="0">
     *         &lt;!-- Reference to inner class MultiTicket -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Partitions" minOccurs="0">
     *         &lt;!-- Reference to inner class Partitions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ReservationData" minOccurs="0">
     *         &lt;!-- Reference to inner class ReservationData -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:AlternatePCCType" name="AlternatePCC" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="ResponseControl" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class ResponseControl -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BestOffers" minOccurs="0">
     *         &lt;!-- Reference to inner class BestOffers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RichContent" minOccurs="0">
     *         &lt;!-- Reference to inner class RichContent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PricingControl" minOccurs="0">
     *         &lt;!-- Reference to inner class PricingControl -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private TransactionType intelliSellTransaction;
        private DiversityControlType diversityControl;
        private MessagingDetails messagingDetails;
        private int choiceSelect = -1;
        private static final int ALTERNATE_AIRPORT_CITY_LIST_CHOICE = 0;
        private static final int ALTERNATE_AIRPORT_MILEAGE_CHOICE = 1;
        private List<AlternateAirportCities> alternateAirportCityList = new ArrayList<AlternateAirportCities>();
        private AlternateAirportMileage alternateAirportMileage;
        private AwardShoppingType awardShopping;
        private BillingInformationType billing;
        private ExchangeSettingsType exchangeSettings;
        private List<ExchangeType> exchangeList = new ArrayList<ExchangeType>();
        private PointsRedemption pointsRedemption;
        private SplitTaxes splitTaxes;
        private AlternateDatesProcessing alternateDatesProcessing;
        private ItineraryCache itineraryCache;
        private MultiTicket multiTicket;
        private Partitions partitions;
        private ReservationData reservationData;
        private List<AlternatePCCType> alternatePCCList = new ArrayList<AlternatePCCType>();
        private ResponseControl responseControl;
        private BestOffers bestOffers;
        private RichContent richContent;
        private PricingControl pricingControl;

        /** 
         * Get the 'IntelliSellTransaction' element value.
         * 
         * @return value
         */
        public TransactionType getIntelliSellTransaction() {
            return intelliSellTransaction;
        }

        /** 
         * Set the 'IntelliSellTransaction' element value.
         * 
         * @param intelliSellTransaction
         */
        public void setIntelliSellTransaction(
                TransactionType intelliSellTransaction) {
            this.intelliSellTransaction = intelliSellTransaction;
        }

        /** 
         * Get the 'DiversityControl' element value.
         * 
         * @return value
         */
        public DiversityControlType getDiversityControl() {
            return diversityControl;
        }

        /** 
         * Set the 'DiversityControl' element value.
         * 
         * @param diversityControl
         */
        public void setDiversityControl(DiversityControlType diversityControl) {
            this.diversityControl = diversityControl;
        }

        /** 
         * Get the 'MessagingDetails' element value.
         * 
         * @return value
         */
        public MessagingDetails getMessagingDetails() {
            return messagingDetails;
        }

        /** 
         * Set the 'MessagingDetails' element value.
         * 
         * @param messagingDetails
         */
        public void setMessagingDetails(MessagingDetails messagingDetails) {
            this.messagingDetails = messagingDetails;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AlternateAirportCityList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAlternateAirportCityList() {
            return choiceSelect == ALTERNATE_AIRPORT_CITY_LIST_CHOICE;
        }

        /** 
         * Get the list of 'AlternateAirportCities' element items.
         * 
         * @return list
         */
        public List<AlternateAirportCities> getAlternateAirportCityList() {
            return alternateAirportCityList;
        }

        /** 
         * Set the list of 'AlternateAirportCities' element items.
         * 
         * @param list
         */
        public void setAlternateAirportCityList(
                List<AlternateAirportCities> list) {
            setChoiceSelect(ALTERNATE_AIRPORT_CITY_LIST_CHOICE);
            alternateAirportCityList = list;
        }

        /** 
         * Check if AlternateAirportMileage is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAlternateAirportMileage() {
            return choiceSelect == ALTERNATE_AIRPORT_MILEAGE_CHOICE;
        }

        /** 
         * Get the 'AlternateAirportMileage' element value.
         * 
         * @return value
         */
        public AlternateAirportMileage getAlternateAirportMileage() {
            return alternateAirportMileage;
        }

        /** 
         * Set the 'AlternateAirportMileage' element value.
         * 
         * @param alternateAirportMileage
         */
        public void setAlternateAirportMileage(
                AlternateAirportMileage alternateAirportMileage) {
            setChoiceSelect(ALTERNATE_AIRPORT_MILEAGE_CHOICE);
            this.alternateAirportMileage = alternateAirportMileage;
        }

        /** 
         * Get the 'AwardShopping' element value.
         * 
         * @return value
         */
        public AwardShoppingType getAwardShopping() {
            return awardShopping;
        }

        /** 
         * Set the 'AwardShopping' element value.
         * 
         * @param awardShopping
         */
        public void setAwardShopping(AwardShoppingType awardShopping) {
            this.awardShopping = awardShopping;
        }

        /** 
         * Get the 'Billing' element value.
         * 
         * @return value
         */
        public BillingInformationType getBilling() {
            return billing;
        }

        /** 
         * Set the 'Billing' element value.
         * 
         * @param billing
         */
        public void setBilling(BillingInformationType billing) {
            this.billing = billing;
        }

        /** 
         * Get the 'ExchangeSettings' element value.
         * 
         * @return value
         */
        public ExchangeSettingsType getExchangeSettings() {
            return exchangeSettings;
        }

        /** 
         * Set the 'ExchangeSettings' element value.
         * 
         * @param exchangeSettings
         */
        public void setExchangeSettings(ExchangeSettingsType exchangeSettings) {
            this.exchangeSettings = exchangeSettings;
        }

        /** 
         * Get the list of 'Exchange' element items.
         * 
         * @return list
         */
        public List<ExchangeType> getExchangeList() {
            return exchangeList;
        }

        /** 
         * Set the list of 'Exchange' element items.
         * 
         * @param list
         */
        public void setExchangeList(List<ExchangeType> list) {
            exchangeList = list;
        }

        /** 
         * Get the 'PointsRedemption' element value.
         * 
         * @return value
         */
        public PointsRedemption getPointsRedemption() {
            return pointsRedemption;
        }

        /** 
         * Set the 'PointsRedemption' element value.
         * 
         * @param pointsRedemption
         */
        public void setPointsRedemption(PointsRedemption pointsRedemption) {
            this.pointsRedemption = pointsRedemption;
        }

        /** 
         * Get the 'SplitTaxes' element value.
         * 
         * @return value
         */
        public SplitTaxes getSplitTaxes() {
            return splitTaxes;
        }

        /** 
         * Set the 'SplitTaxes' element value.
         * 
         * @param splitTaxes
         */
        public void setSplitTaxes(SplitTaxes splitTaxes) {
            this.splitTaxes = splitTaxes;
        }

        /** 
         * Get the 'AlternateDatesProcessing' element value.
         * 
         * @return value
         */
        public AlternateDatesProcessing getAlternateDatesProcessing() {
            return alternateDatesProcessing;
        }

        /** 
         * Set the 'AlternateDatesProcessing' element value.
         * 
         * @param alternateDatesProcessing
         */
        public void setAlternateDatesProcessing(
                AlternateDatesProcessing alternateDatesProcessing) {
            this.alternateDatesProcessing = alternateDatesProcessing;
        }

        /** 
         * Get the 'ItineraryCache' element value.
         * 
         * @return value
         */
        public ItineraryCache getItineraryCache() {
            return itineraryCache;
        }

        /** 
         * Set the 'ItineraryCache' element value.
         * 
         * @param itineraryCache
         */
        public void setItineraryCache(ItineraryCache itineraryCache) {
            this.itineraryCache = itineraryCache;
        }

        /** 
         * Get the 'MultiTicket' element value.
         * 
         * @return value
         */
        public MultiTicket getMultiTicket() {
            return multiTicket;
        }

        /** 
         * Set the 'MultiTicket' element value.
         * 
         * @param multiTicket
         */
        public void setMultiTicket(MultiTicket multiTicket) {
            this.multiTicket = multiTicket;
        }

        /** 
         * Get the 'Partitions' element value.
         * 
         * @return value
         */
        public Partitions getPartitions() {
            return partitions;
        }

        /** 
         * Set the 'Partitions' element value.
         * 
         * @param partitions
         */
        public void setPartitions(Partitions partitions) {
            this.partitions = partitions;
        }

        /** 
         * Get the 'ReservationData' element value.
         * 
         * @return value
         */
        public ReservationData getReservationData() {
            return reservationData;
        }

        /** 
         * Set the 'ReservationData' element value.
         * 
         * @param reservationData
         */
        public void setReservationData(ReservationData reservationData) {
            this.reservationData = reservationData;
        }

        /** 
         * Get the list of 'AlternatePCC' element items.
         * 
         * @return list
         */
        public List<AlternatePCCType> getAlternatePCCList() {
            return alternatePCCList;
        }

        /** 
         * Set the list of 'AlternatePCC' element items.
         * 
         * @param list
         */
        public void setAlternatePCCList(List<AlternatePCCType> list) {
            alternatePCCList = list;
        }

        /** 
         * Get the 'ResponseControl' element value.
         * 
         * @return value
         */
        public ResponseControl getResponseControl() {
            return responseControl;
        }

        /** 
         * Set the 'ResponseControl' element value.
         * 
         * @param responseControl
         */
        public void setResponseControl(ResponseControl responseControl) {
            this.responseControl = responseControl;
        }

        /** 
         * Get the 'BestOffers' element value.
         * 
         * @return value
         */
        public BestOffers getBestOffers() {
            return bestOffers;
        }

        /** 
         * Set the 'BestOffers' element value.
         * 
         * @param bestOffers
         */
        public void setBestOffers(BestOffers bestOffers) {
            this.bestOffers = bestOffers;
        }

        /** 
         * Get the 'RichContent' element value.
         * 
         * @return value
         */
        public RichContent getRichContent() {
            return richContent;
        }

        /** 
         * Set the 'RichContent' element value.
         * 
         * @param richContent
         */
        public void setRichContent(RichContent richContent) {
            this.richContent = richContent;
        }

        /** 
         * Get the 'PricingControl' element value.
         * 
         * @return value
         */
        public PricingControl getPricingControl() {
            return pricingControl;
        }

        /** 
         * Set the 'PricingControl' element value.
         * 
         * @param pricingControl
         */
        public void setPricingControl(PricingControl pricingControl) {
            this.pricingControl = pricingControl;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessagingDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MDRSubset" minOccurs="0">
         *         &lt;!-- Reference to inner class MDRSubset -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MessagingDetails implements Serializable
        {
            private MDRSubset MDRSubset1;

            /** 
             * Get the 'MDRSubset' element value.
             * 
             * @return value
             */
            public MDRSubset getMDRSubset1() {
                return MDRSubset1;
            }

            /** 
             * Set the 'MDRSubset' element value.
             * 
             * @param MDRSubset1
             */
            public void setMDRSubset1(MDRSubset MDRSubset1) {
                this.MDRSubset1 = MDRSubset1;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MDRSubset" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MDRSubset implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * For each specified location provide an alternate location.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateAirportCities" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SpecifiedLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="AlternateLocation" maxOccurs="5">
         *         &lt;!-- Reference to inner class AlternateLocation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateAirportCities implements Serializable
        {
            private String specifiedLocation;
            private List<AlternateLocation> alternateLocationList = new ArrayList<AlternateLocation>();

            /** 
             * Get the 'LocationCode' attribute value. A desired location (airport city).
             * 
             * @return value
             */
            public String getSpecifiedLocation() {
                return specifiedLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value. A desired location (airport city).
             * 
             * @param specifiedLocation
             */
            public void setSpecifiedLocation(String specifiedLocation) {
                this.specifiedLocation = specifiedLocation;
            }

            /** 
             * Get the list of 'AlternateLocation' element items.
             * 
             * @return list
             */
            public List<AlternateLocation> getAlternateLocationList() {
                return alternateLocationList;
            }

            /** 
             * Set the list of 'AlternateLocation' element items.
             * 
             * @param list
             */
            public void setAlternateLocationList(List<AlternateLocation> list) {
                alternateLocationList = list;
            }
            /** 
             * An alternate location (airport city).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateLocation" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AlternateLocation implements Serializable
            {
                private String locationCode;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
            }
        }
        /** 
         * Specify maximum allowed distance from specified airport.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateAirportMileage" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AllowBorderCross"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateAirportMileage implements Serializable
        {
            private String number;
            private Boolean allowBorderCross;

            /** 
             * Get the 'Number' attribute value. Maximum allowed number of miles from desired airport.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value. Maximum allowed number of miles from desired airport.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
             * 
             * @return value
             */
            public Boolean getAllowBorderCross() {
                return allowBorderCross;
            }

            /** 
             * Set the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
             * 
             * @param allowBorderCross
             */
            public void setAllowBorderCross(Boolean allowBorderCross) {
                this.allowBorderCross = allowBorderCross;
            }
        }
        /** 
         * Return information about Points Redemption
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PointsRedemption" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Enable"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PointsRedemption implements Serializable
        {
            private boolean enable;

            /** 
             * Get the 'Enable' attribute value.
             * 
             * @return value
             */
            public boolean isEnable() {
                return enable;
            }

            /** 
             * Set the 'Enable' attribute value.
             * 
             * @param enable
             */
            public void setEnable(boolean enable) {
                this.enable = enable;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SplitTaxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="ByLeg"/>
         *     &lt;xs:attribute type="xs:boolean" name="ByFareComponent"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SplitTaxes implements Serializable
        {
            private Boolean byLeg;
            private Boolean byFareComponent;

            /** 
             * Get the 'ByLeg' attribute value.
             * 
             * @return value
             */
            public Boolean getByLeg() {
                return byLeg;
            }

            /** 
             * Set the 'ByLeg' attribute value.
             * 
             * @param byLeg
             */
            public void setByLeg(Boolean byLeg) {
                this.byLeg = byLeg;
            }

            /** 
             * Get the 'ByFareComponent' attribute value.
             * 
             * @return value
             */
            public Boolean getByFareComponent() {
                return byFareComponent;
            }

            /** 
             * Set the 'ByFareComponent' attribute value.
             * 
             * @param byFareComponent
             */
            public void setByFareComponent(Boolean byFareComponent) {
                this.byFareComponent = byFareComponent;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateDatesProcessing" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="CalendarMode"/>
         *     &lt;xs:attribute type="xs:int" default="9" name="NumOptionsPerAlternateDate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateDatesProcessing implements Serializable
        {
            private Boolean calendarMode;
            private Integer numOptionsPerAlternateDate;

            /** 
             * Get the 'CalendarMode' attribute value.
             * 
             * @return value
             */
            public Boolean getCalendarMode() {
                return calendarMode;
            }

            /** 
             * Set the 'CalendarMode' attribute value.
             * 
             * @param calendarMode
             */
            public void setCalendarMode(Boolean calendarMode) {
                this.calendarMode = calendarMode;
            }

            /** 
             * Get the 'NumOptionsPerAlternateDate' attribute value.
             * 
             * @return value
             */
            public Integer getNumOptionsPerAlternateDate() {
                return numOptionsPerAlternateDate;
            }

            /** 
             * Set the 'NumOptionsPerAlternateDate' attribute value.
             * 
             * @param numOptionsPerAlternateDate
             */
            public void setNumOptionsPerAlternateDate(
                    Integer numOptionsPerAlternateDate) {
                this.numOptionsPerAlternateDate = numOptionsPerAlternateDate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryCache" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:unsignedInt" name="PublicTimeToLive"/>
         *     &lt;xs:attribute type="xs:boolean" name="RemovePreviousOnUpdate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryCache implements Serializable
        {
            private String publicTimeToLive;
            private Boolean removePreviousOnUpdate;

            /** 
             * Get the 'PublicTimeToLive' attribute value.
             * 
             * @return value
             */
            public String getPublicTimeToLive() {
                return publicTimeToLive;
            }

            /** 
             * Set the 'PublicTimeToLive' attribute value.
             * 
             * @param publicTimeToLive
             */
            public void setPublicTimeToLive(String publicTimeToLive) {
                this.publicTimeToLive = publicTimeToLive;
            }

            /** 
             * Get the 'RemovePreviousOnUpdate' attribute value.
             * 
             * @return value
             */
            public Boolean getRemovePreviousOnUpdate() {
                return removePreviousOnUpdate;
            }

            /** 
             * Set the 'RemovePreviousOnUpdate' attribute value.
             * 
             * @param removePreviousOnUpdate
             */
            public void setRemovePreviousOnUpdate(Boolean removePreviousOnUpdate) {
                this.removePreviousOnUpdate = removePreviousOnUpdate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiTicket" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute use="optional" name="DisplayPolicy">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class DisplayPolicy -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:string" use="optional" name="RequestedOneWays"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MultiTicket implements Serializable
        {
            private DisplayPolicy displayPolicy;
            private String requestedOneWays;

            /** 
             * Get the 'DisplayPolicy' attribute value. 
                              Display Option Policy, takes values:
                              - SOW - Show OneWays separately
                              - GOW2RT - Group OneWays and match to RoundTrip
                              - SCHS - Group OneWays, match to RoundTrip and show cheaper solution
                            
             * 
             * @return value
             */
            public DisplayPolicy getDisplayPolicy() {
                return displayPolicy;
            }

            /** 
             * Set the 'DisplayPolicy' attribute value. 
                              Display Option Policy, takes values:
                              - SOW - Show OneWays separately
                              - GOW2RT - Group OneWays and match to RoundTrip
                              - SCHS - Group OneWays, match to RoundTrip and show cheaper solution
                            
             * 
             * @param displayPolicy
             */
            public void setDisplayPolicy(DisplayPolicy displayPolicy) {
                this.displayPolicy = displayPolicy;
            }

            /** 
             * Get the 'RequestedOneWays' attribute value. Allow to set requested number of OneWays in MultiTicket processing
             * 
             * @return value
             */
            public String getRequestedOneWays() {
                return requestedOneWays;
            }

            /** 
             * Set the 'RequestedOneWays' attribute value. Allow to set requested number of OneWays in MultiTicket processing
             * 
             * @param requestedOneWays
             */
            public void setRequestedOneWays(String requestedOneWays) {
                this.requestedOneWays = requestedOneWays;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="SOW"/>
             *     &lt;xs:enumeration value="GOW2RT"/>
             *     &lt;xs:enumeration value="SCHS"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum DisplayPolicy implements Serializable {
                SOW("SOW"), GO_W2_RT("GOW2RT"), SCHS("SCHS");
                private final String value;

                private DisplayPolicy(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static DisplayPolicy convert(String value) {
                    for (DisplayPolicy inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Partitions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice maxOccurs="unbounded">
         *       &lt;!-- Reference to inner class PartitionsInner -->
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Partitions implements Serializable
        {
            private List<PartitionsInner> partitionList = new ArrayList<PartitionsInner>();

            /** 
             * Get the list of 'Partitions' element items.
             * 
             * @return list
             */
            public List<PartitionsInner> getPartitionList() {
                return partitionList;
            }

            /** 
             * Set the list of 'Partitions' element items.
             * 
             * @param list
             */
            public void setPartitionList(List<PartitionsInner> list) {
                partitionList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
             *   &lt;xs:element type="ns:CachePartitionType" name="Partition"/>
             *   &lt;xs:element type="ns:CachePartitionGroupType" name="Group"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class PartitionsInner implements Serializable
            {
                private int partitionListSelect = -1;
                private static final int PARTITION_CHOICE = 0;
                private static final int GROUP_CHOICE = 1;
                private CachePartitionType partition;
                private CachePartitionGroupType group;

                private void setPartitionListSelect(int choice) {
                    if (partitionListSelect == -1) {
                        partitionListSelect = choice;
                    } else if (partitionListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPartitionListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPartitionListSelect() {
                    partitionListSelect = -1;
                }

                /** 
                 * Check if Partition is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPartition() {
                    return partitionListSelect == PARTITION_CHOICE;
                }

                /** 
                 * Get the 'Partition' element value.
                 * 
                 * @return value
                 */
                public CachePartitionType getPartition() {
                    return partition;
                }

                /** 
                 * Set the 'Partition' element value.
                 * 
                 * @param partition
                 */
                public void setPartition(CachePartitionType partition) {
                    setPartitionListSelect(PARTITION_CHOICE);
                    this.partition = partition;
                }

                /** 
                 * Check if Group is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifGroup() {
                    return partitionListSelect == GROUP_CHOICE;
                }

                /** 
                 * Get the 'Group' element value.
                 * 
                 * @return value
                 */
                public CachePartitionGroupType getGroup() {
                    return group;
                }

                /** 
                 * Set the 'Group' element value.
                 * 
                 * @param group
                 */
                public void setGroup(CachePartitionGroupType group) {
                    setPartitionListSelect(GROUP_CHOICE);
                    this.group = group;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationData" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="DKNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReservationData implements Serializable
        {
            private String DKNumber;

            /** 
             * Get the 'DKNumber' attribute value. DK number
             * 
             * @return value
             */
            public String getDKNumber() {
                return DKNumber;
            }

            /** 
             * Set the 'DKNumber' attribute value. DK number
             * 
             * @param DKNumber
             */
            public void setDKNumber(String DKNumber) {
                this.DKNumber = DKNumber;
            }
        }
        /** 
         * Groups switches that control the behavior of the ASR response.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseControl" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ConnectionOrientedResponse" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class ConnectionOrientedResponse -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="TaxBreakdown"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ResponseControl implements Serializable
        {
            private ConnectionOrientedResponse connectionOrientedResponse;
            private Boolean taxBreakdown;

            /** 
             * Get the 'ConnectionOrientedResponse' element value.
             * 
             * @return value
             */
            public ConnectionOrientedResponse getConnectionOrientedResponse() {
                return connectionOrientedResponse;
            }

            /** 
             * Set the 'ConnectionOrientedResponse' element value.
             * 
             * @param connectionOrientedResponse
             */
            public void setConnectionOrientedResponse(
                    ConnectionOrientedResponse connectionOrientedResponse) {
                this.connectionOrientedResponse = connectionOrientedResponse;
            }

            /** 
             * Get the 'TaxBreakdown' attribute value. When true, the response will contain information about each tax applied separately, not only the sum.
             * 
             * @return value
             */
            public Boolean getTaxBreakdown() {
                return taxBreakdown;
            }

            /** 
             * Set the 'TaxBreakdown' attribute value. When true, the response will contain information about each tax applied separately, not only the sum.
             * 
             * @param taxBreakdown
             */
            public void setTaxBreakdown(Boolean taxBreakdown) {
                this.taxBreakdown = taxBreakdown;
            }
            /** 
             * Groups attributes that control whether the response is in a Connection-Oriented or Full-Itinerary mode.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionOrientedResponse" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Enabled"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ItineraryPrices"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="AllLegs"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ConnectionOrientedResponse implements
                Serializable
            {
                private boolean enabled;
                private Boolean itineraryPrices;
                private Boolean allLegs;

                /** 
                 * Get the 'Enabled' attribute value. If true, the response will contain only the information about currently shopped leg. Sold out and unavailable connections will be returned along. If false or the element is absent, whole itineraries will be returned.
                 * 
                 * @return value
                 */
                public boolean isEnabled() {
                    return enabled;
                }

                /** 
                 * Set the 'Enabled' attribute value. If true, the response will contain only the information about currently shopped leg. Sold out and unavailable connections will be returned along. If false or the element is absent, whole itineraries will be returned.
                 * 
                 * @param enabled
                 */
                public void setEnabled(boolean enabled) {
                    this.enabled = enabled;
                }

                /** 
                 * Get the 'ItineraryPrices' attribute value. If true, each returned option will have the price of the whole itinerary, even though the flight data is returned for a single leg of a journey. If false, each returned option will have the price of the currently shopped leg rather than the whole itinerary price. This attribute has no effect when attribute Enabled is set to false.
                 * 
                 * @return value
                 */
                public Boolean getItineraryPrices() {
                    return itineraryPrices;
                }

                /** 
                 * Set the 'ItineraryPrices' attribute value. If true, each returned option will have the price of the whole itinerary, even though the flight data is returned for a single leg of a journey. If false, each returned option will have the price of the currently shopped leg rather than the whole itinerary price. This attribute has no effect when attribute Enabled is set to false.
                 * 
                 * @param itineraryPrices
                 */
                public void setItineraryPrices(Boolean itineraryPrices) {
                    this.itineraryPrices = itineraryPrices;
                }

                /** 
                 * Get the 'AllLegs' attribute value. If true, response will contain information about outbound and inbound flights in one response.
                 * 
                 * @return value
                 */
                public Boolean getAllLegs() {
                    return allLegs;
                }

                /** 
                 * Set the 'AllLegs' attribute value. If true, response will contain information about outbound and inbound flights in one response.
                 * 
                 * @param allLegs
                 */
                public void setAllLegs(Boolean allLegs) {
                    this.allLegs = allLegs;
                }
            }
        }
        /** 
         * Machine Learning Extension's parameters
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BestOffers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Config" minOccurs="0">
         *         &lt;!-- Reference to inner class Config -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="Active"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BestOffers implements Serializable
        {
            private Config config;
            private Boolean active;

            /** 
             * Get the 'Config' element value.
             * 
             * @return value
             */
            public Config getConfig() {
                return config;
            }

            /** 
             * Set the 'Config' element value.
             * 
             * @param config
             */
            public void setConfig(Config config) {
                this.config = config;
            }

            /** 
             * Get the 'Active' attribute value. Allows for deactivation of ML extension when specified 'False'. 'True' by default.
             * 
             * @return value
             */
            public Boolean getActive() {
                return active;
            }

            /** 
             * Set the 'Active' attribute value. Allows for deactivation of ML extension when specified 'False'. 'True' by default.
             * 
             * @param active
             */
            public void setActive(Boolean active) {
                this.active = active;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Config" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Config implements Serializable
            {
                private String ID;

                /** 
                 * Get the 'ID' attribute value. Name of customer defined configuration to be used in transaction.
                 * 
                 * @return value
                 */
                public String getID() {
                    return ID;
                }

                /** 
                 * Set the 'ID' attribute value. Name of customer defined configuration to be used in transaction.
                 * 
                 * @param ID
                 */
                public void setID(String ID) {
                    this.ID = ID;
                }
            }
        }
        /** 
         * Control over which Rich Content elements should be returned in response
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RichContent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FlightAmenities"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SeatInfo"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RichContent implements Serializable
        {
            private Boolean flightAmenities;
            private Boolean seatInfo;

            /** 
             * Get the 'FlightAmenities' attribute value. Return amenities associated with flights, such as seat seat pitch.
             * 
             * @return value
             */
            public Boolean getFlightAmenities() {
                return flightAmenities;
            }

            /** 
             * Set the 'FlightAmenities' attribute value. Return amenities associated with flights, such as seat seat pitch.
             * 
             * @param flightAmenities
             */
            public void setFlightAmenities(Boolean flightAmenities) {
                this.flightAmenities = flightAmenities;
            }

            /** 
             * Get the 'SeatInfo' attribute value. Enable SeatComfort info mode
             * 
             * @return value
             */
            public Boolean getSeatInfo() {
                return seatInfo;
            }

            /** 
             * Set the 'SeatInfo' attribute value. Enable SeatComfort info mode
             * 
             * @param seatInfo
             */
            public void setSeatInfo(Boolean seatInfo) {
                this.seatInfo = seatInfo;
            }
        }
        /** 
         * Configuration that affects how solutions are priced.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingControl" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute use="optional" default="External" name="Mode">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Mode -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingControl implements Serializable
        {
            private Mode mode;

            /** 
             * Get the 'Mode' attribute value.
             * 
             * @return value
             */
            public Mode getMode() {
                return mode;
            }

            /** 
             * Set the 'Mode' attribute value.
             * 
             * @param mode
             */
            public void setMode(Mode mode) {
                this.mode = mode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="External"/>
             *     &lt;xs:enumeration value="Internal"/>
             *     &lt;xs:enumeration value="Dynamic"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Mode implements Serializable {
                /** 
                 * Use fares filed by default means.
                 */
                EXTERNAL("External"), /** 
                                       * Use fares filed by alternate means.
                                       */
                INTERNAL("Internal"), /** 
                                       * Use fares filed by alternate means and use dynamic currency conversion algorithm.
                                       */
                DYNAMIC("Dynamic");
                private final String value;

                private Mode(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Mode convert(String value) {
                    for (Mode inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
    }
}
