
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 The Low Fare Search Response message contains a number of .Priced Itinerary. options. Each includes:
 - A set of available flights matching the client.s request.
 - Pricing information including taxes and full fare breakdown for each passenger type
 - Ticketing information
 - Fare Basis Codes and the information necessary to make a rules entry.
 This message contains similar information to a standard airline CRS or GDS Low Fare Search Response message.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirLowFareSearchRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ErrorsType" name="Errors" minOccurs="0"/>
 *         &lt;xs:sequence>
 *           &lt;!-- Reference to inner class Sequence -->
 *         &lt;/xs:sequence>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="PricedItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class PricedItineraries -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="OneWayItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class OneWayItineraries -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="DepartedItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class DepartedItineraries -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="SoldOutItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class SoldOutItineraries -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="AvailableItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class AvailableItineraries -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *         &lt;!-- Reference to inner class TPAExtensions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="PricedItinCount"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="BrandedOneWayItinCount"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="SimpleOneWayItinCount"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="DepartedItinCount"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="SoldOutItinCount"/>
 *     &lt;xs:attribute type="xs:short" use="optional" name="AvailableItinCount"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirLowFareSearchRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int ERRORS_CHOICE = 0;
    private static final int SEQUENCE_CHOICE = 1;
    private ErrorsType errors;
    private Sequence sequence;
    private PricedItineraries pricedItineraries;
    private OneWayItineraries oneWayItineraries;
    private DepartedItineraries departedItineraries;
    private SoldOutItineraries soldOutItineraries;
    private AvailableItineraries availableItineraries;
    private TPAExtensions TPAExtensions1;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;
    private Short pricedItinCount;
    private Short brandedOneWayItinCount;
    private Short simpleOneWayItinCount;
    private Short departedItinCount;
    private Short soldOutItinCount;
    private Short availableItinCount;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value. In case of failure errors are returned.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value. In case of failure errors are returned.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }

    /** 
     * Get the 'PricedItineraries' element value.
     * 
     * @return value
     */
    public PricedItineraries getPricedItineraries() {
        return pricedItineraries;
    }

    /** 
     * Set the 'PricedItineraries' element value.
     * 
     * @param pricedItineraries
     */
    public void setPricedItineraries(PricedItineraries pricedItineraries) {
        this.pricedItineraries = pricedItineraries;
    }

    /** 
     * Get the 'OneWayItineraries' element value.
     * 
     * @return value
     */
    public OneWayItineraries getOneWayItineraries() {
        return oneWayItineraries;
    }

    /** 
     * Set the 'OneWayItineraries' element value.
     * 
     * @param oneWayItineraries
     */
    public void setOneWayItineraries(OneWayItineraries oneWayItineraries) {
        this.oneWayItineraries = oneWayItineraries;
    }

    /** 
     * Get the 'DepartedItineraries' element value.
     * 
     * @return value
     */
    public DepartedItineraries getDepartedItineraries() {
        return departedItineraries;
    }

    /** 
     * Set the 'DepartedItineraries' element value.
     * 
     * @param departedItineraries
     */
    public void setDepartedItineraries(DepartedItineraries departedItineraries) {
        this.departedItineraries = departedItineraries;
    }

    /** 
     * Get the 'SoldOutItineraries' element value.
     * 
     * @return value
     */
    public SoldOutItineraries getSoldOutItineraries() {
        return soldOutItineraries;
    }

    /** 
     * Set the 'SoldOutItineraries' element value.
     * 
     * @param soldOutItineraries
     */
    public void setSoldOutItineraries(SoldOutItineraries soldOutItineraries) {
        this.soldOutItineraries = soldOutItineraries;
    }

    /** 
     * Get the 'AvailableItineraries' element value.
     * 
     * @return value
     */
    public AvailableItineraries getAvailableItineraries() {
        return availableItineraries;
    }

    /** 
     * Set the 'AvailableItineraries' element value.
     * 
     * @param availableItineraries
     */
    public void setAvailableItineraries(
            AvailableItineraries availableItineraries) {
        this.availableItineraries = availableItineraries;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }

    /** 
     * Get the 'PricedItinCount' attribute value. Itinerary count for Priced Round-Trip itineraries
     * 
     * @return value
     */
    public Short getPricedItinCount() {
        return pricedItinCount;
    }

    /** 
     * Set the 'PricedItinCount' attribute value. Itinerary count for Priced Round-Trip itineraries
     * 
     * @param pricedItinCount
     */
    public void setPricedItinCount(Short pricedItinCount) {
        this.pricedItinCount = pricedItinCount;
    }

    /** 
     * Get the 'BrandedOneWayItinCount' attribute value. Itinerary count for Branded One-Way itineraries
     * 
     * @return value
     */
    public Short getBrandedOneWayItinCount() {
        return brandedOneWayItinCount;
    }

    /** 
     * Set the 'BrandedOneWayItinCount' attribute value. Itinerary count for Branded One-Way itineraries
     * 
     * @param brandedOneWayItinCount
     */
    public void setBrandedOneWayItinCount(Short brandedOneWayItinCount) {
        this.brandedOneWayItinCount = brandedOneWayItinCount;
    }

    /** 
     * Get the 'SimpleOneWayItinCount' attribute value. Itinerary count for Simple One-Way itineraries
     * 
     * @return value
     */
    public Short getSimpleOneWayItinCount() {
        return simpleOneWayItinCount;
    }

    /** 
     * Set the 'SimpleOneWayItinCount' attribute value. Itinerary count for Simple One-Way itineraries
     * 
     * @param simpleOneWayItinCount
     */
    public void setSimpleOneWayItinCount(Short simpleOneWayItinCount) {
        this.simpleOneWayItinCount = simpleOneWayItinCount;
    }

    /** 
     * Get the 'DepartedItinCount' attribute value. Itinerary count for departed itineraries returned
     * 
     * @return value
     */
    public Short getDepartedItinCount() {
        return departedItinCount;
    }

    /** 
     * Set the 'DepartedItinCount' attribute value. Itinerary count for departed itineraries returned
     * 
     * @param departedItinCount
     */
    public void setDepartedItinCount(Short departedItinCount) {
        this.departedItinCount = departedItinCount;
    }

    /** 
     * Get the 'SoldOutItinCount' attribute value. Itinerary count for sold out itineraries returned
     * 
     * @return value
     */
    public Short getSoldOutItinCount() {
        return soldOutItinCount;
    }

    /** 
     * Set the 'SoldOutItinCount' attribute value. Itinerary count for sold out itineraries returned
     * 
     * @param soldOutItinCount
     */
    public void setSoldOutItinCount(Short soldOutItinCount) {
        this.soldOutItinCount = soldOutItinCount;
    }

    /** 
     * Get the 'AvailableItinCount' attribute value. Itinerary count for available itineraries returned
     * 
     * @return value
     */
    public Short getAvailableItinCount() {
        return availableItinCount;
    }

    /** 
     * Set the 'AvailableItinCount' attribute value. Itinerary count for available itineraries returned
     * 
     * @param availableItinCount
     */
    public void setAvailableItinCount(Short availableItinCount) {
        this.availableItinCount = availableItinCount;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="ns:SuccessType" name="Success" minOccurs="0"/>
     *   &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
     *   &lt;xs:element type="ns:ShelvesDefinitionsType" name="ShelvesDefinitions" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:BrandFeatureListType" name="BrandFeatures" minOccurs="0"/>
     *   &lt;xs:element type="ns:FlightAmenitiesListType" name="FlightAmenities" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private SuccessType success;
        private WarningsType warnings;
        private ShelvesDefinitionsType shelvesDefinitions;
        private BrandFeatureListType brandFeatures;
        private FlightAmenitiesListType flightAmenities;

        /** 
         * Get the 'Success' element value. In case of success this element is returned.
         * 
         * @return value
         */
        public SuccessType getSuccess() {
            return success;
        }

        /** 
         * Set the 'Success' element value. In case of success this element is returned.
         * 
         * @param success
         */
        public void setSuccess(SuccessType success) {
            this.success = success;
        }

        /** 
         * Get the 'Warnings' element value. In case of any warnings this element is returned.
         * 
         * @return value
         */
        public WarningsType getWarnings() {
            return warnings;
        }

        /** 
         * Set the 'Warnings' element value. In case of any warnings this element is returned.
         * 
         * @param warnings
         */
        public void setWarnings(WarningsType warnings) {
            this.warnings = warnings;
        }

        /** 
         * Get the 'ShelvesDefinitions' element value. Shelves information
         * 
         * @return value
         */
        public ShelvesDefinitionsType getShelvesDefinitions() {
            return shelvesDefinitions;
        }

        /** 
         * Set the 'ShelvesDefinitions' element value. Shelves information
         * 
         * @param shelvesDefinitions
         */
        public void setShelvesDefinitions(
                ShelvesDefinitionsType shelvesDefinitions) {
            this.shelvesDefinitions = shelvesDefinitions;
        }

        /** 
         * Get the 'BrandFeatures' element value. Final list of all brand feature items
         * 
         * @return value
         */
        public BrandFeatureListType getBrandFeatures() {
            return brandFeatures;
        }

        /** 
         * Set the 'BrandFeatures' element value. Final list of all brand feature items
         * 
         * @param brandFeatures
         */
        public void setBrandFeatures(BrandFeatureListType brandFeatures) {
            this.brandFeatures = brandFeatures;
        }

        /** 
         * Get the 'FlightAmenities' element value.
         * 
         * @return value
         */
        public FlightAmenitiesListType getFlightAmenities() {
            return flightAmenities;
        }

        /** 
         * Set the 'FlightAmenities' element value.
         * 
         * @param flightAmenities
         */
        public void setFlightAmenities(FlightAmenitiesListType flightAmenities) {
            this.flightAmenities = flightAmenities;
        }
    }
    /** 
     * Low Fare priced itineraries container.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
     *         &lt;!-- Reference to inner class TPAExtensions -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PricedItineraries implements Serializable
    {
        private TPAExtensions TPAExtensions1;
        private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();

        /** 
         * Get the 'TPA_Extensions' element value.
         * 
         * @return value
         */
        public TPAExtensions getTPAExtensions1() {
            return TPAExtensions1;
        }

        /** 
         * Set the 'TPA_Extensions' element value.
         * 
         * @param TPAExtensions1
         */
        public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
            this.TPAExtensions1 = TPAExtensions1;
        }

        /** 
         * Get the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
         * 
         * @return list
         */
        public List<PricedItineraryType> getPricedItineraryList() {
            return pricedItineraryList;
        }

        /** 
         * Set the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
         * 
         * @param list
         */
        public void setPricedItineraryList(List<PricedItineraryType> list) {
            pricedItineraryList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ComplexProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TPAExtensions implements Serializable
        {
            private List<ComplexProcessingMessageType> processingMessageList = new ArrayList<ComplexProcessingMessageType>();

            /** 
             * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
             * 
             * @return list
             */
            public List<ComplexProcessingMessageType> getProcessingMessageList() {
                return processingMessageList;
            }

            /** 
             * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
             * 
             * @param list
             */
            public void setProcessingMessageList(
                    List<ComplexProcessingMessageType> list) {
                processingMessageList = list;
            }
        }
    }
    /** 
     * Successfull Low Fare priced itineraries in response to a Simplified One Way request.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OneWayItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
     *         &lt;!-- Reference to inner class BrandedOneWayItineraries -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
     *         &lt;!-- Reference to inner class SimpleOneWayItineraries -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OneWayItineraries implements Serializable
    {
        private List<BrandedOneWayItineraries> brandedOneWayItineraryList = new ArrayList<BrandedOneWayItineraries>();
        private List<SimpleOneWayItineraries> simpleOneWayItineraryList = new ArrayList<SimpleOneWayItineraries>();

        /** 
         * Get the list of 'BrandedOneWayItineraries' element items.
         * 
         * @return list
         */
        public List<BrandedOneWayItineraries> getBrandedOneWayItineraryList() {
            return brandedOneWayItineraryList;
        }

        /** 
         * Set the list of 'BrandedOneWayItineraries' element items.
         * 
         * @param list
         */
        public void setBrandedOneWayItineraryList(
                List<BrandedOneWayItineraries> list) {
            brandedOneWayItineraryList = list;
        }

        /** 
         * Get the list of 'SimpleOneWayItineraries' element items.
         * 
         * @return list
         */
        public List<SimpleOneWayItineraries> getSimpleOneWayItineraryList() {
            return simpleOneWayItineraryList;
        }

        /** 
         * Set the list of 'SimpleOneWayItineraries' element items.
         * 
         * @param list
         */
        public void setSimpleOneWayItineraryList(
                List<SimpleOneWayItineraries> list) {
            simpleOneWayItineraryList = list;
        }
        /** 
         * Container for priced itineraries assigned to particular leg.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
         *         &lt;!-- Reference to inner class TPAExtensions -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BrandedOneWayItineraries implements Serializable
        {
            private TPAExtensions TPAExtensions1;
            private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
            private String RPH;

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensions getTPAExtensions1() {
                return TPAExtensions1;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions1
             */
            public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                this.TPAExtensions1 = TPAExtensions1;
            }

            /** 
             * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
             * 
             * @return list
             */
            public List<PricedItineraryType> getPricedItineraryList() {
                return pricedItineraryList;
            }

            /** 
             * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
             * 
             * @param list
             */
            public void setPricedItineraryList(List<PricedItineraryType> list) {
                pricedItineraryList = list;
            }

            /** 
             * Get the 'RPH' attribute value. Leg ID from request.
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. Leg ID from request.
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TPAExtensions implements Serializable
            {
                private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                /** 
                 * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @return list
                 */
                public List<OneWayProcessingMessageType> getProcessingMessageList() {
                    return processingMessageList;
                }

                /** 
                 * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @param list
                 */
                public void setProcessingMessageList(
                        List<OneWayProcessingMessageType> list) {
                    processingMessageList = list;
                }
            }
        }
        /** 
         * Container for priced itineraries assigned to particular leg.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
         *         &lt;!-- Reference to inner class TPAExtensions -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SimpleOneWayItineraries implements Serializable
        {
            private TPAExtensions TPAExtensions1;
            private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
            private String RPH;

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensions getTPAExtensions1() {
                return TPAExtensions1;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions1
             */
            public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                this.TPAExtensions1 = TPAExtensions1;
            }

            /** 
             * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
             * 
             * @return list
             */
            public List<PricedItineraryType> getPricedItineraryList() {
                return pricedItineraryList;
            }

            /** 
             * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
             * 
             * @param list
             */
            public void setPricedItineraryList(List<PricedItineraryType> list) {
                pricedItineraryList = list;
            }

            /** 
             * Get the 'RPH' attribute value. Leg ID from request.
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. Leg ID from request.
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TPAExtensions implements Serializable
            {
                private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                /** 
                 * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @return list
                 */
                public List<OneWayProcessingMessageType> getProcessingMessageList() {
                    return processingMessageList;
                }

                /** 
                 * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @param list
                 */
                public void setProcessingMessageList(
                        List<OneWayProcessingMessageType> list) {
                    processingMessageList = list;
                }
            }
        }
    }
    /** 
     * Departed Itineraries
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartedItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PricedItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class PricedItineraries -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OneWayItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class OneWayItineraries -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DepartedItineraries implements Serializable
    {
        private PricedItineraries pricedItineraries;
        private OneWayItineraries oneWayItineraries;

        /** 
         * Get the 'PricedItineraries' element value.
         * 
         * @return value
         */
        public PricedItineraries getPricedItineraries() {
            return pricedItineraries;
        }

        /** 
         * Set the 'PricedItineraries' element value.
         * 
         * @param pricedItineraries
         */
        public void setPricedItineraries(PricedItineraries pricedItineraries) {
            this.pricedItineraries = pricedItineraries;
        }

        /** 
         * Get the 'OneWayItineraries' element value.
         * 
         * @return value
         */
        public OneWayItineraries getOneWayItineraries() {
            return oneWayItineraries;
        }

        /** 
         * Set the 'OneWayItineraries' element value.
         * 
         * @param oneWayItineraries
         */
        public void setOneWayItineraries(OneWayItineraries oneWayItineraries) {
            this.oneWayItineraries = oneWayItineraries;
        }
        /** 
         * Low Fare priced itineraries container.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
         *         &lt;!-- Reference to inner class TPAExtensions -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedItineraries implements Serializable
        {
            private TPAExtensions TPAExtensions1;
            private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensions getTPAExtensions1() {
                return TPAExtensions1;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions1
             */
            public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                this.TPAExtensions1 = TPAExtensions1;
            }

            /** 
             * Get the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @return list
             */
            public List<PricedItineraryType> getPricedItineraryList() {
                return pricedItineraryList;
            }

            /** 
             * Set the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @param list
             */
            public void setPricedItineraryList(List<PricedItineraryType> list) {
                pricedItineraryList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:ComplexProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TPAExtensions implements Serializable
            {
                private List<ComplexProcessingMessageType> processingMessageList = new ArrayList<ComplexProcessingMessageType>();

                /** 
                 * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @return list
                 */
                public List<ComplexProcessingMessageType> getProcessingMessageList() {
                    return processingMessageList;
                }

                /** 
                 * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @param list
                 */
                public void setProcessingMessageList(
                        List<ComplexProcessingMessageType> list) {
                    processingMessageList = list;
                }
            }
        }
        /** 
         * Successfull Low Fare priced itineraries in response to a Simplified One Way request.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OneWayItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class BrandedOneWayItineraries -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class SimpleOneWayItineraries -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OneWayItineraries implements Serializable
        {
            private List<BrandedOneWayItineraries> brandedOneWayItineraryList = new ArrayList<BrandedOneWayItineraries>();
            private List<SimpleOneWayItineraries> simpleOneWayItineraryList = new ArrayList<SimpleOneWayItineraries>();

            /** 
             * Get the list of 'BrandedOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<BrandedOneWayItineraries> getBrandedOneWayItineraryList() {
                return brandedOneWayItineraryList;
            }

            /** 
             * Set the list of 'BrandedOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setBrandedOneWayItineraryList(
                    List<BrandedOneWayItineraries> list) {
                brandedOneWayItineraryList = list;
            }

            /** 
             * Get the list of 'SimpleOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<SimpleOneWayItineraries> getSimpleOneWayItineraryList() {
                return simpleOneWayItineraryList;
            }

            /** 
             * Set the list of 'SimpleOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setSimpleOneWayItineraryList(
                    List<SimpleOneWayItineraries> list) {
                simpleOneWayItineraryList = list;
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BrandedOneWayItineraries implements
                Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SimpleOneWayItineraries implements Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
        }
    }
    /** 
     * Sold Out Itineraries
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SoldOutItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PricedItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class PricedItineraries -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OneWayItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class OneWayItineraries -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SoldOutItineraries implements Serializable
    {
        private PricedItineraries pricedItineraries;
        private OneWayItineraries oneWayItineraries;

        /** 
         * Get the 'PricedItineraries' element value.
         * 
         * @return value
         */
        public PricedItineraries getPricedItineraries() {
            return pricedItineraries;
        }

        /** 
         * Set the 'PricedItineraries' element value.
         * 
         * @param pricedItineraries
         */
        public void setPricedItineraries(PricedItineraries pricedItineraries) {
            this.pricedItineraries = pricedItineraries;
        }

        /** 
         * Get the 'OneWayItineraries' element value.
         * 
         * @return value
         */
        public OneWayItineraries getOneWayItineraries() {
            return oneWayItineraries;
        }

        /** 
         * Set the 'OneWayItineraries' element value.
         * 
         * @param oneWayItineraries
         */
        public void setOneWayItineraries(OneWayItineraries oneWayItineraries) {
            this.oneWayItineraries = oneWayItineraries;
        }
        /** 
         * Low Fare priced itineraries container.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
         *         &lt;!-- Reference to inner class TPAExtensions -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedItineraries implements Serializable
        {
            private TPAExtensions TPAExtensions1;
            private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensions getTPAExtensions1() {
                return TPAExtensions1;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions1
             */
            public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                this.TPAExtensions1 = TPAExtensions1;
            }

            /** 
             * Get the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @return list
             */
            public List<PricedItineraryType> getPricedItineraryList() {
                return pricedItineraryList;
            }

            /** 
             * Set the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @param list
             */
            public void setPricedItineraryList(List<PricedItineraryType> list) {
                pricedItineraryList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:ComplexProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TPAExtensions implements Serializable
            {
                private List<ComplexProcessingMessageType> processingMessageList = new ArrayList<ComplexProcessingMessageType>();

                /** 
                 * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @return list
                 */
                public List<ComplexProcessingMessageType> getProcessingMessageList() {
                    return processingMessageList;
                }

                /** 
                 * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @param list
                 */
                public void setProcessingMessageList(
                        List<ComplexProcessingMessageType> list) {
                    processingMessageList = list;
                }
            }
        }
        /** 
         * Successfull Low Fare priced itineraries in response to a Simplified One Way request.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OneWayItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class BrandedOneWayItineraries -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class SimpleOneWayItineraries -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OneWayItineraries implements Serializable
        {
            private List<BrandedOneWayItineraries> brandedOneWayItineraryList = new ArrayList<BrandedOneWayItineraries>();
            private List<SimpleOneWayItineraries> simpleOneWayItineraryList = new ArrayList<SimpleOneWayItineraries>();

            /** 
             * Get the list of 'BrandedOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<BrandedOneWayItineraries> getBrandedOneWayItineraryList() {
                return brandedOneWayItineraryList;
            }

            /** 
             * Set the list of 'BrandedOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setBrandedOneWayItineraryList(
                    List<BrandedOneWayItineraries> list) {
                brandedOneWayItineraryList = list;
            }

            /** 
             * Get the list of 'SimpleOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<SimpleOneWayItineraries> getSimpleOneWayItineraryList() {
                return simpleOneWayItineraryList;
            }

            /** 
             * Set the list of 'SimpleOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setSimpleOneWayItineraryList(
                    List<SimpleOneWayItineraries> list) {
                simpleOneWayItineraryList = list;
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BrandedOneWayItineraries implements
                Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SimpleOneWayItineraries implements Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
        }
    }
    /** 
     * Available Itineraries
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AvailableItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PricedItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class PricedItineraries -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OneWayItineraries" minOccurs="0">
     *         &lt;!-- Reference to inner class OneWayItineraries -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AvailableItineraries implements Serializable
    {
        private PricedItineraries pricedItineraries;
        private OneWayItineraries oneWayItineraries;

        /** 
         * Get the 'PricedItineraries' element value.
         * 
         * @return value
         */
        public PricedItineraries getPricedItineraries() {
            return pricedItineraries;
        }

        /** 
         * Set the 'PricedItineraries' element value.
         * 
         * @param pricedItineraries
         */
        public void setPricedItineraries(PricedItineraries pricedItineraries) {
            this.pricedItineraries = pricedItineraries;
        }

        /** 
         * Get the 'OneWayItineraries' element value.
         * 
         * @return value
         */
        public OneWayItineraries getOneWayItineraries() {
            return oneWayItineraries;
        }

        /** 
         * Set the 'OneWayItineraries' element value.
         * 
         * @param oneWayItineraries
         */
        public void setOneWayItineraries(OneWayItineraries oneWayItineraries) {
            this.oneWayItineraries = oneWayItineraries;
        }
        /** 
         * Low Fare priced itineraries container.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
         *         &lt;!-- Reference to inner class TPAExtensions -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedItineraries implements Serializable
        {
            private TPAExtensions TPAExtensions1;
            private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensions getTPAExtensions1() {
                return TPAExtensions1;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions1
             */
            public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                this.TPAExtensions1 = TPAExtensions1;
            }

            /** 
             * Get the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @return list
             */
            public List<PricedItineraryType> getPricedItineraryList() {
                return pricedItineraryList;
            }

            /** 
             * Set the list of 'PricedItinerary' element items. Successfull Low Fare priced itineraries in response to a Low Fare Search request.
             * 
             * @param list
             */
            public void setPricedItineraryList(List<PricedItineraryType> list) {
                pricedItineraryList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:ComplexProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TPAExtensions implements Serializable
            {
                private List<ComplexProcessingMessageType> processingMessageList = new ArrayList<ComplexProcessingMessageType>();

                /** 
                 * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @return list
                 */
                public List<ComplexProcessingMessageType> getProcessingMessageList() {
                    return processingMessageList;
                }

                /** 
                 * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                 * 
                 * @param list
                 */
                public void setProcessingMessageList(
                        List<ComplexProcessingMessageType> list) {
                    processingMessageList = list;
                }
            }
        }
        /** 
         * Successfull Low Fare priced itineraries in response to a Simplified One Way request.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OneWayItineraries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class BrandedOneWayItineraries -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
         *         &lt;!-- Reference to inner class SimpleOneWayItineraries -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OneWayItineraries implements Serializable
        {
            private List<BrandedOneWayItineraries> brandedOneWayItineraryList = new ArrayList<BrandedOneWayItineraries>();
            private List<SimpleOneWayItineraries> simpleOneWayItineraryList = new ArrayList<SimpleOneWayItineraries>();

            /** 
             * Get the list of 'BrandedOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<BrandedOneWayItineraries> getBrandedOneWayItineraryList() {
                return brandedOneWayItineraryList;
            }

            /** 
             * Set the list of 'BrandedOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setBrandedOneWayItineraryList(
                    List<BrandedOneWayItineraries> list) {
                brandedOneWayItineraryList = list;
            }

            /** 
             * Get the list of 'SimpleOneWayItineraries' element items.
             * 
             * @return list
             */
            public List<SimpleOneWayItineraries> getSimpleOneWayItineraryList() {
                return simpleOneWayItineraryList;
            }

            /** 
             * Set the list of 'SimpleOneWayItineraries' element items.
             * 
             * @param list
             */
            public void setSimpleOneWayItineraryList(
                    List<SimpleOneWayItineraries> list) {
                simpleOneWayItineraryList = list;
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BrandedOneWayItineraries implements
                Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
            /** 
             * Container for priced itineraries assigned to particular leg.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SimpleOneWayItineraries" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
             *         &lt;!-- Reference to inner class TPAExtensions -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SimpleOneWayItineraries implements Serializable
            {
                private TPAExtensions TPAExtensions1;
                private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
                private String RPH;

                /** 
                 * Get the 'TPA_Extensions' element value.
                 * 
                 * @return value
                 */
                public TPAExtensions getTPAExtensions1() {
                    return TPAExtensions1;
                }

                /** 
                 * Set the 'TPA_Extensions' element value.
                 * 
                 * @param TPAExtensions1
                 */
                public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
                    this.TPAExtensions1 = TPAExtensions1;
                }

                /** 
                 * Get the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @return list
                 */
                public List<PricedItineraryType> getPricedItineraryList() {
                    return pricedItineraryList;
                }

                /** 
                 * Set the list of 'PricedItinerary' element items. Container for priced itinerary type.
                 * 
                 * @param list
                 */
                public void setPricedItineraryList(
                        List<PricedItineraryType> list) {
                    pricedItineraryList = list;
                }

                /** 
                 * Get the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. Leg ID from request.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:OneWayProcessingMessageType" name="ProcessingMessage" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TPAExtensions implements Serializable
                {
                    private List<OneWayProcessingMessageType> processingMessageList = new ArrayList<OneWayProcessingMessageType>();

                    /** 
                     * Get the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @return list
                     */
                    public List<OneWayProcessingMessageType> getProcessingMessageList() {
                        return processingMessageList;
                    }

                    /** 
                     * Set the list of 'ProcessingMessage' element items. Container for itinerary message type.
                     * 
                     * @param list
                     */
                    public void setProcessingMessageList(
                            List<OneWayProcessingMessageType> list) {
                        processingMessageList = list;
                    }
                }
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AirlineOrderList" minOccurs="0">
     *         &lt;!-- Reference to inner class AirlineOrderList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginalItinerary" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginalItinerary -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private AirlineOrderList airlineOrderList;
        private OriginalItinerary originalItinerary;

        /** 
         * Get the 'AirlineOrderList' element value.
         * 
         * @return value
         */
        public AirlineOrderList getAirlineOrderList() {
            return airlineOrderList;
        }

        /** 
         * Set the 'AirlineOrderList' element value.
         * 
         * @param airlineOrderList
         */
        public void setAirlineOrderList(AirlineOrderList airlineOrderList) {
            this.airlineOrderList = airlineOrderList;
        }

        /** 
         * Get the 'OriginalItinerary' element value.
         * 
         * @return value
         */
        public OriginalItinerary getOriginalItinerary() {
            return originalItinerary;
        }

        /** 
         * Set the 'OriginalItinerary' element value.
         * 
         * @param originalItinerary
         */
        public void setOriginalItinerary(OriginalItinerary originalItinerary) {
            this.originalItinerary = originalItinerary;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOrderList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirlineOrder" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AirlineOrder -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirlineOrderList implements Serializable
        {
            private List<AirlineOrder> airlineOrderList = new ArrayList<AirlineOrder>();

            /** 
             * Get the list of 'AirlineOrder' element items.
             * 
             * @return list
             */
            public List<AirlineOrder> getAirlineOrderList() {
                return airlineOrderList;
            }

            /** 
             * Set the list of 'AirlineOrder' element items.
             * 
             * @param list
             */
            public void setAirlineOrderList(List<AirlineOrder> list) {
                airlineOrderList = list;
            }
            /** 
             * The airline that filed the fare(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOrder" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="ns:CompanyNameType">
             *         &lt;xs:attribute type="xs:short" use="required" name="SequenceNumber"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirlineOrder implements Serializable
            {
                private CompanyNameType companyNameType;
                private Short sequenceNumber;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public CompanyNameType getCompanyNameType() {
                    return companyNameType;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param companyNameType
                 */
                public void setCompanyNameType(CompanyNameType companyNameType) {
                    this.companyNameType = companyNameType;
                }

                /** 
                 * Get the 'SequenceNumber' attribute value.
                 * 
                 * @return value
                 */
                public Short getSequenceNumber() {
                    return sequenceNumber;
                }

                /** 
                 * Set the 'SequenceNumber' attribute value.
                 * 
                 * @param sequenceNumber
                 */
                public void setSequenceNumber(Short sequenceNumber) {
                    this.sequenceNumber = sequenceNumber;
                }
            }
        }
        /** 
         * Summary of taxes calculated for original itinerary during Exchange transaction
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalItinerary" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Taxes" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginalItinerary implements Serializable
        {
            private List<Taxes> taxeList = new ArrayList<Taxes>();

            /** 
             * Get the list of 'Taxes' element items.
             * 
             * @return list
             */
            public List<Taxes> getTaxeList() {
                return taxeList;
            }

            /** 
             * Set the list of 'Taxes' element items.
             * 
             * @param list
             */
            public void setTaxeList(List<Taxes> list) {
                taxeList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:AirTaxType" name="Tax" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" use="required" name="PassengerIndex"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private List<AirTaxType> taxList = new ArrayList<AirTaxType>();
                private Integer passengerIndex;

                /** 
                 * Get the list of 'Tax' element items. Any individual tax applied to the fare
                 * 
                 * @return list
                 */
                public List<AirTaxType> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items. Any individual tax applied to the fare
                 * 
                 * @param list
                 */
                public void setTaxList(List<AirTaxType> list) {
                    taxList = list;
                }

                /** 
                 * Get the 'PassengerIndex' attribute value. Allows to associate taxes with specific requested passenger
                 * 
                 * @return value
                 */
                public Integer getPassengerIndex() {
                    return passengerIndex;
                }

                /** 
                 * Set the 'PassengerIndex' attribute value. Allows to associate taxes with specific requested passenger
                 * 
                 * @param passengerIndex
                 */
                public void setPassengerIndex(Integer passengerIndex) {
                    this.passengerIndex = passengerIndex;
                }
            }
        }
    }
}
