
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OneWayProcessingMessageType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ProcessingMessageType">
 *       &lt;xs:attribute type="xs:date" use="optional" name="DepartureDate"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="DepartureAirport"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ArrivalAirport"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OneWayProcessingMessageType extends ProcessingMessageType
    implements Serializable
{
    private Date departureDate;
    private String departureAirport;
    private String arrivalAirport;

    /** 
     * Get the 'DepartureDate' attribute value. Departure date
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. Departure date
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'DepartureAirport' attribute value. Location identifying code.
     * 
     * @return value
     */
    public String getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' attribute value. Location identifying code.
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(String departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'ArrivalAirport' attribute value. Location identifying code.
     * 
     * @return value
     */
    public String getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' attribute value. Location identifying code.
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(String arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }
}
