
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationFlightGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RequestLocationType" name="OriginLocation"/>
 *     &lt;xs:element type="ns:RequestLocationType" name="DestinationLocation"/>
 *     &lt;xs:element type="ns:AirlineType" name="Airline"/>
 *     &lt;xs:element type="ns:SideTripType" name="SideTrip" minOccurs="0"/>
 *     &lt;xs:element type="ns:ReservationType" name="Reservation" minOccurs="0"/>
 *     &lt;xs:element type="ns:MileageDisplayType" name="MileageDisplay" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="BookingDateTime" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class OriginDestinationFlightGroup implements Serializable
{
    private RequestLocationType originLocation;
    private RequestLocationType destinationLocation;
    private AirlineType airline;
    private SideTripType sideTrip;
    private ReservationType reservation;
    private List<MileageDisplayType> mileageDisplayList = new ArrayList<MileageDisplayType>();
    private String bookingDateTime;

    /** 
     * Get the 'OriginLocation' element value. Flight origin code
     * 
     * @return value
     */
    public RequestLocationType getOriginLocation() {
        return originLocation;
    }

    /** 
     * Set the 'OriginLocation' element value. Flight origin code
     * 
     * @param originLocation
     */
    public void setOriginLocation(RequestLocationType originLocation) {
        this.originLocation = originLocation;
    }

    /** 
     * Get the 'DestinationLocation' element value. Flight destination code
     * 
     * @return value
     */
    public RequestLocationType getDestinationLocation() {
        return destinationLocation;
    }

    /** 
     * Set the 'DestinationLocation' element value. Flight destination code
     * 
     * @param destinationLocation
     */
    public void setDestinationLocation(RequestLocationType destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    /** 
     * Get the 'Airline' element value. Airline information
     * 
     * @return value
     */
    public AirlineType getAirline() {
        return airline;
    }

    /** 
     * Set the 'Airline' element value. Airline information
     * 
     * @param airline
     */
    public void setAirline(AirlineType airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'SideTrip' element value. Side trip information
     * 
     * @return value
     */
    public SideTripType getSideTrip() {
        return sideTrip;
    }

    /** 
     * Set the 'SideTrip' element value. Side trip information
     * 
     * @param sideTrip
     */
    public void setSideTrip(SideTripType sideTrip) {
        this.sideTrip = sideTrip;
    }

    /** 
     * Get the 'Reservation' element value. Reservation information
     * 
     * @return value
     */
    public ReservationType getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value. Reservation information
     * 
     * @param reservation
     */
    public void setReservation(ReservationType reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the list of 'MileageDisplay' element items. Mileage information
     * 
     * @return list
     */
    public List<MileageDisplayType> getMileageDisplayList() {
        return mileageDisplayList;
    }

    /** 
     * Set the list of 'MileageDisplay' element items. Mileage information
     * 
     * @param list
     */
    public void setMileageDisplayList(List<MileageDisplayType> list) {
        mileageDisplayList = list;
    }

    /** 
     * Get the 'BookingDateTime' element value. Booking date and time
     * 
     * @return value
     */
    public String getBookingDateTime() {
        return bookingDateTime;
    }

    /** 
     * Set the 'BookingDateTime' element value. Booking date and time
     * 
     * @param bookingDateTime
     */
    public void setBookingDateTime(String bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
    }
}
