
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformationTPA_ExtensionsGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="DateFlexibility" minOccurs="0" maxOccurs="2">
 *       &lt;!-- Reference to inner class DateFlexibility -->
 *     &lt;/xs:element>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:RequestSpecifiedLocationType" name="SisterDestinationLocation" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element name="SisterDestinationMileage" minOccurs="0">
 *         &lt;!-- Reference to inner class SisterDestinationMileage -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:RequestSpecifiedLocationType" name="SisterOriginLocation" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element name="SisterOriginMileage" minOccurs="0">
 *         &lt;!-- Reference to inner class SisterOriginMileage -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:element name="SegmentType" minOccurs="0">
 *       &lt;!-- Reference to inner class SegmentType -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AlternateTime" minOccurs="0">
 *       &lt;!-- Reference to inner class AlternateTime -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="MaxOneWayOptions" minOccurs="0">
 *       &lt;!-- Reference to inner class MaxOneWayOptions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="NumOneWayOptions" minOccurs="0">
 *       &lt;!-- Reference to inner class NumOneWayOptions -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CabinPrefType" name="CabinPref" minOccurs="0"/>
 *     &lt;xs:element name="ConnectionTime" minOccurs="0">
 *       &lt;!-- Reference to inner class ConnectionTime -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TotalTravelTime" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class TotalTravelTime -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:SeatComfortPrefType" name="Seats" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class OriginDestinationInformationTPAExtensionsGroup implements
    Serializable
{
    private List<DateFlexibility> dateFlexibilityList = new ArrayList<DateFlexibility>();
    private int choiceSelect = -1;
    private static final int SISTER_DESTINATION_LOCATION_LIST_CHOICE = 0;
    private static final int SISTER_DESTINATION_MILEAGE_CHOICE = 1;
    private List<RequestSpecifiedLocationType> sisterDestinationLocationList = new ArrayList<RequestSpecifiedLocationType>();
    private SisterDestinationMileage sisterDestinationMileage;
    private int choiceSelect1 = -1;
    private static final int SISTER_ORIGIN_LOCATION_LIST_CHOICE = 0;
    private static final int SISTER_ORIGIN_MILEAGE_CHOICE = 1;
    private List<RequestSpecifiedLocationType> sisterOriginLocationList = new ArrayList<RequestSpecifiedLocationType>();
    private SisterOriginMileage sisterOriginMileage;
    private SegmentType segmentType;
    private AlternateTime alternateTime;
    private MaxOneWayOptions maxOneWayOptions;
    private NumOneWayOptions numOneWayOptions;
    private CabinPrefType cabinPref;
    private ConnectionTime connectionTime;
    private TotalTravelTime totalTravelTime;
    private SeatComfortPrefType seats;

    /** 
     * Get the list of 'DateFlexibility' element items.
     * 
     * @return list
     */
    public List<DateFlexibility> getDateFlexibilityList() {
        return dateFlexibilityList;
    }

    /** 
     * Set the list of 'DateFlexibility' element items.
     * 
     * @param list
     */
    public void setDateFlexibilityList(List<DateFlexibility> list) {
        dateFlexibilityList = list;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if SisterDestinationLocationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSisterDestinationLocationList() {
        return choiceSelect == SISTER_DESTINATION_LOCATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SisterDestinationLocation' element items. List of alternate destination cities to search
     * 
     * @return list
     */
    public List<RequestSpecifiedLocationType> getSisterDestinationLocationList() {
        return sisterDestinationLocationList;
    }

    /** 
     * Set the list of 'SisterDestinationLocation' element items. List of alternate destination cities to search
     * 
     * @param list
     */
    public void setSisterDestinationLocationList(
            List<RequestSpecifiedLocationType> list) {
        setChoiceSelect(SISTER_DESTINATION_LOCATION_LIST_CHOICE);
        sisterDestinationLocationList = list;
    }

    /** 
     * Check if SisterDestinationMileage is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSisterDestinationMileage() {
        return choiceSelect == SISTER_DESTINATION_MILEAGE_CHOICE;
    }

    /** 
     * Get the 'SisterDestinationMileage' element value.
     * 
     * @return value
     */
    public SisterDestinationMileage getSisterDestinationMileage() {
        return sisterDestinationMileage;
    }

    /** 
     * Set the 'SisterDestinationMileage' element value.
     * 
     * @param sisterDestinationMileage
     */
    public void setSisterDestinationMileage(
            SisterDestinationMileage sisterDestinationMileage) {
        setChoiceSelect(SISTER_DESTINATION_MILEAGE_CHOICE);
        this.sisterDestinationMileage = sisterDestinationMileage;
    }

    private void setChoiceSelect1(int choice) {
        if (choiceSelect1 == -1) {
            choiceSelect1 = choice;
        } else if (choiceSelect1 != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect1() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect1() {
        choiceSelect1 = -1;
    }

    /** 
     * Check if SisterOriginLocationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSisterOriginLocationList() {
        return choiceSelect1 == SISTER_ORIGIN_LOCATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SisterOriginLocation' element items. List of alternate origin cities to search
     * 
     * @return list
     */
    public List<RequestSpecifiedLocationType> getSisterOriginLocationList() {
        return sisterOriginLocationList;
    }

    /** 
     * Set the list of 'SisterOriginLocation' element items. List of alternate origin cities to search
     * 
     * @param list
     */
    public void setSisterOriginLocationList(
            List<RequestSpecifiedLocationType> list) {
        setChoiceSelect1(SISTER_ORIGIN_LOCATION_LIST_CHOICE);
        sisterOriginLocationList = list;
    }

    /** 
     * Check if SisterOriginMileage is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSisterOriginMileage() {
        return choiceSelect1 == SISTER_ORIGIN_MILEAGE_CHOICE;
    }

    /** 
     * Get the 'SisterOriginMileage' element value.
     * 
     * @return value
     */
    public SisterOriginMileage getSisterOriginMileage() {
        return sisterOriginMileage;
    }

    /** 
     * Set the 'SisterOriginMileage' element value.
     * 
     * @param sisterOriginMileage
     */
    public void setSisterOriginMileage(SisterOriginMileage sisterOriginMileage) {
        setChoiceSelect1(SISTER_ORIGIN_MILEAGE_CHOICE);
        this.sisterOriginMileage = sisterOriginMileage;
    }

    /** 
     * Get the 'SegmentType' element value.
     * 
     * @return value
     */
    public SegmentType getSegmentType() {
        return segmentType;
    }

    /** 
     * Set the 'SegmentType' element value.
     * 
     * @param segmentType
     */
    public void setSegmentType(SegmentType segmentType) {
        this.segmentType = segmentType;
    }

    /** 
     * Get the 'AlternateTime' element value.
     * 
     * @return value
     */
    public AlternateTime getAlternateTime() {
        return alternateTime;
    }

    /** 
     * Set the 'AlternateTime' element value.
     * 
     * @param alternateTime
     */
    public void setAlternateTime(AlternateTime alternateTime) {
        this.alternateTime = alternateTime;
    }

    /** 
     * Get the 'MaxOneWayOptions' element value.
     * 
     * @return value
     */
    public MaxOneWayOptions getMaxOneWayOptions() {
        return maxOneWayOptions;
    }

    /** 
     * Set the 'MaxOneWayOptions' element value.
     * 
     * @param maxOneWayOptions
     */
    public void setMaxOneWayOptions(MaxOneWayOptions maxOneWayOptions) {
        this.maxOneWayOptions = maxOneWayOptions;
    }

    /** 
     * Get the 'NumOneWayOptions' element value.
     * 
     * @return value
     */
    public NumOneWayOptions getNumOneWayOptions() {
        return numOneWayOptions;
    }

    /** 
     * Set the 'NumOneWayOptions' element value.
     * 
     * @param numOneWayOptions
     */
    public void setNumOneWayOptions(NumOneWayOptions numOneWayOptions) {
        this.numOneWayOptions = numOneWayOptions;
    }

    /** 
     * Get the 'CabinPref' element value. Defines preferred cabin to be used in a search for this leg level (if SegmentType is "O") or segment (if SegmentType is "X"). The cabin type specified in this element will override the cabin type specified at the request level for this leg/segment. If a cabin type is not specified for this element the cabin type at request level will be used as default for this leg or segment. If the cabin type is not specified at both the leg/segment level and request level a default cabin of "Economy" will be used?
     * 
     * @return value
     */
    public CabinPrefType getCabinPref() {
        return cabinPref;
    }

    /** 
     * Set the 'CabinPref' element value. Defines preferred cabin to be used in a search for this leg level (if SegmentType is "O") or segment (if SegmentType is "X"). The cabin type specified in this element will override the cabin type specified at the request level for this leg/segment. If a cabin type is not specified for this element the cabin type at request level will be used as default for this leg or segment. If the cabin type is not specified at both the leg/segment level and request level a default cabin of "Economy" will be used?
     * 
     * @param cabinPref
     */
    public void setCabinPref(CabinPrefType cabinPref) {
        this.cabinPref = cabinPref;
    }

    /** 
     * Get the 'ConnectionTime' element value.
     * 
     * @return value
     */
    public ConnectionTime getConnectionTime() {
        return connectionTime;
    }

    /** 
     * Set the 'ConnectionTime' element value.
     * 
     * @param connectionTime
     */
    public void setConnectionTime(ConnectionTime connectionTime) {
        this.connectionTime = connectionTime;
    }

    /** 
     * Get the 'TotalTravelTime' element value.
     * 
     * @return value
     */
    public TotalTravelTime getTotalTravelTime() {
        return totalTravelTime;
    }

    /** 
     * Set the 'TotalTravelTime' element value.
     * 
     * @param totalTravelTime
     */
    public void setTotalTravelTime(TotalTravelTime totalTravelTime) {
        this.totalTravelTime = totalTravelTime;
    }

    /** 
     * Get the 'Seats' element value. Optional seat comfort seats filter.
     * 
     * @return value
     */
    public SeatComfortPrefType getSeats() {
        return seats;
    }

    /** 
     * Set the 'Seats' element value. Optional seat comfort seats filter.
     * 
     * @param seats
     */
    public void setSeats(SeatComfortPrefType seats) {
        this.seats = seats;
    }
    /** 
     * The number of alternate days around the travel date to search.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DateFlexibility" minOccurs="0" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:int" use="optional" name="NbrOfDays"/>
     *     &lt;xs:attribute type="xs:int" use="optional" name="Plus"/>
     *     &lt;xs:attribute type="xs:int" use="optional" name="Minus"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Validate"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Tolerance"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DateFlexibility implements Serializable
    {
        private Integer nbrOfDays;
        private Integer plus;
        private Integer minus;
        private Boolean validate;
        private Boolean tolerance;

        /** 
         * Get the 'NbrOfDays' attribute value. Number of alternate dates before and after requested travel date.
         * 
         * @return value
         */
        public Integer getNbrOfDays() {
            return nbrOfDays;
        }

        /** 
         * Set the 'NbrOfDays' attribute value. Number of alternate dates before and after requested travel date.
         * 
         * @param nbrOfDays
         */
        public void setNbrOfDays(Integer nbrOfDays) {
            this.nbrOfDays = nbrOfDays;
        }

        /** 
         * Get the 'Plus' attribute value. Number of alternate dates before requested travel date.
         * 
         * @return value
         */
        public Integer getPlus() {
            return plus;
        }

        /** 
         * Set the 'Plus' attribute value. Number of alternate dates before requested travel date.
         * 
         * @param plus
         */
        public void setPlus(Integer plus) {
            this.plus = plus;
        }

        /** 
         * Get the 'Minus' attribute value. Number of alternate dates after requested travel date.
         * 
         * @return value
         */
        public Integer getMinus() {
            return minus;
        }

        /** 
         * Set the 'Minus' attribute value. Number of alternate dates after requested travel date.
         * 
         * @param minus
         */
        public void setMinus(Integer minus) {
            this.minus = minus;
        }

        /** 
         * Get the 'Validate' attribute value. Flag telling if dates within the specified range should be processed in the validate path.
         * 
         * @return value
         */
        public Boolean getValidate() {
            return validate;
        }

        /** 
         * Set the 'Validate' attribute value. Flag telling if dates within the specified range should be processed in the validate path.
         * 
         * @param validate
         */
        public void setValidate(Boolean validate) {
            this.validate = validate;
        }

        /** 
         * Get the 'Tolerance' attribute value. This attribute enables the date tolerance in Calendar Cross Mode. Shopping will combine X dates (instead of just 1) from this leg with all dates from other leg. X value is derived from rule setting.
         * 
         * @return value
         */
        public Boolean getTolerance() {
            return tolerance;
        }

        /** 
         * Set the 'Tolerance' attribute value. This attribute enables the date tolerance in Calendar Cross Mode. Shopping will combine X dates (instead of just 1) from this leg with all dates from other leg. X value is derived from rule setting.
         * 
         * @param tolerance
         */
        public void setTolerance(Boolean tolerance) {
            this.tolerance = tolerance;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SisterDestinationMileage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AllowBorderCross"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SisterDestinationMileage implements Serializable
    {
        private BigInteger number;
        private Boolean allowBorderCross;

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
         * 
         * @return value
         */
        public Boolean getAllowBorderCross() {
            return allowBorderCross;
        }

        /** 
         * Set the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
         * 
         * @param allowBorderCross
         */
        public void setAllowBorderCross(Boolean allowBorderCross) {
            this.allowBorderCross = allowBorderCross;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SisterOriginMileage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AllowBorderCross"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SisterOriginMileage implements Serializable
    {
        private BigInteger number;
        private Boolean allowBorderCross;

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
         * 
         * @return value
         */
        public Boolean getAllowBorderCross() {
            return allowBorderCross;
        }

        /** 
         * Set the 'AllowBorderCross' attribute value. Allow to return Alternate Cities from other countries.
         * 
         * @param allowBorderCross
         */
        public void setAllowBorderCross(Boolean allowBorderCross) {
            this.allowBorderCross = allowBorderCross;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute use="optional" name="Code">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentType implements Serializable
    {
        private Code code;

        /** 
         * Get the 'Code' attribute value. "Code" can be "ARUNK", "O" for normal, or "X" for connection.
         * 
         * @return value
         */
        public Code getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. "Code" can be "ARUNK", "O" for normal, or "X" for connection.
         * 
         * @param code
         */
        public void setCode(Code code) {
            this.code = code;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="ARUNK"/>
         *     &lt;xs:enumeration value="O"/>
         *     &lt;xs:enumeration value="X"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Code implements Serializable {
            /** 
             * Arrival unknown
             */
            ARUNK, /** 
                    * Normal
                    */
            O, /** 
                * Connection. Collapses this and subsequent OriginDestinationInformation so that they are treated as single leg.
                */
            X
        }
    }
    /** 
     * Maximum time difference/deviation allowed.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateTime" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="PlusMinus"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Plus"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Minus"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AlternateTime implements Serializable
    {
        private BigInteger plusMinus;
        private BigInteger plus;
        private BigInteger minus;

        /** 
         * Get the 'PlusMinus' attribute value. Maximum time difference between actual and desired time.
         * 
         * @return value
         */
        public BigInteger getPlusMinus() {
            return plusMinus;
        }

        /** 
         * Set the 'PlusMinus' attribute value. Maximum time difference between actual and desired time.
         * 
         * @param plusMinus
         */
        public void setPlusMinus(BigInteger plusMinus) {
            this.plusMinus = plusMinus;
        }

        /** 
         * Get the 'Plus' attribute value. Maximum number of hours after desired time.
         * 
         * @return value
         */
        public BigInteger getPlus() {
            return plus;
        }

        /** 
         * Set the 'Plus' attribute value. Maximum number of hours after desired time.
         * 
         * @param plus
         */
        public void setPlus(BigInteger plus) {
            this.plus = plus;
        }

        /** 
         * Get the 'Minus' attribute value. Maximum number of hours before desired time.
         * 
         * @return value
         */
        public BigInteger getMinus() {
            return minus;
        }

        /** 
         * Set the 'Minus' attribute value. Maximum number of hours before desired time.
         * 
         * @param minus
         */
        public void setMinus(BigInteger minus) {
            this.minus = minus;
        }
    }
    /** 
     * Maximum number of options to return.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaxOneWayOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MaxOneWayOptions implements Serializable
    {
        private String value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
    /** 
     * Number of options for requested date.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NumOneWayOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NumOneWayOptions implements Serializable
    {
        private String number;

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public String getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(String number) {
            this.number = number;
        }
    }
    /** 
     * Connection time between segments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionTime" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Min"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Max"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ExcludedConnectionBegin"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ExcludedConnectionEnd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="EnableExcludedConnection"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ConnectionTime implements Serializable
    {
        private BigInteger min;
        private BigInteger max;
        private String excludedConnectionBegin;
        private String excludedConnectionEnd;
        private Boolean enableExcludedConnection;

        /** 
         * Get the 'Min' attribute value.
         * 
         * @return value
         */
        public BigInteger getMin() {
            return min;
        }

        /** 
         * Set the 'Min' attribute value.
         * 
         * @param min
         */
        public void setMin(BigInteger min) {
            this.min = min;
        }

        /** 
         * Get the 'Max' attribute value.
         * 
         * @return value
         */
        public BigInteger getMax() {
            return max;
        }

        /** 
         * Set the 'Max' attribute value.
         * 
         * @param max
         */
        public void setMax(BigInteger max) {
            this.max = max;
        }

        /** 
         * Get the 'ExcludedConnectionBegin' attribute value. Excluded connection time begin in format HHMM
         * 
         * @return value
         */
        public String getExcludedConnectionBegin() {
            return excludedConnectionBegin;
        }

        /** 
         * Set the 'ExcludedConnectionBegin' attribute value. Excluded connection time begin in format HHMM
         * 
         * @param excludedConnectionBegin
         */
        public void setExcludedConnectionBegin(String excludedConnectionBegin) {
            this.excludedConnectionBegin = excludedConnectionBegin;
        }

        /** 
         * Get the 'ExcludedConnectionEnd' attribute value. Excluded connection time end in format HHMM
         * 
         * @return value
         */
        public String getExcludedConnectionEnd() {
            return excludedConnectionEnd;
        }

        /** 
         * Set the 'ExcludedConnectionEnd' attribute value. Excluded connection time end in format HHMM
         * 
         * @param excludedConnectionEnd
         */
        public void setExcludedConnectionEnd(String excludedConnectionEnd) {
            this.excludedConnectionEnd = excludedConnectionEnd;
        }

        /** 
         * Get the 'EnableExcludedConnection' attribute value. Enable excluded connection time (default: true)
         * 
         * @return value
         */
        public Boolean getEnableExcludedConnection() {
            return enableExcludedConnection;
        }

        /** 
         * Set the 'EnableExcludedConnection' attribute value. Enable excluded connection time (default: true)
         * 
         * @param enableExcludedConnection
         */
        public void setEnableExcludedConnection(Boolean enableExcludedConnection) {
            this.enableExcludedConnection = enableExcludedConnection;
        }
    }
    /** 
     * Total travel time settings
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTravelTime" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:unsignedInt" use="optional" name="Min"/>
     *     &lt;xs:attribute type="xs:unsignedInt" use="optional" name="Max"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalTravelTime implements Serializable
    {
        private String min;
        private String max;

        /** 
         * Get the 'Min' attribute value.
         * 
         * @return value
         */
        public String getMin() {
            return min;
        }

        /** 
         * Set the 'Min' attribute value.
         * 
         * @param min
         */
        public void setMin(String min) {
            this.min = min;
        }

        /** 
         * Get the 'Max' attribute value.
         * 
         * @return value
         */
        public String getMax() {
            return max;
        }

        /** 
         * Set the 'Max' attribute value.
         * 
         * @param max
         */
        public void setMax(String max) {
            this.max = max;
        }
    }
}
