
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Origin and Destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformationType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelDateTimeType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="OriginLocation">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="ns:RequestSpecifiedLocationType">
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="AllAirports"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="DestinationLocation">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="ns:RequestSpecifiedLocationType">
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="AllAirports"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:ConnectionType" name="ConnectionLocations" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginDestinationInformationType extends TravelDateTimeType
    implements Serializable
{
    private RequestSpecifiedLocationType originLocationRequestSpecifiedLocationType;
    private Boolean originLocationAllAirports;
    private RequestSpecifiedLocationType destinationLocationRequestSpecifiedLocationType;
    private Boolean destinationLocationAllAirports;
    private ConnectionType connectionLocations;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public RequestSpecifiedLocationType getOriginLocationRequestSpecifiedLocationType() {
        return originLocationRequestSpecifiedLocationType;
    }

    /** 
     * Set the extension value.
     * 
     * @param originLocationRequestSpecifiedLocationType
     */
    public void setOriginLocationRequestSpecifiedLocationType(
            RequestSpecifiedLocationType originLocationRequestSpecifiedLocationType) {
        this.originLocationRequestSpecifiedLocationType = originLocationRequestSpecifiedLocationType;
    }

    /** 
     * Get the 'AllAirports' attribute value. Flag indicating if all cached origin cities are to be processed as origin airports.
     * 
     * @return value
     */
    public Boolean getOriginLocationAllAirports() {
        return originLocationAllAirports;
    }

    /** 
     * Set the 'AllAirports' attribute value. Flag indicating if all cached origin cities are to be processed as origin airports.
     * 
     * @param originLocationAllAirports
     */
    public void setOriginLocationAllAirports(Boolean originLocationAllAirports) {
        this.originLocationAllAirports = originLocationAllAirports;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public RequestSpecifiedLocationType getDestinationLocationRequestSpecifiedLocationType() {
        return destinationLocationRequestSpecifiedLocationType;
    }

    /** 
     * Set the extension value.
     * 
     * @param destinationLocationRequestSpecifiedLocationType
     */
    public void setDestinationLocationRequestSpecifiedLocationType(
            RequestSpecifiedLocationType destinationLocationRequestSpecifiedLocationType) {
        this.destinationLocationRequestSpecifiedLocationType = destinationLocationRequestSpecifiedLocationType;
    }

    /** 
     * Get the 'AllAirports' attribute value. Flag indicating if all cached destination cities are to be processed as destination airports.
     * 
     * @return value
     */
    public Boolean getDestinationLocationAllAirports() {
        return destinationLocationAllAirports;
    }

    /** 
     * Set the 'AllAirports' attribute value. Flag indicating if all cached destination cities are to be processed as destination airports.
     * 
     * @param destinationLocationAllAirports
     */
    public void setDestinationLocationAllAirports(
            Boolean destinationLocationAllAirports) {
        this.destinationLocationAllAirports = destinationLocationAllAirports;
    }

    /** 
     * Get the 'ConnectionLocations' element value. Travel Connection Location - for example, air uses the IATA 3 letter code.
     * 
     * @return value
     */
    public ConnectionType getConnectionLocations() {
        return connectionLocations;
    }

    /** 
     * Set the 'ConnectionLocations' element value. Travel Connection Location - for example, air uses the IATA 3 letter code.
     * 
     * @param connectionLocations
     */
    public void setConnectionLocations(ConnectionType connectionLocations) {
        this.connectionLocations = connectionLocations;
    }
}
