
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 A container for flight segments.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="optional" name="ElapsedTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ArrivalCountry"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DepartureCountry"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginDestinationOptionType implements Serializable
{
    private List<BookFlightSegmentType> flightSegmentList = new ArrayList<BookFlightSegmentType>();
    private Integer elapsedTime;
    private String arrivalCountry;
    private String departureCountry;

    /** 
     * Get the list of 'FlightSegment' element items. 
              A container for necessary data to describe one or more legs of a single flight number.
            
     * 
     * @return list
     */
    public List<BookFlightSegmentType> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items. 
              A container for necessary data to describe one or more legs of a single flight number.
            
     * 
     * @param list
     */
    public void setFlightSegmentList(List<BookFlightSegmentType> list) {
        flightSegmentList = list;
    }

    /** 
     * Get the 'ElapsedTime' attribute value. Elapsed leg trip time in minutes
     * 
     * @return value
     */
    public Integer getElapsedTime() {
        return elapsedTime;
    }

    /** 
     * Set the 'ElapsedTime' attribute value. Elapsed leg trip time in minutes
     * 
     * @param elapsedTime
     */
    public void setElapsedTime(Integer elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    /** 
     * Get the 'ArrivalCountry' attribute value. Arrival country code
     * 
     * @return value
     */
    public String getArrivalCountry() {
        return arrivalCountry;
    }

    /** 
     * Set the 'ArrivalCountry' attribute value. Arrival country code
     * 
     * @param arrivalCountry
     */
    public void setArrivalCountry(String arrivalCountry) {
        this.arrivalCountry = arrivalCountry;
    }

    /** 
     * Get the 'DepartureCountry' attribute value. Departure country code
     * 
     * @return value
     */
    public String getDepartureCountry() {
        return departureCountry;
    }

    /** 
     * Set the 'DepartureCountry' attribute value. Departure country code
     * 
     * @param departureCountry
     */
    public void setDepartureCountry(String departureCountry) {
        this.departureCountry = departureCountry;
    }
}
