
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OutboundOrInbound">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Outbound"/>
 *     &lt;xs:enumeration value="Inbound"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OutboundOrInbound implements Serializable {
    OUTBOUND("Outbound"), INBOUND("Inbound");
    private final String value;

    private OutboundOrInbound(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OutboundOrInbound convert(String value) {
        for (OutboundOrInbound inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
