
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies passenger information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantityPersonalInfoType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PassengerTypeQuantityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:PassengerType" name="Passenger" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:FrequentFlyerPersonNameType" name="PersonName" minOccurs="0" maxOccurs="1"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerTypeQuantityPersonalInfoType
        extends
            PassengerTypeQuantityType implements Serializable
{
    private List<PassengerType> passengerList = new ArrayList<PassengerType>();
    private FrequentFlyerPersonNameType personName;

    /** 
     * Get the list of 'Passenger' element items. Contains passenger Id.
     * 
     * @return list
     */
    public List<PassengerType> getPassengerList() {
        return passengerList;
    }

    /** 
     * Set the list of 'Passenger' element items. Contains passenger Id.
     * 
     * @param list
     */
    public void setPassengerList(List<PassengerType> list) {
        passengerList = list;
    }

    /** 
     * Get the 'PersonName' element value. Contains passenger information for frequent flyer.
     * 
     * @return value
     */
    public FrequentFlyerPersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. Contains passenger information for frequent flyer.
     * 
     * @param personName
     */
    public void setPersonName(FrequentFlyerPersonNameType personName) {
        this.personName = personName;
    }
}
