
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Element by means of which user can specify fixed price of a given leg or itinerary (depending on the context)
 to be preserved across subsequent calls to Context Shopping.
 Currency of fixed amounts is assumed to be the same as the currency in which current transaction will be priced.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceAdjustmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BaseFare" minOccurs="0">
 *       &lt;!-- Reference to inner class BaseFare -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="EquivFare" minOccurs="0">
 *       &lt;!-- Reference to inner class EquivFare -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TotalTax" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalTax -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TotalFare" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalFare -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceAdjustmentType implements Serializable
{
    private BaseFare baseFare;
    private EquivFare equivFare;
    private TotalTax totalTax;
    private TotalFare totalFare;

    /** 
     * Get the 'BaseFare' element value.
     * 
     * @return value
     */
    public BaseFare getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value.
     * 
     * @param baseFare
     */
    public void setBaseFare(BaseFare baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivFare' element value.
     * 
     * @return value
     */
    public EquivFare getEquivFare() {
        return equivFare;
    }

    /** 
     * Set the 'EquivFare' element value.
     * 
     * @param equivFare
     */
    public void setEquivFare(EquivFare equivFare) {
        this.equivFare = equivFare;
    }

    /** 
     * Get the 'TotalTax' element value.
     * 
     * @return value
     */
    public TotalTax getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value.
     * 
     * @param totalTax
     */
    public void setTotalTax(TotalTax totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value.
     * 
     * @return value
     */
    public TotalFare getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value.
     * 
     * @param totalFare
     */
    public void setTotalFare(TotalFare totalFare) {
        this.totalFare = totalFare;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaseFare implements Serializable
    {
        private BigDecimal amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
     *     &lt;xs:attribute type="xs:decimal" use="optional" name="EffectivePriceDeviation"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EquivFare implements Serializable
    {
        private BigDecimal amount;
        private BigDecimal effectivePriceDeviation;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'EffectivePriceDeviation' attribute value.
         * 
         * @return value
         */
        public BigDecimal getEffectivePriceDeviation() {
            return effectivePriceDeviation;
        }

        /** 
         * Set the 'EffectivePriceDeviation' attribute value.
         * 
         * @param effectivePriceDeviation
         */
        public void setEffectivePriceDeviation(
                BigDecimal effectivePriceDeviation) {
            this.effectivePriceDeviation = effectivePriceDeviation;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalTax implements Serializable
    {
        private BigDecimal amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalFare implements Serializable
    {
        private BigDecimal amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }
}
