
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Attribute collection used to describe a price request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestAttributes">
 *   &lt;xs:attribute type="xs:string" use="optional" name="FareQualifier"/>
 *   &lt;xs:attribute type="xs:boolean" name="NegotiatedFaresOnly"/>
 *   &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
 *   &lt;xs:attribute type="ns:RequestPricingSourceType" use="optional" name="PricingSource"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Reprice"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ProcessThruFaresOnly"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="PurchaseDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurchaseTime"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NetFaresUsed"/>
 *   &lt;xs:attribute type="ns:BypassAdvancePurchaseType" use="optional" name="BypassAdvancePurchase"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PriceRequestAttributes implements Serializable
{
    private String fareQualifier;
    private Boolean negotiatedFaresOnly;
    private String currencyCode;
    private RequestPricingSourceType pricingSource;
    private Boolean reprice;
    private Boolean processThruFaresOnly;
    private Date purchaseDate;
    private String purchaseTime;
    private Boolean netFaresUsed;
    private BypassAdvancePurchaseType bypassAdvancePurchase;

    /** 
     * Get the 'FareQualifier' attribute value. Fare Type is specific to a specific fare and this is a request for a set of fares based on these qualifiers.
     * 
     * @return value
     */
    public String getFareQualifier() {
        return fareQualifier;
    }

    /** 
     * Set the 'FareQualifier' attribute value. Fare Type is specific to a specific fare and this is a request for a set of fares based on these qualifiers.
     * 
     * @param fareQualifier
     */
    public void setFareQualifier(String fareQualifier) {
        this.fareQualifier = fareQualifier;
    }

    /** 
     * Get the 'NegotiatedFaresOnly' attribute value. If set to true then returned fares need to match requested AcccountCode/CorpID on all fare components
     * 
     * @return value
     */
    public Boolean getNegotiatedFaresOnly() {
        return negotiatedFaresOnly;
    }

    /** 
     * Set the 'NegotiatedFaresOnly' attribute value. If set to true then returned fares need to match requested AcccountCode/CorpID on all fare components
     * 
     * @param negotiatedFaresOnly
     */
    public void setNegotiatedFaresOnly(Boolean negotiatedFaresOnly) {
        this.negotiatedFaresOnly = negotiatedFaresOnly;
    }

    /** 
     * Get the 'CurrencyCode' attribute value. Type of funds preferred for reviewing monetary values, in ISO 4217 codes.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value. Type of funds preferred for reviewing monetary values, in ISO 4217 codes.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'PricingSource' attribute value. It can be used to indicate whether the fare is public or private.
     * 
     * @return value
     */
    public RequestPricingSourceType getPricingSource() {
        return pricingSource;
    }

    /** 
     * Set the 'PricingSource' attribute value. It can be used to indicate whether the fare is public or private.
     * 
     * @param pricingSource
     */
    public void setPricingSource(RequestPricingSourceType pricingSource) {
        this.pricingSource = pricingSource;
    }

    /** 
     * Get the 'Reprice' attribute value.
     * 
     * @return value
     */
    public Boolean getReprice() {
        return reprice;
    }

    /** 
     * Set the 'Reprice' attribute value.
     * 
     * @param reprice
     */
    public void setReprice(Boolean reprice) {
        this.reprice = reprice;
    }

    /** 
     * Get the 'ProcessThruFaresOnly' attribute value. Activates processing of thru fares only.
     * 
     * @return value
     */
    public Boolean getProcessThruFaresOnly() {
        return processThruFaresOnly;
    }

    /** 
     * Set the 'ProcessThruFaresOnly' attribute value. Activates processing of thru fares only.
     * 
     * @param processThruFaresOnly
     */
    public void setProcessThruFaresOnly(Boolean processThruFaresOnly) {
        this.processThruFaresOnly = processThruFaresOnly;
    }

    /** 
     * Get the 'PurchaseDate' attribute value. Specify purchase date. Fares returned will be based on the purchase date.
     * 
     * @return value
     */
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    /** 
     * Set the 'PurchaseDate' attribute value. Specify purchase date. Fares returned will be based on the purchase date.
     * 
     * @param purchaseDate
     */
    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    /** 
     * Get the 'PurchaseTime' attribute value. Specify purchase time. Fares returned will be based on the purchase time.
     * 
     * @return value
     */
    public String getPurchaseTime() {
        return purchaseTime;
    }

    /** 
     * Set the 'PurchaseTime' attribute value. Specify purchase time. Fares returned will be based on the purchase time.
     * 
     * @param purchaseTime
     */
    public void setPurchaseTime(String purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    /** 
     * Get the 'NetFaresUsed' attribute value. Set to true when exchange ticket uses net fare.
     * 
     * @return value
     */
    public Boolean getNetFaresUsed() {
        return netFaresUsed;
    }

    /** 
     * Set the 'NetFaresUsed' attribute value. Set to true when exchange ticket uses net fare.
     * 
     * @param netFaresUsed
     */
    public void setNetFaresUsed(Boolean netFaresUsed) {
        this.netFaresUsed = netFaresUsed;
    }

    /** 
     * Get the 'BypassAdvancePurchase' attribute value. Controls advance purchase validation logic for repricing. Values 'T'/'F' can be used by AS, for TN the only valid option is 'N'.
     * 
     * @return value
     */
    public BypassAdvancePurchaseType getBypassAdvancePurchase() {
        return bypassAdvancePurchase;
    }

    /** 
     * Set the 'BypassAdvancePurchase' attribute value. Controls advance purchase validation logic for repricing. Values 'T'/'F' can be used by AS, for TN the only valid option is 'N'.
     * 
     * @param bypassAdvancePurchase
     */
    public void setBypassAdvancePurchase(
            BypassAdvancePurchaseType bypassAdvancePurchase) {
        this.bypassAdvancePurchase = bypassAdvancePurchase;
    }
}
