
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Itinerary with pricing information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AirItineraryType" name="AirItinerary" minOccurs="0"/>
 *     &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class AirItineraryPricingInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:FreeTextType" name="Notes" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:TicketingInfoRS_Type" name="TicketingInfo" minOccurs="0"/>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isFromCustomPath"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="SequenceNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OriginDestinationRPH"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CampaignID"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AlternateAirport"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="MultipleTickets"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SabreConnectLite"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedItineraryType implements Serializable
{
    private AirItineraryType airItinerary;
    private List<AirItineraryPricingInfo> airItineraryPricingInfoList = new ArrayList<AirItineraryPricingInfo>();
    private List<FreeTextType> noteList = new ArrayList<FreeTextType>();
    private TicketingInfoRSType ticketingInfo;
    private TPAExtensions TPAExtensions1;
    private Boolean isFromCustomPath;
    private String sequenceNumber;
    private String originDestinationRPH;
    private String campaignID;
    private Boolean alternateAirport;
    private Boolean multipleTickets;
    private Boolean sabreConnectLite;

    /** 
     * Get the 'AirItinerary' element value. Specifies the origin and destination of the traveler.
     * 
     * @return value
     */
    public AirItineraryType getAirItinerary() {
        return airItinerary;
    }

    /** 
     * Set the 'AirItinerary' element value. Specifies the origin and destination of the traveler.
     * 
     * @param airItinerary
     */
    public void setAirItinerary(AirItineraryType airItinerary) {
        this.airItinerary = airItinerary;
    }

    /** 
     * Get the list of 'AirItineraryPricingInfo' element items.
     * 
     * @return list
     */
    public List<AirItineraryPricingInfo> getAirItineraryPricingInfoList() {
        return airItineraryPricingInfoList;
    }

    /** 
     * Set the list of 'AirItineraryPricingInfo' element items.
     * 
     * @param list
     */
    public void setAirItineraryPricingInfoList(
            List<AirItineraryPricingInfo> list) {
        airItineraryPricingInfoList = list;
    }

    /** 
     * Get the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
     * 
     * @return list
     */
    public List<FreeTextType> getNoteList() {
        return noteList;
    }

    /** 
     * Set the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
     * 
     * @param list
     */
    public void setNoteList(List<FreeTextType> list) {
        noteList = list;
    }

    /** 
     * Get the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @return value
     */
    public TicketingInfoRSType getTicketingInfo() {
        return ticketingInfo;
    }

    /** 
     * Set the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @param ticketingInfo
     */
    public void setTicketingInfo(TicketingInfoRSType ticketingInfo) {
        this.ticketingInfo = ticketingInfo;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'isFromCustomPath' attribute value. Indicates if itin come from custom carrier/routing path.
     * 
     * @return value
     */
    public Boolean getIsFromCustomPath() {
        return isFromCustomPath;
    }

    /** 
     * Set the 'isFromCustomPath' attribute value. Indicates if itin come from custom carrier/routing path.
     * 
     * @param isFromCustomPath
     */
    public void setIsFromCustomPath(Boolean isFromCustomPath) {
        this.isFromCustomPath = isFromCustomPath;
    }

    /** 
     * Get the 'SequenceNumber' attribute value. Assigns a number to priced itineraries.
     * 
     * @return value
     */
    public String getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'SequenceNumber' attribute value. Assigns a number to priced itineraries.
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /** 
     * Get the 'OriginDestinationRPH' attribute value. When a PricedItinerary element contains flights and pricing information for a single OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that OriginDestinationPair from the RQ. When the PricedItinerary contains flights and pricing information for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be included.
     * 
     * @return value
     */
    public String getOriginDestinationRPH() {
        return originDestinationRPH;
    }

    /** 
     * Set the 'OriginDestinationRPH' attribute value. When a PricedItinerary element contains flights and pricing information for a single OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that OriginDestinationPair from the RQ. When the PricedItinerary contains flights and pricing information for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be included.
     * 
     * @param originDestinationRPH
     */
    public void setOriginDestinationRPH(String originDestinationRPH) {
        this.originDestinationRPH = originDestinationRPH;
    }

    /** 
     * Get the 'CampaignID' attribute value. Program/campaign ID, which the downline clients need to determine which marketing text to display.
     * 
     * @return value
     */
    public String getCampaignID() {
        return campaignID;
    }

    /** 
     * Set the 'CampaignID' attribute value. Program/campaign ID, which the downline clients need to determine which marketing text to display.
     * 
     * @param campaignID
     */
    public void setCampaignID(String campaignID) {
        this.campaignID = campaignID;
    }

    /** 
     * Get the 'AlternateAirport' attribute value. Alternate airport itineraries indicator
     * 
     * @return value
     */
    public Boolean getAlternateAirport() {
        return alternateAirport;
    }

    /** 
     * Set the 'AlternateAirport' attribute value. Alternate airport itineraries indicator
     * 
     * @param alternateAirport
     */
    public void setAlternateAirport(Boolean alternateAirport) {
        this.alternateAirport = alternateAirport;
    }

    /** 
     * Get the 'MultipleTickets' attribute value. Indicates that itinerary should be sold on multiple separate tickets
     * 
     * @return value
     */
    public Boolean getMultipleTickets() {
        return multipleTickets;
    }

    /** 
     * Set the 'MultipleTickets' attribute value. Indicates that itinerary should be sold on multiple separate tickets
     * 
     * @param multipleTickets
     */
    public void setMultipleTickets(Boolean multipleTickets) {
        this.multipleTickets = multipleTickets;
    }

    /** 
     * Get the 'SabreConnectLite' attribute value. Indicates that itinerary is handled by SCL carrier
     * 
     * @return value
     */
    public Boolean getSabreConnectLite() {
        return sabreConnectLite;
    }

    /** 
     * Set the 'SabreConnectLite' attribute value. Indicates that itinerary is handled by SCL carrier
     * 
     * @param sabreConnectLite
     */
    public void setSabreConnectLite(Boolean sabreConnectLite) {
        this.sabreConnectLite = sabreConnectLite;
    }
    /** 
     * Pricing Information for an Air Itinerary.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AirItineraryPricingInfoType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:TicketsPricingType" name="Tickets" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirItineraryPricingInfo
            extends
                AirItineraryPricingInfoType implements Serializable
    {
        private TicketsPricingType tickets;

        /** 
         * Get the 'Tickets' element value. Pricing information for multiple separate tickets
         * 
         * @return value
         */
        public TicketsPricingType getTickets() {
            return tickets;
        }

        /** 
         * Set the 'Tickets' element value. Pricing information for multiple separate tickets
         * 
         * @param tickets
         */
        public void setTickets(TicketsPricingType tickets) {
            this.tickets = tickets;
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AdditionalFares" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AdditionalFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Ops" minOccurs="0">
     *         &lt;!-- Reference to inner class Ops -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItinSource" minOccurs="0">
     *         &lt;!-- Reference to inner class ItinSource -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ValueBucket" minOccurs="0">
     *         &lt;!-- Reference to inner class ValueBucket -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class ValidatingCarrier -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:UnflownPriceType" name="UnflownPrice" minOccurs="0"/>
     *       &lt;xs:element name="DiversitySwapper" minOccurs="0">
     *         &lt;!-- Reference to inner class DiversitySwapper -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Failed" minOccurs="0">
     *         &lt;!-- Reference to inner class Failed -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private List<AdditionalFares> additionalFareList = new ArrayList<AdditionalFares>();
        private Ops ops;
        private ItinSource itinSource;
        private ValueBucket valueBucket;
        private ValidatingCarrier validatingCarrier;
        private UnflownPriceType unflownPrice;
        private DiversitySwapper diversitySwapper;
        private Failed failed;

        /** 
         * Get the list of 'AdditionalFares' element items.
         * 
         * @return list
         */
        public List<AdditionalFares> getAdditionalFareList() {
            return additionalFareList;
        }

        /** 
         * Set the list of 'AdditionalFares' element items.
         * 
         * @param list
         */
        public void setAdditionalFareList(List<AdditionalFares> list) {
            additionalFareList = list;
        }

        /** 
         * Get the 'Ops' element value.
         * 
         * @return value
         */
        public Ops getOps() {
            return ops;
        }

        /** 
         * Set the 'Ops' element value.
         * 
         * @param ops
         */
        public void setOps(Ops ops) {
            this.ops = ops;
        }

        /** 
         * Get the 'ItinSource' element value.
         * 
         * @return value
         */
        public ItinSource getItinSource() {
            return itinSource;
        }

        /** 
         * Set the 'ItinSource' element value.
         * 
         * @param itinSource
         */
        public void setItinSource(ItinSource itinSource) {
            this.itinSource = itinSource;
        }

        /** 
         * Get the 'ValueBucket' element value.
         * 
         * @return value
         */
        public ValueBucket getValueBucket() {
            return valueBucket;
        }

        /** 
         * Set the 'ValueBucket' element value.
         * 
         * @param valueBucket
         */
        public void setValueBucket(ValueBucket valueBucket) {
            this.valueBucket = valueBucket;
        }

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public ValidatingCarrier getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }

        /** 
         * Get the 'UnflownPrice' element value. Sum of AirItineraryPricingInfo/TPA_Extensions/UnflownPrice
         * 
         * @return value
         */
        public UnflownPriceType getUnflownPrice() {
            return unflownPrice;
        }

        /** 
         * Set the 'UnflownPrice' element value. Sum of AirItineraryPricingInfo/TPA_Extensions/UnflownPrice
         * 
         * @param unflownPrice
         */
        public void setUnflownPrice(UnflownPriceType unflownPrice) {
            this.unflownPrice = unflownPrice;
        }

        /** 
         * Get the 'DiversitySwapper' element value.
         * 
         * @return value
         */
        public DiversitySwapper getDiversitySwapper() {
            return diversitySwapper;
        }

        /** 
         * Set the 'DiversitySwapper' element value.
         * 
         * @param diversitySwapper
         */
        public void setDiversitySwapper(DiversitySwapper diversitySwapper) {
            this.diversitySwapper = diversitySwapper;
        }

        /** 
         * Get the 'Failed' element value.
         * 
         * @return value
         */
        public Failed getFailed() {
            return failed;
        }

        /** 
         * Set the 'Failed' element value.
         * 
         * @param failed
         */
        public void setFailed(Failed failed) {
            this.failed = failed;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalFares" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class AirItineraryPricingInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:FreeTextType" name="Notes" minOccurs="0" maxOccurs="5"/>
         *       &lt;xs:element type="ns:TicketingInfoRS_Type" name="TicketingInfo" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="MultipleTickets"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalFares implements Serializable
        {
            private AirItineraryPricingInfo airItineraryPricingInfo;
            private List<FreeTextType> noteList = new ArrayList<FreeTextType>();
            private TicketingInfoRSType ticketingInfo;
            private Boolean multipleTickets;

            /** 
             * Get the 'AirItineraryPricingInfo' element value.
             * 
             * @return value
             */
            public AirItineraryPricingInfo getAirItineraryPricingInfo() {
                return airItineraryPricingInfo;
            }

            /** 
             * Set the 'AirItineraryPricingInfo' element value.
             * 
             * @param airItineraryPricingInfo
             */
            public void setAirItineraryPricingInfo(
                    AirItineraryPricingInfo airItineraryPricingInfo) {
                this.airItineraryPricingInfo = airItineraryPricingInfo;
            }

            /** 
             * Get the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
             * 
             * @return list
             */
            public List<FreeTextType> getNoteList() {
                return noteList;
            }

            /** 
             * Set the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
             * 
             * @param list
             */
            public void setNoteList(List<FreeTextType> list) {
                noteList = list;
            }

            /** 
             * Get the 'TicketingInfo' element value. Information about ticketing (including eTicketNumber).
             * 
             * @return value
             */
            public TicketingInfoRSType getTicketingInfo() {
                return ticketingInfo;
            }

            /** 
             * Set the 'TicketingInfo' element value. Information about ticketing (including eTicketNumber).
             * 
             * @param ticketingInfo
             */
            public void setTicketingInfo(TicketingInfoRSType ticketingInfo) {
                this.ticketingInfo = ticketingInfo;
            }

            /** 
             * Get the 'MultipleTickets' attribute value. Indicates that itinerary should be sold on multiple separate tickets
             * 
             * @return value
             */
            public Boolean getMultipleTickets() {
                return multipleTickets;
            }

            /** 
             * Set the 'MultipleTickets' attribute value. Indicates that itinerary should be sold on multiple separate tickets
             * 
             * @param multipleTickets
             */
            public void setMultipleTickets(Boolean multipleTickets) {
                this.multipleTickets = multipleTickets;
            }
            /** 
             * Pricing Information for an Air Itinerary.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:AirItineraryPricingInfoType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="ns:TicketsPricingType" name="Tickets" minOccurs="0"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirItineraryPricingInfo
                    extends
                        AirItineraryPricingInfoType implements Serializable
            {
                private TicketsPricingType tickets;

                /** 
                 * Get the 'Tickets' element value. Pricing information for multiple separate tickets
                 * 
                 * @return value
                 */
                public TicketsPricingType getTickets() {
                    return tickets;
                }

                /** 
                 * Set the 'Tickets' element value. Pricing information for multiple separate tickets
                 * 
                 * @param tickets
                 */
                public void setTickets(TicketsPricingType tickets) {
                    this.tickets = tickets;
                }
            }
        }
        /** 
         * Populated if an Ops rule has been hit.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ops" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FareTypes" minOccurs="0">
         *         &lt;!-- Reference to inner class FareTypes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" use="required" name="ActionCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Ops implements Serializable
        {
            private FareTypes fareTypes;
            private BigInteger actionCode;

            /** 
             * Get the 'FareTypes' element value.
             * 
             * @return value
             */
            public FareTypes getFareTypes() {
                return fareTypes;
            }

            /** 
             * Set the 'FareTypes' element value.
             * 
             * @param fareTypes
             */
            public void setFareTypes(FareTypes fareTypes) {
                this.fareTypes = fareTypes;
            }

            /** 
             * Get the 'ActionCode' attribute value. Corresponds to data in the Ops rule (action target: Ops Action). The numeric id corresponds to an action performed by Travelocity.
             * 
             * @return value
             */
            public BigInteger getActionCode() {
                return actionCode;
            }

            /** 
             * Set the 'ActionCode' attribute value. Corresponds to data in the Ops rule (action target: Ops Action). The numeric id corresponds to an action performed by Travelocity.
             * 
             * @param actionCode
             */
            public void setActionCode(BigInteger actionCode) {
                this.actionCode = actionCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareTypes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FareType" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FareType -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareTypes implements Serializable
            {
                private List<FareType> fareTypeList = new ArrayList<FareType>();

                /** 
                 * Get the list of 'FareType' element items.
                 * 
                 * @return list
                 */
                public List<FareType> getFareTypeList() {
                    return fareTypeList;
                }

                /** 
                 * Set the list of 'FareType' element items.
                 * 
                 * @param list
                 */
                public void setFareTypeList(List<FareType> list) {
                    fareTypeList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareType implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
        }
        /** 
         * The source of the itinerary
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinSource" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Source"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItinSource implements Serializable
        {
            private String source;

            /** 
             * Get the 'Source' attribute value. The name of the source.
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'Source' attribute value. The name of the source.
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
        }
        /** 
         * Additional information for Value Bucket sorting
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueBucket" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:double" name="PriceTimeValueRank"/>
         *     &lt;xs:attribute type="xs:integer" name="ValueBucketNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValueBucket implements Serializable
        {
            private Double priceTimeValueRank;
            private BigInteger valueBucketNumber;

            /** 
             * Get the 'PriceTimeValueRank' attribute value. Price Time Value rank.
             * 
             * @return value
             */
            public Double getPriceTimeValueRank() {
                return priceTimeValueRank;
            }

            /** 
             * Set the 'PriceTimeValueRank' attribute value. Price Time Value rank.
             * 
             * @param priceTimeValueRank
             */
            public void setPriceTimeValueRank(Double priceTimeValueRank) {
                this.priceTimeValueRank = priceTimeValueRank;
            }

            /** 
             * Get the 'ValueBucketNumber' attribute value. Price Time Value Bucket number.
             * 
             * @return value
             */
            public BigInteger getValueBucketNumber() {
                return valueBucketNumber;
            }

            /** 
             * Set the 'ValueBucketNumber' attribute value. Price Time Value Bucket number.
             * 
             * @param valueBucketNumber
             */
            public void setValueBucketNumber(BigInteger valueBucketNumber) {
                this.valueBucketNumber = valueBucketNumber;
            }
        }
        /** 
         * Issuing airline whose numeric airline code is reflected in the electronic transaction for the flight/value coupon(s).The Validating Carrier shall be the controlling and authorising entity for Electronic Ticketing transactions..
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiversitySwapper" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="WeighedPriceAmount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DiversitySwapper implements Serializable
        {
            private Float weighedPriceAmount;

            /** 
             * Get the 'WeighedPriceAmount' attribute value. (Penalty * price / 10) -- by which itins are sorted in Diversity Swapper
             * 
             * @return value
             */
            public Float getWeighedPriceAmount() {
                return weighedPriceAmount;
            }

            /** 
             * Set the 'WeighedPriceAmount' attribute value. (Penalty * price / 10) -- by which itins are sorted in Diversity Swapper
             * 
             * @param weighedPriceAmount
             */
            public void setWeighedPriceAmount(Float weighedPriceAmount) {
                this.weighedPriceAmount = weighedPriceAmount;
            }
        }
        /** 
         * Information on problems that occurred while processing this itinerary.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Failed" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="MinimumConnectTime"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Failed implements Serializable
        {
            private Boolean minimumConnectTime;

            /** 
             * Get the 'MinimumConnectTime' attribute value. Indicates that the itinerary does not fullfill the Minimum Connect Time requirement. It cannot be sold.
             * 
             * @return value
             */
            public Boolean getMinimumConnectTime() {
                return minimumConnectTime;
            }

            /** 
             * Set the 'MinimumConnectTime' attribute value. Indicates that the itinerary does not fullfill the Minimum Connect Time requirement. It cannot be sold.
             * 
             * @param minimumConnectTime
             */
            public void setMinimumConnectTime(Boolean minimumConnectTime) {
                this.minimumConnectTime = minimumConnectTime;
            }
        }
    }
}
