
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Definition of a routing
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoutingDefinitionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RoutingLegType" name="RoutingLeg" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AddWildcards"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RoutingDefinitionType implements Serializable
{
    private List<RoutingLegType> routingLegList = new ArrayList<RoutingLegType>();
    private Boolean addWildcards;

    /** 
     * Get the list of 'RoutingLeg' element items.
     * 
     * @return list
     */
    public List<RoutingLegType> getRoutingLegList() {
        return routingLegList;
    }

    /** 
     * Set the list of 'RoutingLeg' element items.
     * 
     * @param list
     */
    public void setRoutingLegList(List<RoutingLegType> list) {
        routingLegList = list;
    }

    /** 
     * Get the 'AddWildcards' attribute value. If true, wildcards will be automatically inserted between each two leg (RoutingLeg) elements. Will be set to 'false' if not present.
     * 
     * @return value
     */
    public Boolean getAddWildcards() {
        return addWildcards;
    }

    /** 
     * Set the 'AddWildcards' attribute value. If true, wildcards will be automatically inserted between each two leg (RoutingLeg) elements. Will be set to 'false' if not present.
     * 
     * @param addWildcards
     */
    public void setAddWildcards(Boolean addWildcards) {
        this.addWildcards = addWildcards;
    }
}
