
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Contains summary fare rule information as well as detailed Rule Information for Fare Basis Codes.  Information may be actual rules data or the results returned from a rules-based inquiry.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ResTicketingRules" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:AdvResTicketingType" name="AdvResTicketing" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:StayRestrictionsType" name="LengthOfStayRules" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RuleInfoType implements Serializable
{
    private AdvResTicketingType resTicketingRules;
    private StayRestrictionsType lengthOfStayRules;

    /** 
     * Get the 'AdvResTicketing' element value. Container for holding rules regarding advance reservation or ticketing restrictions. 
     * 
     * @return value
     */
    public AdvResTicketingType getResTicketingRules() {
        return resTicketingRules;
    }

    /** 
     * Set the 'AdvResTicketing' element value. Container for holding rules regarding advance reservation or ticketing restrictions. 
     * 
     * @param resTicketingRules
     */
    public void setResTicketingRules(AdvResTicketingType resTicketingRules) {
        this.resTicketingRules = resTicketingRules;
    }

    /** 
     * Get the 'LengthOfStayRules' element value. Rules providing minimum or maximum stay restrictions.
     * 
     * @return value
     */
    public StayRestrictionsType getLengthOfStayRules() {
        return lengthOfStayRules;
    }

    /** 
     * Set the 'LengthOfStayRules' element value. Rules providing minimum or maximum stay restrictions.
     * 
     * @param lengthOfStayRules
     */
    public void setLengthOfStayRules(StayRestrictionsType lengthOfStayRules) {
        this.lengthOfStayRules = lengthOfStayRules;
    }
}
