
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 This describes properties af seats in a given cabin. These alements are later referenced from FlightAmenities

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAmenityType">
 *   &lt;xs:attribute type="xs:integer" use="required" name="Id"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Pitch"/>
 *   &lt;xs:attribute use="optional" name="Type">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatAmenityType implements Serializable
{
    private BigInteger id;
    private String pitch;
    private Type type;

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public BigInteger getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(BigInteger id) {
        this.id = id;
    }

    /** 
     * Get the 'Pitch' attribute value.
     * 
     * @return value
     */
    public String getPitch() {
        return pitch;
    }

    /** 
     * Set the 'Pitch' attribute value.
     * 
     * @param pitch
     */
    public void setPitch(String pitch) {
        this.pitch = pitch;
    }

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="middle seat free"/>
     *     &lt;xs:enumeration value="standard legroom"/>
     *     &lt;xs:enumeration value="below average legroom"/>
     *     &lt;xs:enumeration value="above average legroom"/>
     *     &lt;xs:enumeration value="skycouch"/>
     *     &lt;xs:enumeration value="recliner seat"/>
     *     &lt;xs:enumeration value="full flat seat"/>
     *     &lt;xs:enumeration value="full flat pod"/>
     *     &lt;xs:enumeration value="private suite"/>
     *     &lt;xs:enumeration value="angle flat seat"/>
     *     &lt;xs:enumeration value="cradle recliner"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Type implements Serializable {
        MIDDLESEATFREE("middle seat free"), STANDARDLEGROOM("standard legroom"), BELOWAVERAGELEGROOM(
                "below average legroom"), ABOVEAVERAGELEGROOM(
                "above average legroom"), SKYCOUCH("skycouch"), RECLINERSEAT(
                "recliner seat"), FULLFLATSEAT("full flat seat"), FULLFLATPOD(
                "full flat pod"), PRIVATESUITE("private suite"), ANGLEFLATSEAT(
                "angle flat seat"), CRADLERECLINER("cradle recliner");
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Type convert(String value) {
            for (Type inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
