
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * To specify informations about stopover
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopoverType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DepartureDateTime" minOccurs="0"/>
 *     &lt;xs:element name="Stay" minOccurs="0">
 *       &lt;!-- Reference to inner class Stay -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="DepartureWindow" minOccurs="0"/>
 *     &lt;xs:element name="StopoverPoint">
 *       &lt;xs:complexType>
 *         &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="LocationType"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StopoverType implements Serializable
{
    private String departureDateTime;
    private Stay stay;
    private String departureWindow;
    private String stopoverPointLocationCode;
    private String stopoverPointLocationType;

    /** 
     * Get the 'DepartureDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @return value
     */
    public String getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(String departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'Stay' element value.
     * 
     * @return value
     */
    public Stay getStay() {
        return stay;
    }

    /** 
     * Set the 'Stay' element value.
     * 
     * @param stay
     */
    public void setStay(Stay stay) {
        this.stay = stay;
    }

    /** 
     * Get the 'DepartureWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @return value
     */
    public String getDepartureWindow() {
        return departureWindow;
    }

    /** 
     * Set the 'DepartureWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @param departureWindow
     */
    public void setDepartureWindow(String departureWindow) {
        this.departureWindow = departureWindow;
    }

    /** 
     * Get the 'LocationCode' attribute value.
     * 
     * @return value
     */
    public String getStopoverPointLocationCode() {
        return stopoverPointLocationCode;
    }

    /** 
     * Set the 'LocationCode' attribute value.
     * 
     * @param stopoverPointLocationCode
     */
    public void setStopoverPointLocationCode(String stopoverPointLocationCode) {
        this.stopoverPointLocationCode = stopoverPointLocationCode;
    }

    /** 
     * Get the 'LocationType' attribute value.
     * 
     * @return value
     */
    public String getStopoverPointLocationType() {
        return stopoverPointLocationType;
    }

    /** 
     * Set the 'LocationType' attribute value.
     * 
     * @param stopoverPointLocationType
     */
    public void setStopoverPointLocationType(String stopoverPointLocationType) {
        this.stopoverPointLocationType = stopoverPointLocationType;
    }
    /** 
     * Information related to the stay at the stopover point
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Stay" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Nights"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="MinHours"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxHours"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Stay implements Serializable
    {
        private BigInteger nights;
        private BigInteger minHours;
        private String maxHours;

        /** 
         * Get the 'Nights' attribute value. Number of nights spent at the stopover point
         * 
         * @return value
         */
        public BigInteger getNights() {
            return nights;
        }

        /** 
         * Set the 'Nights' attribute value. Number of nights spent at the stopover point
         * 
         * @param nights
         */
        public void setNights(BigInteger nights) {
            this.nights = nights;
        }

        /** 
         * Get the 'MinHours' attribute value. Minimum stay in hours at the stopover point
         * 
         * @return value
         */
        public BigInteger getMinHours() {
            return minHours;
        }

        /** 
         * Set the 'MinHours' attribute value. Minimum stay in hours at the stopover point
         * 
         * @param minHours
         */
        public void setMinHours(BigInteger minHours) {
            this.minHours = minHours;
        }

        /** 
         * Get the 'MaxHours' attribute value. Maximum stay in hours at the stopover point
         * 
         * @return value
         */
        public String getMaxHours() {
            return maxHours;
        }

        /** 
         * Set the 'MaxHours' attribute value. Maximum stay in hours at the stopover point
         * 
         * @param maxHours
         */
        public void setMaxHours(String maxHours) {
            this.maxHours = maxHours;
        }
    }
}
