
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Pricing Information for Single Ticket
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketPricingType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OriginDestinationOptions">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="OriginDestinationOption" maxOccurs="99">
 *             &lt;!-- Reference to inner class OriginDestinationOption -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AirItineraryPricingInfoType" name="AirItineraryPricingInfo"/>
 *     &lt;xs:element type="ns:FreeTextType" name="Notes" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:TicketingInfoRS_Type" name="TicketingInfo" minOccurs="0"/>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="required" name="Number"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketPricingType implements Serializable
{
    private List<OriginDestinationOption> originDestinationOptionList = new ArrayList<OriginDestinationOption>();
    private AirItineraryPricingInfoType airItineraryPricingInfo;
    private List<FreeTextType> noteList = new ArrayList<FreeTextType>();
    private TicketingInfoRSType ticketingInfo;
    private TPAExtensions TPAExtensions1;
    private int number;

    /** 
     * Get the list of 'OriginDestinationOption' element items.
     * 
     * @return list
     */
    public List<OriginDestinationOption> getOriginDestinationOptionList() {
        return originDestinationOptionList;
    }

    /** 
     * Set the list of 'OriginDestinationOption' element items.
     * 
     * @param list
     */
    public void setOriginDestinationOptionList(
            List<OriginDestinationOption> list) {
        originDestinationOptionList = list;
    }

    /** 
     * Get the 'AirItineraryPricingInfo' element value. Pricing Information for a Ticket.
     * 
     * @return value
     */
    public AirItineraryPricingInfoType getAirItineraryPricingInfo() {
        return airItineraryPricingInfo;
    }

    /** 
     * Set the 'AirItineraryPricingInfo' element value. Pricing Information for a Ticket.
     * 
     * @param airItineraryPricingInfo
     */
    public void setAirItineraryPricingInfo(
            AirItineraryPricingInfoType airItineraryPricingInfo) {
        this.airItineraryPricingInfo = airItineraryPricingInfo;
    }

    /** 
     * Get the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
     * 
     * @return list
     */
    public List<FreeTextType> getNoteList() {
        return noteList;
    }

    /** 
     * Set the list of 'Notes' element items. Provides for free form descriptive information for the priced itinerary.
     * 
     * @param list
     */
    public void setNoteList(List<FreeTextType> list) {
        noteList = list;
    }

    /** 
     * Get the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @return value
     */
    public TicketingInfoRSType getTicketingInfo() {
        return ticketingInfo;
    }

    /** 
     * Set the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @param ticketingInfo
     */
    public void setTicketingInfo(TicketingInfoRSType ticketingInfo) {
        this.ticketingInfo = ticketingInfo;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'Number' attribute value. Ticket position related to entire itinerary
     * 
     * @return value
     */
    public int getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' attribute value. Ticket position related to entire itinerary
     * 
     * @param number
     */
    public void setNumber(int number) {
        this.number = number;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOption implements Serializable
    {
        private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();

        /** 
         * Get the list of 'FlightSegment' element items.
         * 
         * @return list
         */
        public List<FlightSegment> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<FlightSegment> list) {
            flightSegmentList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ResponseLocationType" name="DepartureAirport"/>
         *       &lt;xs:element type="ns:ResponseLocationType" name="ArrivalAirport"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="DepartureDateTime"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private ResponseLocationType departureAirport;
            private ResponseLocationType arrivalAirport;
            private String departureDateTime;

            /** 
             * Get the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(
                    ResponseLocationType departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getArrivalAirport() {
                return arrivalAirport;
            }

            /** 
             * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @param arrivalAirport
             */
            public void setArrivalAirport(ResponseLocationType arrivalAirport) {
                this.arrivalAirport = arrivalAirport;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class ValidatingCarrier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private ValidatingCarrier validatingCarrier;

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public ValidatingCarrier getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }
        /** 
         * Issuing airline whose numeric airline code is reflected in the electronic transaction for the flight/value coupon(s).The Validating Carrier shall be the controlling and authorising entity for Electronic Ticketing transactions..
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
}
