
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Paper or e-ticket
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="eTicket"/>
 *     &lt;xs:enumeration value="Paper"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TicketType implements Serializable {
    E_TICKET("eTicket"), PAPER("Paper");
    private final String value;

    private TicketType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TicketType convert(String value) {
        for (TicketType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
