
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Represents Enabled or Disabled status
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ToggleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Enable"/>
 *     &lt;xs:enumeration value="Disable"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ToggleType implements Serializable {
    ENABLE("Enable"), DISABLE("Disable");
    private final String value;

    private ToggleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ToggleType convert(String value) {
        for (ToggleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
