
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * IntelliSell Type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="RequestType" minOccurs="0">
 *       &lt;!-- Reference to inner class RequestType -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ServiceTag" minOccurs="0">
 *       &lt;!-- Reference to inner class ServiceTag -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TravelerPersona" minOccurs="0">
 *       &lt;!-- Reference to inner class TravelerPersona -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PurchaseType" minOccurs="0">
 *       &lt;!-- Reference to inner class PurchaseType -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SabreAth" minOccurs="0">
 *       &lt;!-- Reference to inner class SabreAth -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TranID" minOccurs="0">
 *       &lt;!-- Reference to inner class TranID -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ClientSessionID" minOccurs="0">
 *       &lt;!-- Reference to inner class ClientSessionID -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Branch" minOccurs="0">
 *       &lt;!-- Reference to inner class Branch -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CompressResponse" minOccurs="0">
 *       &lt;!-- Reference to inner class CompressResponse -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareOverrides" minOccurs="0">
 *       &lt;!-- Reference to inner class FareOverrides -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Diagnostics" minOccurs="0">
 *       &lt;!-- Reference to inner class Diagnostics -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SubagentData" minOccurs="0">
 *       &lt;!-- Reference to inner class SubagentData -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ResponseSorting" minOccurs="0">
 *       &lt;!-- Reference to inner class ResponseSorting -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:SeatStatusSimType" name="SeatStatusSim" minOccurs="0"/>
 *     &lt;xs:element name="AvailableLevel" minOccurs="0">
 *       &lt;!-- Reference to inner class AvailableLevel -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ATSETest" minOccurs="0">
 *       &lt;!-- Reference to inner class ATSETest -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AirStreaming" minOccurs="0">
 *       &lt;!-- Reference to inner class AirStreaming -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="MultipleSourcePerItinerary" minOccurs="0">
 *       &lt;!-- Reference to inner class MultipleSourcePerItinerary -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="Debug"/>
 *   &lt;xs:attribute type="xs:string" name="DebugKey"/>
 *   &lt;xs:attribute type="xs:string" name="ConfigSet"/>
 *   &lt;xs:attribute type="xs:boolean" name="DisableCache"/>
 *   &lt;xs:attribute type="xs:string" name="ChunkNumber"/>
 *   &lt;xs:attribute type="xs:boolean" name="ShowItinSource"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionType implements Serializable
{
    private RequestType requestType;
    private ServiceTag serviceTag;
    private TravelerPersona travelerPersona;
    private PurchaseType purchaseType;
    private SabreAth sabreAth;
    private TranID tranID;
    private ClientSessionID clientSessionID;
    private Branch branch;
    private CompressResponse compressResponse;
    private FareOverrides fareOverrides;
    private Diagnostics diagnostics;
    private SubagentData subagentData;
    private ResponseSorting responseSorting;
    private SeatStatusSimType seatStatusSim;
    private AvailableLevel availableLevel;
    private ATSETest ATSETest1;
    private AirStreaming airStreaming;
    private MultipleSourcePerItinerary multipleSourcePerItinerary;
    private Boolean debug;
    private String debugKey;
    private String configSet;
    private Boolean disableCache;
    private String chunkNumber;
    private Boolean showItinSource;

    /** 
     * Get the 'RequestType' element value.
     * 
     * @return value
     */
    public RequestType getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' element value.
     * 
     * @param requestType
     */
    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'ServiceTag' element value.
     * 
     * @return value
     */
    public ServiceTag getServiceTag() {
        return serviceTag;
    }

    /** 
     * Set the 'ServiceTag' element value.
     * 
     * @param serviceTag
     */
    public void setServiceTag(ServiceTag serviceTag) {
        this.serviceTag = serviceTag;
    }

    /** 
     * Get the 'TravelerPersona' element value.
     * 
     * @return value
     */
    public TravelerPersona getTravelerPersona() {
        return travelerPersona;
    }

    /** 
     * Set the 'TravelerPersona' element value.
     * 
     * @param travelerPersona
     */
    public void setTravelerPersona(TravelerPersona travelerPersona) {
        this.travelerPersona = travelerPersona;
    }

    /** 
     * Get the 'PurchaseType' element value.
     * 
     * @return value
     */
    public PurchaseType getPurchaseType() {
        return purchaseType;
    }

    /** 
     * Set the 'PurchaseType' element value.
     * 
     * @param purchaseType
     */
    public void setPurchaseType(PurchaseType purchaseType) {
        this.purchaseType = purchaseType;
    }

    /** 
     * Get the 'SabreAth' element value.
     * 
     * @return value
     */
    public SabreAth getSabreAth() {
        return sabreAth;
    }

    /** 
     * Set the 'SabreAth' element value.
     * 
     * @param sabreAth
     */
    public void setSabreAth(SabreAth sabreAth) {
        this.sabreAth = sabreAth;
    }

    /** 
     * Get the 'TranID' element value.
     * 
     * @return value
     */
    public TranID getTranID() {
        return tranID;
    }

    /** 
     * Set the 'TranID' element value.
     * 
     * @param tranID
     */
    public void setTranID(TranID tranID) {
        this.tranID = tranID;
    }

    /** 
     * Get the 'ClientSessionID' element value.
     * 
     * @return value
     */
    public ClientSessionID getClientSessionID() {
        return clientSessionID;
    }

    /** 
     * Set the 'ClientSessionID' element value.
     * 
     * @param clientSessionID
     */
    public void setClientSessionID(ClientSessionID clientSessionID) {
        this.clientSessionID = clientSessionID;
    }

    /** 
     * Get the 'Branch' element value.
     * 
     * @return value
     */
    public Branch getBranch() {
        return branch;
    }

    /** 
     * Set the 'Branch' element value.
     * 
     * @param branch
     */
    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    /** 
     * Get the 'CompressResponse' element value.
     * 
     * @return value
     */
    public CompressResponse getCompressResponse() {
        return compressResponse;
    }

    /** 
     * Set the 'CompressResponse' element value.
     * 
     * @param compressResponse
     */
    public void setCompressResponse(CompressResponse compressResponse) {
        this.compressResponse = compressResponse;
    }

    /** 
     * Get the 'FareOverrides' element value.
     * 
     * @return value
     */
    public FareOverrides getFareOverrides() {
        return fareOverrides;
    }

    /** 
     * Set the 'FareOverrides' element value.
     * 
     * @param fareOverrides
     */
    public void setFareOverrides(FareOverrides fareOverrides) {
        this.fareOverrides = fareOverrides;
    }

    /** 
     * Get the 'Diagnostics' element value.
     * 
     * @return value
     */
    public Diagnostics getDiagnostics() {
        return diagnostics;
    }

    /** 
     * Set the 'Diagnostics' element value.
     * 
     * @param diagnostics
     */
    public void setDiagnostics(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    /** 
     * Get the 'SubagentData' element value.
     * 
     * @return value
     */
    public SubagentData getSubagentData() {
        return subagentData;
    }

    /** 
     * Set the 'SubagentData' element value.
     * 
     * @param subagentData
     */
    public void setSubagentData(SubagentData subagentData) {
        this.subagentData = subagentData;
    }

    /** 
     * Get the 'ResponseSorting' element value.
     * 
     * @return value
     */
    public ResponseSorting getResponseSorting() {
        return responseSorting;
    }

    /** 
     * Set the 'ResponseSorting' element value.
     * 
     * @param responseSorting
     */
    public void setResponseSorting(ResponseSorting responseSorting) {
        this.responseSorting = responseSorting;
    }

    /** 
     * Get the 'SeatStatusSim' element value.
     * 
     * @return value
     */
    public SeatStatusSimType getSeatStatusSim() {
        return seatStatusSim;
    }

    /** 
     * Set the 'SeatStatusSim' element value.
     * 
     * @param seatStatusSim
     */
    public void setSeatStatusSim(SeatStatusSimType seatStatusSim) {
        this.seatStatusSim = seatStatusSim;
    }

    /** 
     * Get the 'AvailableLevel' element value.
     * 
     * @return value
     */
    public AvailableLevel getAvailableLevel() {
        return availableLevel;
    }

    /** 
     * Set the 'AvailableLevel' element value.
     * 
     * @param availableLevel
     */
    public void setAvailableLevel(AvailableLevel availableLevel) {
        this.availableLevel = availableLevel;
    }

    /** 
     * Get the 'ATSETest' element value.
     * 
     * @return value
     */
    public ATSETest getATSETest1() {
        return ATSETest1;
    }

    /** 
     * Set the 'ATSETest' element value.
     * 
     * @param ATSETest1
     */
    public void setATSETest1(ATSETest ATSETest1) {
        this.ATSETest1 = ATSETest1;
    }

    /** 
     * Get the 'AirStreaming' element value.
     * 
     * @return value
     */
    public AirStreaming getAirStreaming() {
        return airStreaming;
    }

    /** 
     * Set the 'AirStreaming' element value.
     * 
     * @param airStreaming
     */
    public void setAirStreaming(AirStreaming airStreaming) {
        this.airStreaming = airStreaming;
    }

    /** 
     * Get the 'MultipleSourcePerItinerary' element value.
     * 
     * @return value
     */
    public MultipleSourcePerItinerary getMultipleSourcePerItinerary() {
        return multipleSourcePerItinerary;
    }

    /** 
     * Set the 'MultipleSourcePerItinerary' element value.
     * 
     * @param multipleSourcePerItinerary
     */
    public void setMultipleSourcePerItinerary(
            MultipleSourcePerItinerary multipleSourcePerItinerary) {
        this.multipleSourcePerItinerary = multipleSourcePerItinerary;
    }

    /** 
     * Get the 'Debug' attribute value. Turns on or off debug mode.
     * 
     * @return value
     */
    public Boolean getDebug() {
        return debug;
    }

    /** 
     * Set the 'Debug' attribute value. Turns on or off debug mode.
     * 
     * @param debug
     */
    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    /** 
     * Get the 'DebugKey' attribute value. Key unlocking disabled debug mode.
     * 
     * @return value
     */
    public String getDebugKey() {
        return debugKey;
    }

    /** 
     * Set the 'DebugKey' attribute value. Key unlocking disabled debug mode.
     * 
     * @param debugKey
     */
    public void setDebugKey(String debugKey) {
        this.debugKey = debugKey;
    }

    /** 
     * Get the 'ConfigSet' attribute value. Alternative configuration selector.
     * 
     * @return value
     */
    public String getConfigSet() {
        return configSet;
    }

    /** 
     * Set the 'ConfigSet' attribute value. Alternative configuration selector.
     * 
     * @param configSet
     */
    public void setConfigSet(String configSet) {
        this.configSet = configSet;
    }

    /** 
     * Get the 'DisableCache' attribute value. Disables itinerary cache for this request (if it is enabled in this service).
     * 
     * @return value
     */
    public Boolean getDisableCache() {
        return disableCache;
    }

    /** 
     * Set the 'DisableCache' attribute value. Disables itinerary cache for this request (if it is enabled in this service).
     * 
     * @param disableCache
     */
    public void setDisableCache(Boolean disableCache) {
        this.disableCache = disableCache;
    }

    /** 
     * Get the 'ChunkNumber' attribute value. Helps Forwarder in keeping track of response parts generated as a result of request processing (AB only).
     * 
     * @return value
     */
    public String getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'ChunkNumber' attribute value. Helps Forwarder in keeping track of response parts generated as a result of request processing (AB only).
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(String chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'ShowItinSource' attribute value. If enabled, Intellisell will return source for each itinerary.
     * 
     * @return value
     */
    public Boolean getShowItinSource() {
        return showItinSource;
    }

    /** 
     * Set the 'ShowItinSource' attribute value. If enabled, Intellisell will return source for each itinerary.
     * 
     * @param showItinSource
     */
    public void setShowItinSource(Boolean showItinSource) {
        this.showItinSource = showItinSource;
    }
    /** 
     * Identifier of the type of request.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Name"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RequestType implements Serializable
    {
        private String string;
        private String name;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Identifier of the transaction path.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceTag" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Name"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceTag implements Serializable
    {
        private String string;
        private String name;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerPersona" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelerPersona implements Serializable
    {
        private String name;

        /** 
         * Get the 'Name' attribute value. Traveler persona name.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value. Traveler persona name.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * A target available for user, that can be used to create specific rules. For example, if the client wants to target preferred customer request, we can use this element to achieve this.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PurchaseType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PurchaseType implements Serializable
    {
        private String name;

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Sabre authentication ID (ATH) - passed into the request to keep session information when communicating with TPF. The use of this element had been deprecated and is achieved by session pooling mechanism in Intellisell.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreAth" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Value"/>
     *     &lt;xs:attribute type="xs:string" name="BinarySecToken"/>
     *     &lt;xs:attribute type="xs:string" name="ConversationID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SabreAth implements Serializable
    {
        private String value;
        private String binarySecToken;
        private String conversationID;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }

        /** 
         * Get the 'BinarySecToken' attribute value.
         * 
         * @return value
         */
        public String getBinarySecToken() {
            return binarySecToken;
        }

        /** 
         * Set the 'BinarySecToken' attribute value.
         * 
         * @param binarySecToken
         */
        public void setBinarySecToken(String binarySecToken) {
            this.binarySecToken = binarySecToken;
        }

        /** 
         * Get the 'ConversationID' attribute value.
         * 
         * @return value
         */
        public String getConversationID() {
            return conversationID;
        }

        /** 
         * Set the 'ConversationID' attribute value.
         * 
         * @param conversationID
         */
        public void setConversationID(String conversationID) {
            this.conversationID = conversationID;
        }
    }
    /** 
     * Transaction ID.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TranID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TranID implements Serializable
    {
        private String value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
    /** 
     * A unique identifier to relate all transactions within a single session. Used by AirShop/LFE transactions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClientSessionID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ClientSessionID implements Serializable
    {
        private String value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
    /** 
     * Attribute of the Rule that can be passed in to selectively target a rule. This has been deprecated.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Branch" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" default="Main" name="Name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Branch implements Serializable
    {
        private String name;

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Decides if the response should be compressed.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CompressResponse" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CompressResponse implements Serializable
    {
        private Boolean value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public Boolean getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(Boolean value) {
            this.value = value;
        }
    }
    /** 
     * Contains a sequence of fare overrides.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOverrides" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareOverride" maxOccurs="4">
     *         &lt;!-- Reference to inner class FareOverride -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareOverrides implements Serializable
    {
        private List<FareOverride> fareOverrideList = new ArrayList<FareOverride>();

        /** 
         * Get the list of 'FareOverride' element items.
         * 
         * @return list
         */
        public List<FareOverride> getFareOverrideList() {
            return fareOverrideList;
        }

        /** 
         * Set the list of 'FareOverride' element items.
         * 
         * @param list
         */
        public void setFareOverrideList(List<FareOverride> list) {
            fareOverrideList = list;
        }
        /** 
         * Contains attributes of the FareGroup functionality used during shopping and pricing. If passed in this request, it will override setting in the rule.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOverride" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CompanyNamePrefType" name="VendorPref" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="FareType"/>
         *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
         *     &lt;xs:attribute type="xs:string" name="CorporateID"/>
         *     &lt;xs:attribute type="xs:string" use="optional" default="true" name="Callable"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareOverride implements Serializable
        {
            private List<CompanyNamePrefType> vendorPrefList = new ArrayList<CompanyNamePrefType>();
            private String TPAExtensions;
            private String fareType;
            private String pseudoCityCode;
            private String corporateID;
            private String callable;

            /** 
             * Get the list of 'VendorPref' element items. Specify vendors to include and exclude from the response.
             * 
             * @return list
             */
            public List<CompanyNamePrefType> getVendorPrefList() {
                return vendorPrefList;
            }

            /** 
             * Set the list of 'VendorPref' element items. Specify vendors to include and exclude from the response.
             * 
             * @param list
             */
            public void setVendorPrefList(List<CompanyNamePrefType> list) {
                vendorPrefList = list;
            }

            /** 
             * Get the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @return value
             */
            public String getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(String TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'FareType' attribute value. Attribute of FareGroup functionality, used in search of fares during shopping.
             * 
             * @return value
             */
            public String getFareType() {
                return fareType;
            }

            /** 
             * Set the 'FareType' attribute value. Attribute of FareGroup functionality, used in search of fares during shopping.
             * 
             * @param fareType
             */
            public void setFareType(String fareType) {
                this.fareType = fareType;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value.
             * 
             * @return value
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value.
             * 
             * @param pseudoCityCode
             */
            public void setPseudoCityCode(String pseudoCityCode) {
                this.pseudoCityCode = pseudoCityCode;
            }

            /** 
             * Get the 'CorporateID' attribute value. Attribute of FareGroup functionality, used in search of fares during shopping.
             * 
             * @return value
             */
            public String getCorporateID() {
                return corporateID;
            }

            /** 
             * Set the 'CorporateID' attribute value. Attribute of FareGroup functionality, used in search of fares during shopping.
             * 
             * @param corporateID
             */
            public void setCorporateID(String corporateID) {
                this.corporateID = corporateID;
            }

            /** 
             * Get the 'Callable' attribute value. Indicator to enable/disable this FareOverride.
             * 
             * @return value
             */
            public String getCallable() {
                return callable;
            }

            /** 
             * Set the 'Callable' attribute value. Indicator to enable/disable this FareOverride.
             * 
             * @param callable
             */
            public void setCallable(String callable) {
                this.callable = callable;
            }
        }
    }
    /** 
     * For internal use
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostics" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Diagnostic" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Diagnostic -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Diagnostics implements Serializable
    {
        private List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();

        /** 
         * Get the list of 'Diagnostic' element items.
         * 
         * @return list
         */
        public List<Diagnostic> getDiagnosticList() {
            return diagnosticList;
        }

        /** 
         * Set the list of 'Diagnostic' element items.
         * 
         * @param list
         */
        public void setDiagnosticList(List<Diagnostic> list) {
            diagnosticList = list;
        }
        /** 
         * Specify diagnostic code and which service to sent it to.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostic" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DiagnosticArgument" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class DiagnosticArgument -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="Target"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Diagnostic implements Serializable
        {
            private List<DiagnosticArgument> diagnosticArgumentList = new ArrayList<DiagnosticArgument>();
            private String TPAExtensions;
            private String target;
            private String code;

            /** 
             * Get the list of 'DiagnosticArgument' element items.
             * 
             * @return list
             */
            public List<DiagnosticArgument> getDiagnosticArgumentList() {
                return diagnosticArgumentList;
            }

            /** 
             * Set the list of 'DiagnosticArgument' element items.
             * 
             * @param list
             */
            public void setDiagnosticArgumentList(List<DiagnosticArgument> list) {
                diagnosticArgumentList = list;
            }

            /** 
             * Get the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @return value
             */
            public String getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(String TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'Target' attribute value.
             * 
             * @return value
             */
            public String getTarget() {
                return target;
            }

            /** 
             * Set the 'Target' attribute value.
             * 
             * @param target
             */
            public void setTarget(String target) {
                this.target = target;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
            /** 
             * Name-value pairs to be used as arguments for the diagnostic.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiagnosticArgument" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Value"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DiagnosticArgument implements Serializable
            {
                private String name;
                private String value;

                /** 
                 * Get the 'Name' attribute value.
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value.
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'Value' attribute value.
                 * 
                 * @return value
                 */
                public String getValue() {
                    return value;
                }

                /** 
                 * Set the 'Value' attribute value.
                 * 
                 * @param value
                 */
                public void setValue(String value) {
                    this.value = value;
                }
            }
        }
    }
    /** 
     * Subagent data for LFE transactions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubagentData" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SubagentData implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Settings for IntelliSell merchandising
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseSorting" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" name="EnableChronologicalSorting"/>
     *     &lt;xs:attribute type="xs:boolean" name="SortFaresInsideItin"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ResponseSorting implements Serializable
    {
        private Boolean enableChronologicalSorting;
        private Boolean sortFaresInsideItin;

        /** 
         * Get the 'EnableChronologicalSorting' attribute value.
         * 
         * @return value
         */
        public Boolean getEnableChronologicalSorting() {
            return enableChronologicalSorting;
        }

        /** 
         * Set the 'EnableChronologicalSorting' attribute value.
         * 
         * @param enableChronologicalSorting
         */
        public void setEnableChronologicalSorting(
                Boolean enableChronologicalSorting) {
            this.enableChronologicalSorting = enableChronologicalSorting;
        }

        /** 
         * Get the 'SortFaresInsideItin' attribute value.
         * 
         * @return value
         */
        public Boolean getSortFaresInsideItin() {
            return sortFaresInsideItin;
        }

        /** 
         * Set the 'SortFaresInsideItin' attribute value.
         * 
         * @param sortFaresInsideItin
         */
        public void setSortFaresInsideItin(Boolean sortFaresInsideItin) {
            this.sortFaresInsideItin = sortFaresInsideItin;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AvailableLevel" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AvailableLevel implements Serializable
    {
        private String value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
    /** 
     * Allows ATSE Team to test new features. This element and its content is meant to never be published.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ATSETest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Feature"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ATSETest implements Serializable
    {
        private String feature;

        /** 
         * Get the 'Feature' attribute value. Meaning of that attribute is dependent on MIP Team, ISell sends it in all ShoppingRequests when specified.
         * 
         * @return value
         */
        public String getFeature() {
            return feature;
        }

        /** 
         * Set the 'Feature' attribute value. Meaning of that attribute is dependent on MIP Team, ISell sends it in all ShoppingRequests when specified.
         * 
         * @param feature
         */
        public void setFeature(String feature) {
            this.feature = feature;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirStreaming" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute use="required" name="Method">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Method -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:string" use="required" name="MaxItinsPerChunk"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirStreaming implements Serializable
    {
        private Method method;
        private String maxItinsPerChunk;

        /** 
         * Get the 'Method' attribute value.
         * 
         * @return value
         */
        public Method getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' attribute value.
         * 
         * @param method
         */
        public void setMethod(Method method) {
            this.method = method;
        }

        /** 
         * Get the 'MaxItinsPerChunk' attribute value.
         * 
         * @return value
         */
        public String getMaxItinsPerChunk() {
            return maxItinsPerChunk;
        }

        /** 
         * Set the 'MaxItinsPerChunk' attribute value.
         * 
         * @param maxItinsPerChunk
         */
        public void setMaxItinsPerChunk(String maxItinsPerChunk) {
            this.maxItinsPerChunk = maxItinsPerChunk;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Services"/>
         *     &lt;xs:enumeration value="WholeResponse"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Method implements Serializable {
            SERVICES("Services"), WHOLE_RESPONSE("WholeResponse");
            private final String value;

            private Method(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Method convert(String value) {
                for (Method inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleSourcePerItinerary" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MultipleSourcePerItinerary implements Serializable
    {
        private boolean value;

        /** 
         * Get the 'Value' attribute value. Combine solutions from different services/sources as additional fares.
         * 
         * @return value
         */
        public boolean isValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value. Combine solutions from different services/sources as additional fares.
         * 
         * @param value
         */
        public void setValue(boolean value) {
            this.value = value;
        }
    }
}
