
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Date and time of trip, that allows specifying a time window before and after the given date.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelDateTimeType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="DepartureDateTime"/>
 *       &lt;xs:element type="xs:string" name="ArrivalDateTime"/>
 *       &lt;xs:element name="DepartureDates">
 *         &lt;xs:complexType>
 *           &lt;xs:choice maxOccurs="unbounded">
 *             &lt;!-- Reference to inner class DepartureDates -->
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="ArrivalDates">
 *         &lt;xs:complexType>
 *           &lt;xs:group ref="ns:MultipleDatesGroup"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="DepartureWindow" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalWindow" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelDateTimeType implements Serializable
{
    private int choiceSelect = -1;
    private static final int DEPARTURE_DATE_TIME_CHOICE = 0;
    private static final int ARRIVAL_DATE_TIME_CHOICE = 1;
    private static final int DEPARTURE_DATES_CHOICE = 2;
    private static final int ARRIVAL_DATES_CHOICE = 3;
    private String departureDateTime;
    private String arrivalDateTime;
    private List<DepartureDates> departureDateList = new ArrayList<DepartureDates>();
    private MultipleDatesGroup arrivalDates;
    private String departureWindow;
    private String arrivalWindow;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DepartureDateTime is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDepartureDateTime() {
        return choiceSelect == DEPARTURE_DATE_TIME_CHOICE;
    }

    /** 
     * Get the 'DepartureDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @return value
     */
    public String getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(String departureDateTime) {
        setChoiceSelect(DEPARTURE_DATE_TIME_CHOICE);
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Check if ArrivalDateTime is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifArrivalDateTime() {
        return choiceSelect == ARRIVAL_DATE_TIME_CHOICE;
    }

    /** 
     * Get the 'ArrivalDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @return value
     */
    public String getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' element value. This date should be of the form YYYY-MM-DDTHH:MM:SS
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(String arrivalDateTime) {
        setChoiceSelect(ARRIVAL_DATE_TIME_CHOICE);
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Check if DepartureDateList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDepartureDates() {
        return choiceSelect == DEPARTURE_DATES_CHOICE;
    }

    /** 
     * Get the list of 'DepartureDates' element items.
     * 
     * @return list
     */
    public List<DepartureDates> getDepartureDateList() {
        return departureDateList;
    }

    /** 
     * Set the list of 'DepartureDates' element items.
     * 
     * @param list
     */
    public void setDepartureDateList(List<DepartureDates> list) {
        setChoiceSelect(DEPARTURE_DATES_CHOICE);
        departureDateList = list;
    }

    /** 
     * Check if ArrivalDates is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifArrivalDates() {
        return choiceSelect == ARRIVAL_DATES_CHOICE;
    }

    /** 
     * Get the 'MultipleDatesGroup' group value. Allowed only for Advanced Calendar API.
     * 
     * @return value
     */
    public MultipleDatesGroup getArrivalDates() {
        return arrivalDates;
    }

    /** 
     * Set the 'MultipleDatesGroup' group value. Allowed only for Advanced Calendar API.
     * 
     * @param arrivalDates
     */
    public void setArrivalDates(MultipleDatesGroup arrivalDates) {
        setChoiceSelect(ARRIVAL_DATES_CHOICE);
        this.arrivalDates = arrivalDates;
    }

    /** 
     * Get the 'DepartureWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @return value
     */
    public String getDepartureWindow() {
        return departureWindow;
    }

    /** 
     * Set the 'DepartureWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @param departureWindow
     */
    public void setDepartureWindow(String departureWindow) {
        this.departureWindow = departureWindow;
    }

    /** 
     * Get the 'ArrivalWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @return value
     */
    public String getArrivalWindow() {
        return arrivalWindow;
    }

    /** 
     * Set the 'ArrivalWindow' element value. This should be of the form HHMMHHMM.
     * 
     * @param arrivalWindow
     */
    public void setArrivalWindow(String arrivalWindow) {
        this.arrivalWindow = arrivalWindow;
    }
    /** 
     * 
                    If both LengthOfStay (LengthOfStay, LengthOfStayRange) and Days (Day, DaysRange) tags are used, then as requested dates we are considering intersection between two groups of dates, first group is created by sum of dates specified in Day and DaysRange tags, second group is created by LengthOfStay and LengthOfStayRange

                    Example: outbound departing on 2014 Jan 20 and inbound with: LengthOfStayRange/@MinDays="1", LengthOfStayRange/@MaxDays="3", DaysRange/@FromDate="2014-01-22", DaysRange/@ToDate="2014-01-24" after intersection gave us inbound departing range: [ 2014-01-22 ; 2014-01-23 ]
                  
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:group ref="ns:MultipleDatesGroup"/>
     *   &lt;xs:choice maxOccurs="unbounded">
     *     &lt;!-- Reference to inner class Choice -->
     *   &lt;/xs:choice>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class DepartureDates implements Serializable
    {
        private int departureDateListSelect = -1;
        private static final int MULTIPLE_DATES_GROUP_CHOICE = 0;
        private static final int CHOICE_LIST_CHOICE = 1;
        private MultipleDatesGroup multipleDatesGroup;
        private List<Choice> choiceList = new ArrayList<Choice>();

        private void setDepartureDateListSelect(int choice) {
            if (departureDateListSelect == -1) {
                departureDateListSelect = choice;
            } else if (departureDateListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearDepartureDateListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearDepartureDateListSelect() {
            departureDateListSelect = -1;
        }

        /** 
         * Check if MultipleDatesGroup is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMultipleDatesGroup() {
            return departureDateListSelect == MULTIPLE_DATES_GROUP_CHOICE;
        }

        /** 
         * Get the 'MultipleDatesGroup' group value.
         * 
         * @return value
         */
        public MultipleDatesGroup getMultipleDatesGroup() {
            return multipleDatesGroup;
        }

        /** 
         * Set the 'MultipleDatesGroup' group value.
         * 
         * @param multipleDatesGroup
         */
        public void setMultipleDatesGroup(MultipleDatesGroup multipleDatesGroup) {
            setDepartureDateListSelect(MULTIPLE_DATES_GROUP_CHOICE);
            this.multipleDatesGroup = multipleDatesGroup;
        }

        /** 
         * Check if ChoiceList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifChoiceList() {
            return departureDateListSelect == CHOICE_LIST_CHOICE;
        }

        /** 
         * Get the list of choice items.
         * 
         * @return list
         */
        public List<Choice> getChoiceList() {
            return choiceList;
        }

        /** 
         * Set the list of choice items.
         * 
         * @param list
         */
        public void setChoiceList(List<Choice> list) {
            setDepartureDateListSelect(CHOICE_LIST_CHOICE);
            choiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
         *   &lt;xs:element name="LengthOfStay">
         *     &lt;xs:complexType>
         *       &lt;xs:attribute type="xs:unsignedShort" use="required" name="Days"/>
         *     &lt;/xs:complexType>
         *   &lt;/xs:element>
         *   &lt;xs:element name="LengthOfStayRange">
         *     &lt;xs:complexType>
         *       &lt;xs:attribute type="xs:unsignedShort" use="required" name="MinDays"/>
         *       &lt;xs:attribute type="xs:unsignedShort" use="required" name="MaxDays"/>
         *     &lt;/xs:complexType>
         *   &lt;/xs:element>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceListSelect = -1;
            private static final int LENGTH_OF_STAY_CHOICE = 0;
            private static final int LENGTH_OF_STAY_RANGE_CHOICE = 1;
            private String lengthOfStay;
            private String lengthOfStayRangeMinDays;
            private String lengthOfStayRangeMaxDays;

            private void setChoiceListSelect(int choice) {
                if (choiceListSelect == -1) {
                    choiceListSelect = choice;
                } else if (choiceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceListSelect() {
                choiceListSelect = -1;
            }

            /** 
             * Check if LengthOfStay is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifLengthOfStay() {
                return choiceListSelect == LENGTH_OF_STAY_CHOICE;
            }

            /** 
             * Get the 'Days' attribute value. 
                            Amount of days between previous leg's DEPARTURE date and current leg's DEPARTURE date. NOTE: Allowed only in 2nd or further "OriginDestinationInformation".

                            Example: for outbound departing on Jan 20, LengthOfStay/@Days="2" means inbound departing on Jan 22.
                          
             * 
             * @return value
             */
            public String getLengthOfStay() {
                return lengthOfStay;
            }

            /** 
             * Set the 'Days' attribute value. 
                            Amount of days between previous leg's DEPARTURE date and current leg's DEPARTURE date. NOTE: Allowed only in 2nd or further "OriginDestinationInformation".

                            Example: for outbound departing on Jan 20, LengthOfStay/@Days="2" means inbound departing on Jan 22.
                          
             * 
             * @param lengthOfStay
             */
            public void setLengthOfStay(String lengthOfStay) {
                setChoiceListSelect(LENGTH_OF_STAY_CHOICE);
                this.lengthOfStay = lengthOfStay;
            }

            /** 
             * Check if LengthOfStayRange is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifLengthOfStayRange() {
                return choiceListSelect == LENGTH_OF_STAY_RANGE_CHOICE;
            }

            /** 
             * Get the 'MinDays' attribute value. (inclusive)
             * 
             * @return value
             */
            public String getLengthOfStayRangeMinDays() {
                return lengthOfStayRangeMinDays;
            }

            /** 
             * Set the 'MinDays' attribute value. (inclusive)
             * 
             * @param lengthOfStayRangeMinDays
             */
            public void setLengthOfStayRangeMinDays(
                    String lengthOfStayRangeMinDays) {
                setChoiceListSelect(LENGTH_OF_STAY_RANGE_CHOICE);
                this.lengthOfStayRangeMinDays = lengthOfStayRangeMinDays;
            }

            /** 
             * Get the 'MaxDays' attribute value. (inclusive)
             * 
             * @return value
             */
            public String getLengthOfStayRangeMaxDays() {
                return lengthOfStayRangeMaxDays;
            }

            /** 
             * Set the 'MaxDays' attribute value. (inclusive)
             * 
             * @param lengthOfStayRangeMaxDays
             */
            public void setLengthOfStayRangeMaxDays(
                    String lengthOfStayRangeMaxDays) {
                setChoiceListSelect(LENGTH_OF_STAY_RANGE_CHOICE);
                this.lengthOfStayRangeMaxDays = lengthOfStayRangeMaxDays;
            }
        }
    }
}
