
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * OnlineIndicator and InterlineIndicator are mutually exclusive. One of the two is required.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPreferencesTPA_ExtensionsOnlineInterlineIndicatorGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OnlineIndicator" minOccurs="0">
 *       &lt;!-- Reference to inner class OnlineIndicator -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="InterlineIndicator" minOccurs="0">
 *       &lt;!-- Reference to inner class InterlineIndicator -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class TravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup
    implements Serializable
{
    private OnlineIndicator onlineIndicator;
    private InterlineIndicator interlineIndicator;

    /** 
     * Get the 'OnlineIndicator' element value.
     * 
     * @return value
     */
    public OnlineIndicator getOnlineIndicator() {
        return onlineIndicator;
    }

    /** 
     * Set the 'OnlineIndicator' element value.
     * 
     * @param onlineIndicator
     */
    public void setOnlineIndicator(OnlineIndicator onlineIndicator) {
        this.onlineIndicator = onlineIndicator;
    }

    /** 
     * Get the 'InterlineIndicator' element value.
     * 
     * @return value
     */
    public InterlineIndicator getInterlineIndicator() {
        return interlineIndicator;
    }

    /** 
     * Set the 'InterlineIndicator' element value.
     * 
     * @param interlineIndicator
     */
    public void setInterlineIndicator(InterlineIndicator interlineIndicator) {
        this.interlineIndicator = interlineIndicator;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnlineIndicator" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OnlineIndicator implements Serializable
    {
        private Boolean ind;

        /** 
         * Get the 'Ind' attribute value. If true, only Online itineraries are returned.
         * 
         * @return value
         */
        public Boolean getInd() {
            return ind;
        }

        /** 
         * Set the 'Ind' attribute value. If true, only Online itineraries are returned.
         * 
         * @param ind
         */
        public void setInd(Boolean ind) {
            this.ind = ind;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InterlineIndicator" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class InterlineIndicator implements Serializable
    {
        private Boolean ind;

        /** 
         * Get the 'Ind' attribute value. If true, only Interline itineraries are returned.
         * 
         * @return value
         */
        public Boolean getInd() {
            return ind;
        }

        /** 
         * Set the 'Ind' attribute value. If true, only Interline itineraries are returned.
         * 
         * @param ind
         */
        public void setInd(Boolean ind) {
            this.ind = ind;
        }
    }
}
