
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPreferencesTPA_ExtensionsTaxesGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ExemptAllTaxes" minOccurs="0">
 *       &lt;!-- Reference to inner class ExemptAllTaxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ExemptAllTaxesAndFees" minOccurs="0">
 *       &lt;!-- Reference to inner class ExemptAllTaxesAndFees -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Taxes" minOccurs="0">
 *       &lt;!-- Reference to inner class Taxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TaxCodeType" name="ExemptTax" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class TravelPreferencesTPAExtensionsTaxesGroup implements Serializable
{
    private ExemptAllTaxes exemptAllTaxes;
    private ExemptAllTaxesAndFees exemptAllTaxesAndFees;
    private Taxes taxes;
    private List<TaxCodeType> exemptTaxList = new ArrayList<TaxCodeType>();

    /** 
     * Get the 'ExemptAllTaxes' element value.
     * 
     * @return value
     */
    public ExemptAllTaxes getExemptAllTaxes() {
        return exemptAllTaxes;
    }

    /** 
     * Set the 'ExemptAllTaxes' element value.
     * 
     * @param exemptAllTaxes
     */
    public void setExemptAllTaxes(ExemptAllTaxes exemptAllTaxes) {
        this.exemptAllTaxes = exemptAllTaxes;
    }

    /** 
     * Get the 'ExemptAllTaxesAndFees' element value.
     * 
     * @return value
     */
    public ExemptAllTaxesAndFees getExemptAllTaxesAndFees() {
        return exemptAllTaxesAndFees;
    }

    /** 
     * Set the 'ExemptAllTaxesAndFees' element value.
     * 
     * @param exemptAllTaxesAndFees
     */
    public void setExemptAllTaxesAndFees(
            ExemptAllTaxesAndFees exemptAllTaxesAndFees) {
        this.exemptAllTaxesAndFees = exemptAllTaxesAndFees;
    }

    /** 
     * Get the 'Taxes' element value.
     * 
     * @return value
     */
    public Taxes getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value.
     * 
     * @param taxes
     */
    public void setTaxes(Taxes taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the list of 'ExemptTax' element items. Exempt Tax (/TE)
     * 
     * @return list
     */
    public List<TaxCodeType> getExemptTaxList() {
        return exemptTaxList;
    }

    /** 
     * Set the list of 'ExemptTax' element items. Exempt Tax (/TE)
     * 
     * @param list
     */
    public void setExemptTaxList(List<TaxCodeType> list) {
        exemptTaxList = list;
    }
    /** 
     * Exempt all taxes (/TE)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExemptAllTaxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ExemptAllTaxes implements Serializable
    {
        private boolean value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public boolean isValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(boolean value) {
            this.value = value;
        }
    }
    /** 
     * Exempt all taxes and fees (/TN)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExemptAllTaxesAndFees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ExemptAllTaxesAndFees implements Serializable
    {
        private boolean value;

        /** 
         * Get the 'Value' attribute value.
         * 
         * @return value
         */
        public boolean isValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value.
         * 
         * @param value
         */
        public void setValue(boolean value) {
            this.value = value;
        }
    }
    /** 
     * Specify Taxes (/TX)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:TaxCodeAmountType" name="Tax" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:TaxCodeType" name="IsRefundable" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Taxes implements Serializable
    {
        private List<TaxCodeAmountType> taxList = new ArrayList<TaxCodeAmountType>();
        private List<TaxCodeType> isRefundableList = new ArrayList<TaxCodeType>();

        /** 
         * Get the list of 'Tax' element items. Specify tax amount and code.
         * 
         * @return list
         */
        public List<TaxCodeAmountType> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items. Specify tax amount and code.
         * 
         * @param list
         */
        public void setTaxList(List<TaxCodeAmountType> list) {
            taxList = list;
        }

        /** 
         * Get the list of 'IsRefundable' element items. Validates if given tax is refundable or not
         * 
         * @return list
         */
        public List<TaxCodeType> getIsRefundableList() {
            return isRefundableList;
        }

        /** 
         * Set the list of 'IsRefundable' element items. Validates if given tax is refundable or not
         * 
         * @param list
         */
        public void setIsRefundableList(List<TaxCodeType> list) {
            isRefundableList = list;
        }
    }
}
