
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerInfoSummary_TPA_ExtensionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TravelerRating" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TravelerRating -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerInfoSummaryTPAExtensionsType implements Serializable
{
    private List<TravelerRating> travelerRatingList = new ArrayList<TravelerRating>();

    /** 
     * Get the list of 'TravelerRating' element items.
     * 
     * @return list
     */
    public List<TravelerRating> getTravelerRatingList() {
        return travelerRatingList;
    }

    /** 
     * Set the list of 'TravelerRating' element items.
     * 
     * @param list
     */
    public void setTravelerRatingList(List<TravelerRating> list) {
        travelerRatingList = list;
    }
    /** 
     * Customer Value Scores and Frequent Flyer Tiers for one traveler. It can influence Availability results when provided.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerRating" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Score" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Score -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FrequentFlyer -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelerRating implements Serializable
    {
        private List<Score> scoreList = new ArrayList<Score>();
        private List<FrequentFlyer> frequentFlyerList = new ArrayList<FrequentFlyer>();

        /** 
         * Get the list of 'Score' element items.
         * 
         * @return list
         */
        public List<Score> getScoreList() {
            return scoreList;
        }

        /** 
         * Set the list of 'Score' element items.
         * 
         * @param list
         */
        public void setScoreList(List<Score> list) {
            scoreList = list;
        }

        /** 
         * Get the list of 'FrequentFlyer' element items.
         * 
         * @return list
         */
        public List<FrequentFlyer> getFrequentFlyerList() {
            return frequentFlyerList;
        }

        /** 
         * Set the list of 'FrequentFlyer' element items.
         * 
         * @param list
         */
        public void setFrequentFlyerList(List<FrequentFlyer> list) {
            frequentFlyerList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Score" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Value"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Carrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Score implements Serializable
        {
            private BigInteger value;
            private String carrier;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public BigInteger getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(BigInteger value) {
                this.value = value;
            }

            /** 
             * Get the 'Carrier' attribute value.
             * 
             * @return value
             */
            public String getCarrier() {
                return carrier;
            }

            /** 
             * Set the 'Carrier' attribute value.
             * 
             * @param carrier
             */
            public void setCarrier(String carrier) {
                this.carrier = carrier;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Tier"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Carrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FrequentFlyer implements Serializable
        {
            private BigInteger tier;
            private String carrier;

            /** 
             * Get the 'Tier' attribute value.
             * 
             * @return value
             */
            public BigInteger getTier() {
                return tier;
            }

            /** 
             * Set the 'Tier' attribute value.
             * 
             * @param tier
             */
            public void setTier(BigInteger tier) {
                this.tier = tier;
            }

            /** 
             * Get the 'Carrier' attribute value.
             * 
             * @return value
             */
            public String getCarrier() {
                return carrier;
            }

            /** 
             * Set the 'Carrier' attribute value.
             * 
             * @param carrier
             */
            public void setCarrier(String carrier) {
                this.carrier = carrier;
            }
        }
    }
}
