
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies passenger numbers and types.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerInfoSummaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="SeatsRequested" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="ns:TravelerInformationType" name="AirTravelerAvail" minOccurs="1" maxOccurs="4"/>
 *     &lt;xs:element type="ns:PriceRequestInformationType" name="PriceRequestInformation" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerInfoSummary_TPA_ExtensionsType" name="TPA_Extensions" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SpecificPTC_Indicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerInfoSummaryType implements Serializable
{
    private List<BigInteger> seatsRequestedList = new ArrayList<BigInteger>();
    private List<TravelerInformationType> airTravelerAvailList = new ArrayList<TravelerInformationType>();
    private PriceRequestInformationType priceRequestInformation;
    private TravelerInfoSummaryTPAExtensionsType TPAExtensions;
    private Boolean specificPTCIndicator;

    /** 
     * Get the list of 'SeatsRequested' element items. The sum of all seats required by all passenger groups.
     * 
     * @return list
     */
    public List<BigInteger> getSeatsRequestedList() {
        return seatsRequestedList;
    }

    /** 
     * Set the list of 'SeatsRequested' element items. The sum of all seats required by all passenger groups.
     * 
     * @param list
     */
    public void setSeatsRequestedList(List<BigInteger> list) {
        seatsRequestedList = list;
    }

    /** 
     * Get the list of 'AirTravelerAvail' element items. Specifies passenger numbers and types.
     * 
     * @return list
     */
    public List<TravelerInformationType> getAirTravelerAvailList() {
        return airTravelerAvailList;
    }

    /** 
     * Set the list of 'AirTravelerAvail' element items. Specifies passenger numbers and types.
     * 
     * @param list
     */
    public void setAirTravelerAvailList(List<TravelerInformationType> list) {
        airTravelerAvailList = list;
    }

    /** 
     * Get the 'PriceRequestInformation' element value. Identify pricing source, if negotiated fares are requested and if it is a reprice request.
     * 
     * @return value
     */
    public PriceRequestInformationType getPriceRequestInformation() {
        return priceRequestInformation;
    }

    /** 
     * Set the 'PriceRequestInformation' element value. Identify pricing source, if negotiated fares are requested and if it is a reprice request.
     * 
     * @param priceRequestInformation
     */
    public void setPriceRequestInformation(
            PriceRequestInformationType priceRequestInformation) {
        this.priceRequestInformation = priceRequestInformation;
    }

    /** 
     * Get the 'TPA_Extensions' element value. Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * @return value
     */
    public TravelerInfoSummaryTPAExtensionsType getTPAExtensions() {
        return TPAExtensions;
    }

    /** 
     * Set the 'TPA_Extensions' element value. Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * @param TPAExtensions
     */
    public void setTPAExtensions(
            TravelerInfoSummaryTPAExtensionsType TPAExtensions) {
        this.TPAExtensions = TPAExtensions;
    }

    /** 
     * Get the 'SpecificPTC_Indicator' attribute value. If true, this request is for a specific PTC and only fares applicable to that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
     * 
     * @return value
     */
    public Boolean getSpecificPTCIndicator() {
        return specificPTCIndicator;
    }

    /** 
     * Set the 'SpecificPTC_Indicator' attribute value. If true, this request is for a specific PTC and only fares applicable to that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
     * 
     * @param specificPTCIndicator
     */
    public void setSpecificPTCIndicator(Boolean specificPTCIndicator) {
        this.specificPTCIndicator = specificPTCIndicator;
    }
}
