
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VCTRAttributeGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Vendor"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SourceVendor"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Tariff"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RuleNumber"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class VCTRAttributeGroup implements Serializable
{
    private String vendor;
    private String sourceVendor;
    private String tariff;
    private String ruleNumber;

    /** 
     * Get the 'Vendor' attribute value. Vendor (note: last Flight in Fare Component)
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' attribute value. Vendor (note: last Flight in Fare Component)
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'SourceVendor' attribute value. Fare Source Vendor (note: last Flight in Fare Component)
     * 
     * @return value
     */
    public String getSourceVendor() {
        return sourceVendor;
    }

    /** 
     * Set the 'SourceVendor' attribute value. Fare Source Vendor (note: last Flight in Fare Component)
     * 
     * @param sourceVendor
     */
    public void setSourceVendor(String sourceVendor) {
        this.sourceVendor = sourceVendor;
    }

    /** 
     * Get the 'Tariff' attribute value. Tariff (note: last Flight in Fare Component)
     * 
     * @return value
     */
    public String getTariff() {
        return tariff;
    }

    /** 
     * Set the 'Tariff' attribute value. Tariff (note: last Flight in Fare Component)
     * 
     * @param tariff
     */
    public void setTariff(String tariff) {
        this.tariff = tariff;
    }

    /** 
     * Get the 'RuleNumber' attribute value. Rule Number (note: last Flight in Fare Component)
     * 
     * @return value
     */
    public String getRuleNumber() {
        return ruleNumber;
    }

    /** 
     * Set the 'RuleNumber' attribute value. Rule Number (note: last Flight in Fare Component)
     * 
     * @param ruleNumber
     */
    public void setRuleNumber(String ruleNumber) {
        this.ruleNumber = ruleNumber;
    }
}
