
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidInterlineType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Yes"/>
 *     &lt;xs:enumeration value="No"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ValidInterlineType implements Serializable {
    YES("Yes"), NO("No"), UNKNOWN("Unknown");
    private final String value;

    private ValidInterlineType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ValidInterlineType convert(String value) {
        for (ValidInterlineType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
